/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.util.List;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanEvent;
import org.apache.avro.ipc.trace.TimestampedEvent;
import org.apache.avro.ipc.trace.Util;

public class TraceNode {
    public Span span;
    public List<TraceNode> children;

    public TraceNode(Span span2, List<TraceNode> children2) {
        this.span = span2;
        this.children = children2;
    }

    public long extractEventTime(TraceNode tn, SpanEvent e) {
        for (TimestampedEvent te : tn.span.events) {
            if (!(te.event instanceof SpanEvent) || (SpanEvent)((Object)te.event) != e) continue;
            return te.timeStamp;
        }
        return -1L;
    }

    public long getPreLinkTime() {
        long clientSend = this.extractEventTime(this, SpanEvent.CLIENT_SEND);
        long serverReceive = this.extractEventTime(this, SpanEvent.SERVER_RECV);
        return serverReceive - clientSend;
    }

    public String getPreLinkTimeString() {
        return Util.printableTime(this.getPreLinkTime());
    }

    public long getPostLinkTime() {
        long serverSend = this.extractEventTime(this, SpanEvent.SERVER_SEND);
        long clientReceive = this.extractEventTime(this, SpanEvent.CLIENT_RECV);
        return clientReceive - serverSend;
    }

    public String getPostLinkTimeString() {
        return Util.printableTime(this.getPreLinkTime());
    }

    public long getProcessTime() {
        long serverReceive = this.extractEventTime(this, SpanEvent.SERVER_RECV);
        long serverSend = this.extractEventTime(this, SpanEvent.SERVER_SEND);
        return serverSend - serverReceive;
    }

    public String getProcessTimeString() {
        return Util.printableTime(this.getProcessTime());
    }

    public List<TraceNode> getChildren() {
        return this.children;
    }

    public String getRequestPayloadSize() {
        return Util.printableBytes(this.span.requestPayloadSize);
    }

    public String getResponsePayloadSize() {
        return Util.printableBytes(this.span.responsePayloadSize);
    }

    public String getRequestorHostname() {
        return this.span.requestorHostname.toString();
    }

    public String getResponderHostname() {
        return this.span.responderHostname.toString();
    }

    public String getMessageName() {
        return this.span.messageName.toString();
    }

    public String getLatencyTimeString() {
        return Util.printableTime(this.getPreLinkTime() + this.getProcessTime() + this.getPostLinkTime());
    }
}

