/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanEvent;
import org.apache.avro.ipc.trace.TimestampedEvent;
import org.apache.avro.ipc.trace.TraceNode;
import org.apache.avro.ipc.trace.Util;

public class Trace {
    private TraceNode root;

    public Trace(TraceNode root2) {
        this.root = root2;
    }

    public TraceNode getRoot() {
        return this.root;
    }

    public int executionPathHash() {
        return this.printBrief().hashCode();
    }

    public String printBrief() {
        if (this.root == null) {
            return "Trace: <empty>";
        }
        String out = "Trace: (";
        out = out + this.root.span.messageName + " ";
        out = out + this.printBriefRecurse(this.root.children);
        out = out + ")";
        return out;
    }

    private String printBriefRecurse(List<TraceNode> children2) {
        String out = "";
        Collections.sort(children2, new NodeComparator());
        for (int i = 0; i < children2.size(); ++i) {
            TraceNode tn = children2.get(i);
            out = out + "(" + tn.span.messageName;
            if (tn.children.size() > 0) {
                out = out + " ";
                out = out + this.printBriefRecurse(tn.children);
            }
            out = out + ")";
            if (i == children2.size() - 1) continue;
            out = out + " ";
        }
        return out;
    }

    public String printWithTiming() {
        if (this.root == null) {
            return "Trace: <empty>";
        }
        String out = "Trace: \n";
        LinkedList<TraceNode> rootList = new LinkedList<TraceNode>();
        rootList.add(this.root);
        out = out + this.printWithTimingRecurse(rootList, 0);
        return out;
    }

    private String printWithTimingRecurse(List<TraceNode> children2, int depth) {
        String out = "";
        Collections.sort(children2, new NodeComparator());
        for (TraceNode tn : children2) {
            long clientSend = 0L;
            long clientReceive = 0L;
            for (TimestampedEvent te : tn.span.events) {
                if (!(te.event instanceof SpanEvent)) continue;
                SpanEvent ev = (SpanEvent)((Object)te.event);
                if (ev.equals((Object)SpanEvent.CLIENT_RECV)) {
                    clientReceive = te.timeStamp / 1000000L;
                    continue;
                }
                if (!ev.equals((Object)SpanEvent.CLIENT_SEND)) continue;
                clientSend = te.timeStamp / 1000000L;
            }
            for (int i = 0; i < depth; ++i) {
                out = out + "  ";
            }
            out = out + tn.span.messageName + " " + (clientReceive - clientSend) + "ms\n";
            if (tn.children.size() <= 0) continue;
            out = out + this.printWithTimingRecurse(tn.children, depth + 1);
        }
        return out;
    }

    public static Trace extractTrace(List<Span> spans) {
        HashMap<Long, List<Long>> children2 = new HashMap<Long, List<Long>>();
        HashMap<Long, Span> spanRef = new HashMap<Long, Span>();
        Span rootSpan = null;
        for (Span s2 : spans) {
            spanRef.put(Util.longValue(s2.spanID), s2);
            if (s2.parentSpanID == null) {
                rootSpan = s2;
                continue;
            }
            if (children2.get(Util.longValue(s2.parentSpanID)) == null) {
                LinkedList<Long> list2 = new LinkedList<Long>();
                list2.add(Util.longValue(s2.spanID));
                children2.put(Util.longValue(s2.parentSpanID), list2);
                continue;
            }
            children2.get(Util.longValue(s2.parentSpanID)).add(Util.longValue(s2.spanID));
        }
        if (rootSpan == null) {
            return null;
        }
        TraceNode rootNode = Trace.getNode(rootSpan, spanRef, children2);
        return new Trace(rootNode);
    }

    private static TraceNode getNode(Span s2, HashMap<Long, Span> spanRef, HashMap<Long, List<Long>> children2) {
        TraceNode out = new TraceNode(s2, new LinkedList<TraceNode>());
        List<Long> kids = children2.get(Util.longValue(s2.spanID));
        if (kids == null) {
            return out;
        }
        for (long childID : kids) {
            Span childSpan = spanRef.get(childID);
            if (childSpan == null) {
                return null;
            }
            out.children.add(Trace.getNode(childSpan, spanRef, children2));
        }
        return out;
    }

    private class NodeComparator
    implements Comparator<TraceNode> {
        private NodeComparator() {
        }

        @Override
        public int compare(TraceNode tn0, TraceNode tn1) {
            int result2 = tn0.span.messageName.compareTo(tn1.span.messageName);
            if (result2 != 0) {
                return result2;
            }
            Long tn0SendTime = tn0.extractEventTime(tn0, SpanEvent.CLIENT_SEND);
            Long tn1SendTime = tn1.extractEventTime(tn1, SpanEvent.CLIENT_SEND);
            return tn0SendTime.compareTo(tn1SendTime);
        }
    }
}

