/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.trace.ID;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanAggregator;
import org.apache.avro.ipc.trace.SpanEvent;
import org.apache.avro.ipc.trace.TimestampedEvent;
import org.apache.avro.ipc.trace.Trace;
import org.apache.avro.ipc.trace.Util;
import org.junit.Assert;
import org.junit.Test;

public class TestSpanAggregation {
    @Test
    public void testSpanCompletion1() {
        Span span1a = this.createClientSpan(Util.idValue(1L), Util.idValue(1L), null, new String("a"));
        span1a.setRequestPayloadSize(10L);
        span1a.setResponsePayloadSize(0L);
        Span span1b = this.createServerSpan(Util.idValue(1L), Util.idValue(1L), null, new String("a"));
        span1b.setRequestPayloadSize(0L);
        span1b.setResponsePayloadSize(11L);
        ArrayList<Span> partials = new ArrayList<Span>();
        partials.add(span1a);
        partials.add(span1b);
        SpanAggregator.SpanAggregationResults results2 = SpanAggregator.getFullSpans(partials);
        Assert.assertNotNull(results2.completeSpans);
        Assert.assertNotNull(results2.incompleteSpans);
        Assert.assertTrue((results2.incompleteSpans.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((results2.completeSpans.size() == 1 ? 1 : 0) != 0);
        Span result2 = results2.completeSpans.get(0);
        Assert.assertEquals(null, (Object)result2.getParentSpanID());
        Assert.assertTrue((boolean)Util.idsEqual(Util.idValue(1L), result2.getSpanID()));
        Assert.assertEquals((long)4L, (long)result2.getEvents().size());
        Assert.assertEquals((Object)new Long(10L), (Object)result2.getRequestPayloadSize());
        Assert.assertEquals((Object)new Long(11L), (Object)result2.getResponsePayloadSize());
    }

    @Test
    public void testInvalidSpanCompletion() {
        Span span1a = this.createClientSpan(Util.idValue(1L), Util.idValue(1L), null, new String("a"));
        Span span1b = this.createServerSpan(Util.idValue(1L), Util.idValue(1L), null, new String("a"));
        Span spanBogus1 = this.createClientSpan(Util.idValue(1L), Util.idValue(10L), Util.idValue(3L), new String("not"));
        Span spanBogus2 = this.createServerSpan(Util.idValue(1L), Util.idValue(10L), Util.idValue(3L), new String("equal"));
        Span spanBogus3 = this.createClientSpan(Util.idValue(1L), Util.idValue(5L), Util.idValue(2L), new String("equal"));
        Span spanBogus4 = this.createServerSpan(Util.idValue(1L), Util.idValue(5L), Util.idValue(3L), new String("equal"));
        Span spanBogus5 = this.createClientSpan(Util.idValue(1L), Util.idValue(4L), Util.idValue(1L), new String("alone"));
        ArrayList<Span> partials = new ArrayList<Span>();
        partials.add(span1a);
        partials.add(span1b);
        partials.add(spanBogus1);
        partials.add(spanBogus2);
        partials.add(spanBogus3);
        partials.add(spanBogus4);
        partials.add(spanBogus5);
        SpanAggregator.SpanAggregationResults results2 = SpanAggregator.getFullSpans(partials);
        Assert.assertNotNull(results2.completeSpans);
        Assert.assertNotNull(results2.incompleteSpans);
        Assert.assertTrue((results2.incompleteSpans.size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)results2.incompleteSpans.contains(spanBogus1));
        Assert.assertTrue((boolean)results2.incompleteSpans.contains(spanBogus2));
        Assert.assertTrue((boolean)results2.incompleteSpans.contains(spanBogus3));
        Assert.assertTrue((boolean)results2.incompleteSpans.contains(spanBogus4));
        Assert.assertTrue((boolean)results2.incompleteSpans.contains(spanBogus5));
        Assert.assertTrue((results2.completeSpans.size() == 1 ? 1 : 0) != 0);
        Span result2 = results2.completeSpans.get(0);
        Assert.assertTrue((boolean)result2.getComplete());
        Assert.assertTrue((boolean)Util.idsEqual(Util.idValue(1L), result2.getSpanID()));
        Assert.assertEquals((Object)new String("requestorHostname"), (Object)result2.getRequestorHostname());
        Assert.assertEquals((Object)new String("responderHostname"), (Object)result2.getResponderHostname());
        Assert.assertNull((Object)result2.getParentSpanID());
        Assert.assertEquals((Object)new String("a"), (Object)result2.getMessageName());
    }

    @Test
    public void testTraceFormation1() {
        Span a1 = this.createClientSpan(Util.idValue(1L), Util.idValue(1L), null, new String("a"));
        Span a2 = this.createServerSpan(Util.idValue(1L), Util.idValue(1L), null, new String("a"));
        Span b1 = this.createClientSpan(Util.idValue(1L), Util.idValue(2L), Util.idValue(1L), new String("b"));
        Span b2 = this.createServerSpan(Util.idValue(1L), Util.idValue(2L), Util.idValue(1L), new String("b"));
        Span c1 = this.createClientSpan(Util.idValue(1L), Util.idValue(3L), Util.idValue(2L), new String("c"));
        Span c2 = this.createServerSpan(Util.idValue(1L), Util.idValue(3L), Util.idValue(2L), new String("c"));
        Span d1 = this.createClientSpan(Util.idValue(1L), Util.idValue(4L), Util.idValue(2L), new String("d"));
        Span d2 = this.createServerSpan(Util.idValue(1L), Util.idValue(4L), Util.idValue(2L), new String("d"));
        Span e1 = this.createClientSpan(Util.idValue(1L), Util.idValue(5L), Util.idValue(4L), new String("e"));
        Span e2 = this.createServerSpan(Util.idValue(1L), Util.idValue(5L), Util.idValue(4L), new String("e"));
        LinkedList<Span> spans = new LinkedList<Span>();
        spans.addAll(Arrays.asList(a1, a2, b1, b2, c1, c2, d1, d2, e1, e2));
        List<Span> merged = SpanAggregator.getFullSpans(spans).completeSpans;
        Assert.assertEquals((long)5L, (long)merged.size());
        for (Span s2 : merged) {
            Assert.assertEquals((Object)new String("requestorHostname"), (Object)s2.getRequestorHostname());
            Assert.assertEquals((Object)new String("responderHostname"), (Object)s2.getResponderHostname());
        }
        List<Trace> traces = SpanAggregator.getTraces(merged).traces;
        Assert.assertEquals((long)1L, (long)traces.size());
        Assert.assertEquals((Object)"Trace: (a (b (c) (d (e))))", (Object)traces.get(0).printBrief());
    }

    public Span createClientSpan(ID traceID, ID spanID, ID parentID, String msgName) {
        Span out = new Span();
        out.setSpanID(spanID);
        out.setTraceID(traceID);
        out.setRequestorHostname(new String("requestorHostname"));
        if (parentID != null) {
            out.setParentSpanID(parentID);
        }
        out.setMessageName(msgName);
        out.setComplete(false);
        TimestampedEvent event1 = new TimestampedEvent();
        event1.setEvent((Object)SpanEvent.CLIENT_SEND);
        event1.setTimeStamp(System.currentTimeMillis() * 1000000L);
        TimestampedEvent event2 = new TimestampedEvent();
        event2.setEvent((Object)SpanEvent.CLIENT_RECV);
        event2.setTimeStamp(System.currentTimeMillis() * 1000000L);
        out.setEvents(new GenericData.Array<TimestampedEvent>(2, Schema.createArray(TimestampedEvent.SCHEMA$)));
        out.getEvents().add(event1);
        out.getEvents().add(event2);
        return out;
    }

    public Span createServerSpan(ID traceID, ID spanID, ID parentID, String msgName) {
        Span out = new Span();
        out.setSpanID(spanID);
        out.setTraceID(traceID);
        out.setResponderHostname(new String("responderHostname"));
        if (parentID != null) {
            out.setParentSpanID(parentID);
        }
        out.setMessageName(msgName);
        out.setComplete(false);
        TimestampedEvent event1 = new TimestampedEvent();
        event1.setEvent((Object)SpanEvent.SERVER_RECV);
        event1.setTimeStamp(System.currentTimeMillis());
        TimestampedEvent event2 = new TimestampedEvent();
        event2.setEvent((Object)SpanEvent.SERVER_SEND);
        event2.setTimeStamp(System.currentTimeMillis());
        out.setEvents(new GenericData.Array<TimestampedEvent>(2, Schema.createArray(TimestampedEvent.SCHEMA$)));
        out.getEvents().add(event1);
        out.getEvents().add(event2);
        return out;
    }
}

