/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.avro.ipc.trace.FileSpanStorage;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanEvent;
import org.apache.avro.ipc.trace.TimestampedEvent;
import org.apache.avro.ipc.trace.TracePluginConfiguration;
import org.apache.avro.ipc.trace.Util;
import org.junit.Assert;
import org.junit.Test;

public class TestFileSpanStorage {
    @Test
    public void testBasicStorage() {
        TracePluginConfiguration conf = new TracePluginConfiguration();
        FileSpanStorage test = new FileSpanStorage(false, conf);
        Span s2 = Util.createEventlessSpan(Util.idValue(1L), Util.idValue(1L), null);
        s2.setMessageName(new String("message"));
        test.addSpan(s2);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)test.getAllSpans().contains(s2));
        test.clear();
    }

    @Test
    public void testTonsOfSpans() {
        TracePluginConfiguration conf = new TracePluginConfiguration();
        FileSpanStorage test = new FileSpanStorage(false, conf);
        test.setMaxSpans(100000L);
        ArrayList<Span> spans = new ArrayList<Span>(50000);
        for (int i = 0; i < 50000; ++i) {
            Span s2 = Util.createEventlessSpan(Util.idValue(i), Util.idValue(i), null);
            s2.setMessageName(new String("message"));
            test.addSpan(s2);
            spans.add(s2);
        }
        try {
            for (int retries = 0; retries < 10 && test.getAllSpans().size() < 50000; ++retries) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)50000L, (long)test.getAllSpans().size());
        TracePluginConfiguration conf2 = new TracePluginConfiguration();
        FileSpanStorage test2 = new FileSpanStorage(false, conf2);
        test.setMaxSpans(100000L);
        spans.clear();
        for (int i = 0; i < 5000; ++i) {
            Span s3 = Util.createEventlessSpan(Util.idValue(i), Util.idValue(i), null);
            s3.setMessageName(new String("message"));
            test2.addSpan(s3);
            spans.add(s3);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)test.getAllSpans().containsAll(spans));
        test.clear();
        test2.clear();
    }

    @Test
    public void testBasicMaxSpans() {
        TracePluginConfiguration conf = new TracePluginConfiguration();
        FileSpanStorage test = new FileSpanStorage(false, conf);
        test.setMaxSpans(10L);
        for (int i = 0; i < 100; ++i) {
            Span s2 = Util.createEventlessSpan(Util.idValue(i), Util.idValue(i), null);
            s2.setMessageName(new String("message"));
            test.addSpan(s2);
        }
        LinkedList<Span> lastNine = new LinkedList<Span>();
        for (int i = 0; i < 9; ++i) {
            Span s3 = Util.createEventlessSpan(Util.idValue(100 + i), Util.idValue(100 + i), null);
            s3.setMessageName(new String("message"));
            lastNine.add(s3);
            test.addSpan(s3);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        List<Span> retreived = test.getAllSpans();
        Assert.assertEquals((long)9L, (long)retreived.size());
        Assert.assertTrue((boolean)retreived.containsAll(lastNine));
        test.clear();
    }

    @Test
    public void testRangeQuery1() {
        TracePluginConfiguration conf = new TracePluginConfiguration();
        conf.fileGranularitySeconds = 1;
        FileSpanStorage test = new FileSpanStorage(false, conf);
        test.setMaxSpans(10000L);
        long cutOff1 = 0L;
        long cutOff2 = 0L;
        int numSpans = 10;
        Span[] spans = new Span[numSpans];
        for (int i = 0; i < numSpans; ++i) {
            if (i == 1) {
                cutOff1 = (System.currentTimeMillis() - 20L) * 1000000L;
            }
            Span s2 = Util.createEventlessSpan(Util.idValue(i), Util.idValue(i), null);
            TimestampedEvent te1 = new TimestampedEvent();
            te1.setTimeStamp(System.currentTimeMillis() * 1000000L);
            te1.setEvent((Object)SpanEvent.CLIENT_SEND);
            TimestampedEvent te2 = new TimestampedEvent();
            te2.setTimeStamp(System.currentTimeMillis() * 1000000L);
            te2.setEvent((Object)SpanEvent.CLIENT_RECV);
            s2.getEvents().add(te1);
            s2.getEvents().add(te2);
            s2.setMessageName(new String("message"));
            test.addSpan(s2);
            spans[i] = s2;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (i != numSpans - 2) continue;
            cutOff2 = (System.currentTimeMillis() - 20L) * 1000000L;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        List<Span> retrieved = test.getSpansInRange(cutOff1, cutOff2);
        Assert.assertEquals((long)(numSpans - 2), (long)retrieved.size());
        Assert.assertFalse((boolean)retrieved.contains(spans[0]));
        for (int j = 1; j < numSpans - 2; ++j) {
            Assert.assertTrue((boolean)retrieved.contains(spans[j]));
        }
        Assert.assertFalse((boolean)retrieved.contains(spans[spans.length - 1]));
        test.clear();
    }
}

