/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanEvent;
import org.apache.avro.ipc.trace.TimestampedEvent;
import org.apache.avro.ipc.trace.Trace;
import org.apache.avro.ipc.trace.TraceCollection;
import org.apache.avro.ipc.trace.Util;

public class SpanAggregator {
    static SpanAggregationResults getFullSpans(List<Span> partials) {
        SpanAggregationResults out = new SpanAggregationResults();
        HashMap<Long, Span> seenSpans = new HashMap<Long, Span>();
        List<SpanEvent> allEvents = Arrays.asList(SpanEvent.values());
        for (Span s2 : partials) {
            EnumSet<SpanEvent> foundEvents = Util.getAllEvents(s2);
            if (foundEvents.containsAll(allEvents)) {
                out.completeSpans.add(s2);
                continue;
            }
            if (!seenSpans.containsKey(Util.longValue(s2.spanID))) {
                seenSpans.put(Util.longValue(s2.spanID), s2);
                continue;
            }
            Span other = (Span)seenSpans.remove(Util.longValue(s2.spanID));
            if (!other.messageName.equals(s2.messageName) || !Util.idsEqual(other.parentSpanID, s2.parentSpanID)) {
                out.incompleteSpans.add(s2);
                out.incompleteSpans.add(other);
                continue;
            }
            foundEvents.addAll(Util.getAllEvents(other));
            if (other.requestorHostname != null) {
                s2.requestorHostname = other.requestorHostname;
            }
            if (other.responderHostname != null) {
                s2.responderHostname = other.responderHostname;
            }
            if (!foundEvents.containsAll(allEvents)) continue;
            for (TimestampedEvent event : other.events) {
                s2.events.add(event);
            }
            s2.requestPayloadSize = Math.max(s2.requestPayloadSize, other.requestPayloadSize);
            s2.responsePayloadSize = Math.max(s2.responsePayloadSize, other.responsePayloadSize);
            s2.complete = true;
            out.completeSpans.add(s2);
        }
        for (Span s2 : seenSpans.values()) {
            out.incompleteSpans.add(s2);
        }
        return out;
    }

    static TraceFormationResults getTraces(List<Span> spans) {
        HashMap traces = new HashMap();
        for (Span s2 : spans) {
            if (traces.get(Util.longValue(s2.traceID)) == null) {
                traces.put(Util.longValue(s2.traceID), new ArrayList());
            }
            ((List)traces.get(Util.longValue(s2.traceID))).add(s2);
        }
        TraceFormationResults out = new TraceFormationResults();
        for (List spanSet : traces.values()) {
            Trace trace2 = Trace.extractTrace(spanSet);
            if (trace2 != null) {
                out.traces.add(trace2);
                continue;
            }
            out.rejectedSpans.addAll(spanSet);
        }
        return out;
    }

    static List<TraceCollection> getTraceCollections(List<Trace> traces) {
        HashMap<Integer, TraceCollection> collections = new HashMap<Integer, TraceCollection>();
        for (Trace t : traces) {
            if (!collections.containsKey(t.executionPathHash())) {
                TraceCollection collection2 = new TraceCollection(t);
                collections.put(t.executionPathHash(), collection2);
            }
            ((TraceCollection)collections.get(t.executionPathHash())).addTrace(t);
        }
        return new LinkedList<TraceCollection>(collections.values());
    }

    public static class TraceFormationResults {
        public List<Trace> traces = new LinkedList<Trace>();
        public List<Span> rejectedSpans = new LinkedList<Span>();
    }

    public static class SpanAggregationResults {
        public List<Span> completeSpans = new LinkedList<Span>();
        public List<Span> incompleteSpans = new LinkedList<Span>();
    }
}

