/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanStorage;
import org.apache.avro.ipc.trace.TracePluginConfiguration;
import org.apache.avro.ipc.trace.Util;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSpanStorage
implements SpanStorage {
    private static final String FILE_SUFFIX = ".av";
    private static final SpecificDatumWriter<Span> SPAN_WRITER = new SpecificDatumWriter<Span>(Span.class);
    private static final SpecificDatumReader<Span> SPAN_READER = new SpecificDatumReader<Span>(Span.class);
    private static final Logger LOG = LoggerFactory.getLogger(FileSpanStorage.class);
    private long maxSpans = 10000L;
    private int secondsPerFile = 600;
    private String traceFileDir = "/tmp";
    private TreeMap<Long, File> files = new TreeMap();
    LinkedBlockingQueue<Span> outstanding = new LinkedBlockingQueue();
    private Thread writer;

    private static void readFileSpans(File f2, List<Span> list2) throws IOException {
        DataFileReader<Span> reader = new DataFileReader<Span>(f2, SPAN_READER);
        Iterator it = reader.iterator();
        ArrayList spans = new ArrayList();
        while (it.hasNext()) {
            spans.add(it.next());
        }
        list2.addAll(spans);
    }

    private static void readFileSpans(File f2, List<Span> list2, long start, long end) throws IOException {
        DataFileReader<Span> reader = new DataFileReader<Span>(f2, SPAN_READER);
        Iterator it = reader.iterator();
        ArrayList<Span> spans = new ArrayList<Span>();
        while (it.hasNext()) {
            Span s2 = (Span)it.next();
            if (!Util.spanInRange(s2, start, end)) continue;
            spans.add(s2);
        }
        list2.addAll(spans);
    }

    public FileSpanStorage(boolean buffer2, TracePluginConfiguration conf) {
        this.writer = new Thread(new DiskWriterThread(this.outstanding, this.files, buffer2, conf.compressionLevel));
        this.secondsPerFile = conf.fileGranularitySeconds;
        this.traceFileDir = conf.spanStorageDir;
        this.writer.start();
    }

    private long floorSecond(long currentSecond) {
        return currentSecond - currentSecond % (long)this.secondsPerFile;
    }

    @Override
    public void addSpan(Span s2) {
        this.outstanding.add(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Span> getAllSpans() {
        ArrayList<Span> out = new ArrayList<Span>();
        TreeMap<Long, File> treeMap = this.files;
        synchronized (treeMap) {
            for (File f2 : this.files.values()) {
                try {
                    FileSpanStorage.readFileSpans(f2, out);
                }
                catch (IOException e) {
                    LOG.warn("Error reading file: " + f2.getAbsolutePath());
                }
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        TreeMap<Long, File> treeMap = this.files;
        synchronized (treeMap) {
            for (Long l : new LinkedList<Long>(this.files.keySet())) {
                File f2 = this.files.remove(l);
                f2.delete();
            }
        }
    }

    @Override
    public void setMaxSpans(long maxSpans) {
        this.maxSpans = maxSpans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Span> getSpansInRange(long start, long end) {
        ArrayList<Span> out = new ArrayList<Span>();
        LinkedList<Long> middleFiles = new LinkedList<Long>();
        long startSecond = start / 1000000000L;
        long endSecond = end / 1000000000L;
        int numFiles = (int)(endSecond - startSecond) / this.secondsPerFile;
        for (int i = 1; i < numFiles; ++i) {
            middleFiles.add(startSecond + (long)(i * this.secondsPerFile));
        }
        TreeMap<Long, File> treeMap = this.files;
        synchronized (treeMap) {
            for (Long l : middleFiles) {
                if (!this.files.containsKey(l)) continue;
                try {
                    FileSpanStorage.readFileSpans(this.files.get(l), out);
                }
                catch (IOException e) {
                    LOG.warn("Error reading file: " + this.files.get(l).getAbsolutePath());
                }
            }
            if (this.files.containsKey(startSecond)) {
                try {
                    FileSpanStorage.readFileSpans(this.files.get(startSecond), out, start, end);
                }
                catch (IOException e) {
                    LOG.warn("Error reading file: " + this.files.get(startSecond).getAbsolutePath());
                }
            }
            if (this.files.containsKey(endSecond)) {
                try {
                    FileSpanStorage.readFileSpans(this.files.get(endSecond), out, start, end);
                }
                catch (IOException e) {
                    LOG.warn("Error reading file: " + this.files.get(endSecond).getAbsolutePath());
                }
            }
        }
        return out;
    }

    private class DiskWriterThread
    implements Runnable {
        private BlockingQueue<Span> outstanding;
        private TreeMap<Long, File> files;
        private HashMap<File, Long> spansPerFile = new HashMap();
        private long spansSoFar;
        private DataFileWriter<Span> currentWriter;
        private long currentTimestamp = 0L;
        private boolean doBuffer;
        private int compressionLevel;

        public DiskWriterThread(BlockingQueue<Span> outstanding, TreeMap<Long, File> files2, boolean buffer2, int compressionLevel) {
            this.outstanding = outstanding;
            this.files = files2;
            this.doBuffer = buffer2;
            this.compressionLevel = compressionLevel;
        }

        @Override
        public void run() {
            while (true) {
                Span s2 = null;
                try {
                    s2 = this.outstanding.take();
                }
                catch (InterruptedException e1) {
                    LOG.warn("Thread interrupted");
                    Thread.currentThread().interrupt();
                }
                try {
                    this.assureCurrentWriter();
                    this.currentWriter.append(s2);
                    if (!this.doBuffer) {
                        this.currentWriter.flush();
                    }
                    ++this.spansSoFar;
                    File latest = this.files.lastEntry().getValue();
                    long fileSpans = this.spansPerFile.get(latest);
                    this.spansPerFile.put(latest, fileSpans + 1L);
                    continue;
                }
                catch (IOException e) {
                    LOG.warn("Error setting span file: " + e.getMessage());
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void assureCurrentWriter() throws IOException {
            boolean createNewFile = false;
            while (this.spansSoFar >= FileSpanStorage.this.maxSpans) {
                File oldest = null;
                TreeMap<Long, File> treeMap = this.files;
                synchronized (treeMap) {
                    oldest = this.files.remove(this.files.firstKey());
                }
                this.spansSoFar -= this.spansPerFile.get(oldest).longValue();
                this.spansPerFile.remove(oldest);
                oldest.delete();
            }
            if (this.files.size() == 0) {
                this.currentTimestamp = 0L;
                this.currentWriter = null;
            }
            long rightNow = System.currentTimeMillis() / 1000L;
            long cutOff = FileSpanStorage.this.floorSecond(rightNow);
            if (this.currentWriter == null) {
                createNewFile = true;
            } else if (cutOff >= this.currentTimestamp + (long)FileSpanStorage.this.secondsPerFile) {
                this.currentWriter.close();
                createNewFile = true;
            }
            if (createNewFile) {
                File newFile = new File(FileSpanStorage.this.traceFileDir + "/" + Thread.currentThread().getId() + "_" + cutOff + FileSpanStorage.FILE_SUFFIX);
                TreeMap<Long, File> treeMap = this.files;
                synchronized (treeMap) {
                    this.files.put(cutOff, newFile);
                }
                this.spansPerFile.put(newFile, 0L);
                this.currentWriter = new DataFileWriter(SPAN_WRITER);
                this.currentWriter.setCodec(CodecFactory.deflateCodec(this.compressionLevel));
                this.currentWriter.create(Span.SCHEMA$, newFile);
                this.currentTimestamp = cutOff;
            }
        }
    }
}

