/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import org.apache.avro.ipc.stats.FakeTicks;
import org.apache.avro.ipc.stats.Stopwatch;
import org.junit.Assert;
import org.junit.Test;

public class TestStopwatch {
    @Test
    public void testNormal() {
        FakeTicks f2 = new FakeTicks();
        Stopwatch s2 = new Stopwatch(f2);
        f2.passTime(10L);
        s2.start();
        f2.passTime(20L);
        Assert.assertEquals((long)20L, (long)s2.elapsedNanos());
        f2.passTime(40L);
        s2.stop();
        f2.passTime(80L);
        Assert.assertEquals((long)60L, (long)s2.elapsedNanos());
    }

    @Test(expected=IllegalStateException.class)
    public void testNotStarted1() {
        FakeTicks f2 = new FakeTicks();
        Stopwatch s2 = new Stopwatch(f2);
        s2.elapsedNanos();
    }

    @Test(expected=IllegalStateException.class)
    public void testNotStarted2() {
        FakeTicks f2 = new FakeTicks();
        Stopwatch s2 = new Stopwatch(f2);
        s2.stop();
    }

    @Test(expected=IllegalStateException.class)
    public void testTwiceStarted() {
        FakeTicks f2 = new FakeTicks();
        Stopwatch s2 = new Stopwatch(f2);
        s2.start();
        s2.start();
    }

    @Test(expected=IllegalStateException.class)
    public void testTwiceStopped() {
        FakeTicks f2 = new FakeTicks();
        Stopwatch s2 = new Stopwatch(f2);
        s2.start();
        s2.stop();
        s2.stop();
    }

    @Test
    public void testSystemStopwatch() {
        Stopwatch s2 = new Stopwatch(Stopwatch.SYSTEM_TICKS);
        s2.start();
        s2.stop();
        Assert.assertTrue((s2.elapsedNanos() >= 0L ? 1 : 0) != 0);
    }
}

