/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.stats.FloatHistogram;
import org.apache.avro.ipc.stats.Histogram;
import org.apache.avro.ipc.stats.IntegerHistogram;
import org.apache.avro.ipc.stats.Stopwatch;

public class StatsPlugin
extends RPCPlugin {
    static final Histogram.Segmenter<String, Float> LATENCY_SEGMENTER = new Histogram.TreeMapSegmenter<Float>(new TreeSet<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(25.0f), Float.valueOf(50.0f), Float.valueOf(75.0f), Float.valueOf(100.0f), Float.valueOf(200.0f), Float.valueOf(300.0f), Float.valueOf(500.0f), Float.valueOf(750.0f), Float.valueOf(1000.0f), Float.valueOf(2000.0f), Float.valueOf(5000.0f), Float.valueOf(10000.0f), Float.valueOf(60000.0f), Float.valueOf(600000.0f))));
    static final Histogram.Segmenter<String, Integer> PAYLOAD_SEGMENTER = new Histogram.TreeMapSegmenter<Integer>(new TreeSet<Integer>(Arrays.asList(0, 25, 50, 75, 100, 200, 300, 500, 750, 1000, 2000, 5000, 10000, 50000, 100000)));
    Map<Protocol.Message, FloatHistogram<?>> methodTimings = new HashMap();
    Map<Protocol.Message, IntegerHistogram<?>> sendPayloads = new HashMap();
    Map<Protocol.Message, IntegerHistogram<?>> receivePayloads = new HashMap();
    ConcurrentMap<RPCContext, Stopwatch> activeRpcs = new ConcurrentHashMap<RPCContext, Stopwatch>();
    private Stopwatch.Ticks ticks;
    public Date startupTime = new Date();
    private Histogram.Segmenter<?, Float> floatSegmenter;
    private Histogram.Segmenter<?, Integer> integerSegmenter;

    StatsPlugin(Stopwatch.Ticks ticks, Histogram.Segmenter<?, Float> floatSegmenter, Histogram.Segmenter<?, Integer> integerSegmenter) {
        this.floatSegmenter = floatSegmenter;
        this.integerSegmenter = integerSegmenter;
        this.ticks = ticks;
    }

    public StatsPlugin() {
        this(Stopwatch.SYSTEM_TICKS, LATENCY_SEGMENTER, PAYLOAD_SEGMENTER);
    }

    private int getPayloadSize(List<ByteBuffer> payload) {
        if (payload == null) {
            return 0;
        }
        int size2 = 0;
        for (ByteBuffer bb : payload) {
            size2 += bb.limit();
        }
        return size2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverReceiveRequest(RPCContext context) {
        Stopwatch t = new Stopwatch(this.ticks);
        t.start();
        this.activeRpcs.put(context, t);
        Map<Protocol.Message, IntegerHistogram<?>> map2 = this.receivePayloads;
        synchronized (map2) {
            IntegerHistogram<?> h = this.receivePayloads.get(context.getMessage());
            if (h == null) {
                h = this.createNewIntegerHistogram();
                this.receivePayloads.put(context.getMessage(), h);
            }
            h.add(this.getPayloadSize(context.getRequestPayload()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverSendResponse(RPCContext context) {
        Stopwatch t = (Stopwatch)this.activeRpcs.remove(context);
        t.stop();
        this.publish(context, t);
        Map<Protocol.Message, IntegerHistogram<?>> map2 = this.sendPayloads;
        synchronized (map2) {
            IntegerHistogram<?> h = this.sendPayloads.get(context.getMessage());
            if (h == null) {
                h = this.createNewIntegerHistogram();
                this.sendPayloads.put(context.getMessage(), h);
            }
            h.add(this.getPayloadSize(context.getResponsePayload()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientSendRequest(RPCContext context) {
        Stopwatch t = new Stopwatch(this.ticks);
        t.start();
        this.activeRpcs.put(context, t);
        Map<Protocol.Message, IntegerHistogram<?>> map2 = this.sendPayloads;
        synchronized (map2) {
            IntegerHistogram<?> h = this.sendPayloads.get(context.getMessage());
            if (h == null) {
                h = this.createNewIntegerHistogram();
                this.sendPayloads.put(context.getMessage(), h);
            }
            h.add(this.getPayloadSize(context.getRequestPayload()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientReceiveResponse(RPCContext context) {
        Stopwatch t = (Stopwatch)this.activeRpcs.remove(context);
        t.stop();
        this.publish(context, t);
        Map<Protocol.Message, IntegerHistogram<?>> map2 = this.receivePayloads;
        synchronized (map2) {
            IntegerHistogram<?> h = this.receivePayloads.get(context.getMessage());
            if (h == null) {
                h = this.createNewIntegerHistogram();
                this.receivePayloads.put(context.getMessage(), h);
            }
            h.add(this.getPayloadSize(context.getRequestPayload()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(RPCContext context, Stopwatch t) {
        Protocol.Message message = context.getMessage();
        if (message == null) {
            throw new IllegalArgumentException();
        }
        Map<Protocol.Message, FloatHistogram<?>> map2 = this.methodTimings;
        synchronized (map2) {
            FloatHistogram<?> h = this.methodTimings.get(context.getMessage());
            if (h == null) {
                h = this.createNewFloatHistogram();
                this.methodTimings.put(context.getMessage(), h);
            }
            h.add(Float.valueOf(StatsPlugin.nanosToMillis(t.elapsedNanos())));
        }
    }

    private FloatHistogram<?> createNewFloatHistogram() {
        return new FloatHistogram(this.floatSegmenter);
    }

    private IntegerHistogram<?> createNewIntegerHistogram() {
        return new IntegerHistogram(this.integerSegmenter);
    }

    static float nanosToMillis(long elapsedNanos) {
        return (float)elapsedNanos / 1000000.0f;
    }
}

