/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import org.apache.avro.ipc.stats.Histogram;

class IntegerHistogram<B>
extends Histogram<B, Integer> {
    private float runningSum;
    private float runningSumOfSquares;

    public IntegerHistogram(Histogram.Segmenter<B, Integer> segmenter) {
        super(segmenter);
    }

    @Override
    public void add(Integer value2) {
        super.add(value2);
        this.runningSum += (float)value2.intValue();
        this.runningSumOfSquares += (float)(value2 * value2);
    }

    public float getMean() {
        if (this.totalCount == 0) {
            return -1.0f;
        }
        return this.runningSum / (float)this.totalCount;
    }

    public float getUnbiasedStdDev() {
        if (this.totalCount <= 1) {
            return -1.0f;
        }
        float mean = this.getMean();
        return (float)Math.sqrt((this.runningSumOfSquares - (float)this.totalCount * mean * mean) / (float)(this.totalCount - 1));
    }
}

