/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.specific;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.generic.GenericResponder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;

public class SpecificResponder
extends GenericResponder {
    private Object impl;

    public SpecificResponder(Class iface, Object impl) {
        this(iface, impl, new SpecificData(impl.getClass().getClassLoader()));
    }

    public SpecificResponder(Protocol protocol, Object impl) {
        this(protocol, impl, new SpecificData(impl.getClass().getClassLoader()));
    }

    public SpecificResponder(Class iface, Object impl, SpecificData data2) {
        this(data2.getProtocol(iface), impl, data2);
    }

    public SpecificResponder(Protocol protocol, Object impl, SpecificData data2) {
        super(protocol, data2);
        this.impl = impl;
    }

    public SpecificData getSpecificData() {
        return (SpecificData)this.getGenericData();
    }

    @Override
    protected DatumWriter<Object> getDatumWriter(Schema schema) {
        return new SpecificDatumWriter<Object>(schema, this.getSpecificData());
    }

    @Override
    protected DatumReader<Object> getDatumReader(Schema actual, Schema expected) {
        return new SpecificDatumReader<Object>(actual, expected, this.getSpecificData());
    }

    @Override
    public void writeError(Schema schema, Object error2, Encoder out) throws IOException {
        this.getDatumWriter(schema).write(error2, out);
    }

    @Override
    public Object respond(Protocol.Message message, Object request) throws Exception {
        int numParams = message.getRequest().getFields().size();
        Object[] params2 = new Object[numParams];
        Class[] paramTypes2 = new Class[numParams];
        int i = 0;
        try {
            for (Schema.Field param2 : message.getRequest().getFields()) {
                params2[i] = ((GenericRecord)request).get(param2.name());
                paramTypes2[i] = this.getSpecificData().getClass(param2.schema());
                ++i;
            }
            Method method = this.impl.getClass().getMethod(message.getName(), paramTypes2);
            method.setAccessible(true);
            return method.invoke(this.impl, params2);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw new Exception(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new AvroRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
    }
}

