/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.generic;

import java.io.IOException;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.Responder;

public abstract class GenericResponder
extends Responder {
    private GenericData data;

    public GenericResponder(Protocol local) {
        this(local, GenericData.get());
    }

    public GenericResponder(Protocol local, GenericData data2) {
        super(local);
        this.data = data2;
    }

    public GenericData getGenericData() {
        return this.data;
    }

    protected DatumWriter<Object> getDatumWriter(Schema schema) {
        return new GenericDatumWriter<Object>(schema, this.data);
    }

    protected DatumReader<Object> getDatumReader(Schema actual, Schema expected) {
        return new GenericDatumReader<Object>(actual, expected, this.data);
    }

    @Override
    public Object readRequest(Schema actual, Schema expected, Decoder in) throws IOException {
        return this.getDatumReader(actual, expected).read(null, in);
    }

    @Override
    public void writeResponse(Schema schema, Object response, Encoder out) throws IOException {
        this.getDatumWriter(schema).write(response, out);
    }

    @Override
    public void writeError(Schema schema, Object error2, Encoder out) throws IOException {
        if (error2 instanceof AvroRemoteException) {
            error2 = ((AvroRemoteException)error2).getValue();
        }
        this.getDatumWriter(schema).write(error2, out);
    }
}

