/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.generic;

import java.io.IOException;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.Callback;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Transceiver;

public class GenericRequestor
extends Requestor {
    GenericData data;

    public GenericRequestor(Protocol protocol, Transceiver transceiver) throws IOException {
        this(protocol, transceiver, GenericData.get());
    }

    public GenericRequestor(Protocol protocol, Transceiver transceiver, GenericData data2) throws IOException {
        super(protocol, transceiver);
        this.data = data2;
    }

    public GenericData getGenericData() {
        return this.data;
    }

    @Override
    public Object request(String messageName, Object request) throws IOException {
        try {
            return super.request(messageName, request);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new AvroRemoteException(e);
        }
    }

    @Override
    public <T> void request(String messageName, Object request, Callback<T> callback) throws IOException {
        try {
            super.request(messageName, request, callback);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new AvroRemoteException(e);
        }
    }

    @Override
    public void writeRequest(Schema schema, Object request, Encoder out) throws IOException {
        new GenericDatumWriter<Object>(schema, this.data).write(request, out);
    }

    @Override
    public Object readResponse(Schema writer, Schema reader, Decoder in) throws IOException {
        return new GenericDatumReader<Object>(writer, reader, this.data).read(null, in);
    }

    @Override
    public Exception readError(Schema writer, Schema reader, Decoder in) throws IOException {
        Object error2 = new GenericDatumReader<Object>(writer, reader, this.data).read(null, in);
        if (error2 instanceof CharSequence) {
            return new AvroRuntimeException(error2.toString());
        }
        return new AvroRemoteException(error2);
    }
}

