/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.ipc.CallFuture;
import org.apache.avro.ipc.Callback;
import org.apache.avro.ipc.NettyServer;
import org.apache.avro.ipc.NettyTransceiver;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.test.Kind;
import org.apache.avro.test.MD5;
import org.apache.avro.test.Simple;
import org.apache.avro.test.TestError;
import org.apache.avro.test.TestRecord;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestNettyServerWithCallbacks {
    private static Server server;
    private static Transceiver transceiver;
    private static Simple.Callback simpleClient;
    private static final AtomicBoolean ackFlag;
    private static final AtomicReference<CountDownLatch> ackLatch;
    private static Simple simpleService;

    @BeforeClass
    public static void initializeConnections() throws Exception {
        SpecificResponder responder = new SpecificResponder(Simple.class, (Object)simpleService);
        server = new NettyServer(responder, new InetSocketAddress(0));
        server.start();
        int serverPort = server.getPort();
        System.out.println("server port : " + serverPort);
        transceiver = new NettyTransceiver(new InetSocketAddress(serverPort), 2000L);
        simpleClient = SpecificRequestor.getClient(Simple.Callback.class, transceiver);
    }

    @AfterClass
    public static void tearDownConnections() throws Exception {
        if (transceiver != null) {
            transceiver.close();
        }
        if (server != null) {
            server.close();
        }
    }

    @Test
    public void greeting() throws Exception {
        Assert.assertEquals((Object)"Hello, how are you?", (Object)simpleClient.hello("how are you?"));
        CallFuture<String> future1 = new CallFuture<String>();
        simpleClient.hello("World!", future1);
        Assert.assertEquals((Object)"Hello, World!", (Object)future1.get(2L, TimeUnit.SECONDS));
        Assert.assertNull((Object)future1.getError());
        final CallFuture future2 = new CallFuture();
        simpleClient.hello("what's up?", new Callback<String>(){

            @Override
            public void handleResult(String result2) {
                future2.handleResult(result2);
            }

            @Override
            public void handleError(Throwable error2) {
                future2.handleError(error2);
            }
        });
        Assert.assertEquals((Object)"Hello, what's up?", future2.get(2L, TimeUnit.SECONDS));
        Assert.assertNull((Object)future2.getError());
    }

    @Test
    public void echo() throws Exception {
        TestRecord record2 = TestRecord.newBuilder().setHash(new MD5(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8})).setKind(Kind.FOO).setName("My Record").build();
        Assert.assertEquals((Object)record2, (Object)simpleClient.echo(record2));
        CallFuture<TestRecord> future1 = new CallFuture<TestRecord>();
        simpleClient.echo(record2, future1);
        Assert.assertEquals((Object)record2, (Object)future1.get(2L, TimeUnit.SECONDS));
        Assert.assertNull((Object)future1.getError());
        final CallFuture future2 = new CallFuture();
        simpleClient.echo(record2, new Callback<TestRecord>(){

            @Override
            public void handleResult(TestRecord result2) {
                future2.handleResult(result2);
            }

            @Override
            public void handleError(Throwable error2) {
                future2.handleError(error2);
            }
        });
        Assert.assertEquals((Object)record2, future2.get(2L, TimeUnit.SECONDS));
        Assert.assertNull((Object)future2.getError());
    }

    @Test
    public void add() throws Exception {
        Assert.assertEquals((long)8L, (long)simpleClient.add(2, 6));
        CallFuture<Integer> future1 = new CallFuture<Integer>();
        simpleClient.add(8, 8, future1);
        Assert.assertEquals((Object)new Integer(16), (Object)future1.get(2L, TimeUnit.SECONDS));
        Assert.assertNull((Object)future1.getError());
        final CallFuture future2 = new CallFuture();
        simpleClient.add(512, 256, new Callback<Integer>(){

            @Override
            public void handleResult(Integer result2) {
                future2.handleResult(result2);
            }

            @Override
            public void handleError(Throwable error2) {
                future2.handleError(error2);
            }
        });
        Assert.assertEquals((Object)new Integer(768), future2.get(2L, TimeUnit.SECONDS));
        Assert.assertNull((Object)future2.getError());
    }

    @Test
    public void echoBytes() throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        Assert.assertEquals((Object)byteBuffer, (Object)simpleClient.echoBytes(byteBuffer));
        CallFuture<ByteBuffer> future1 = new CallFuture<ByteBuffer>();
        simpleClient.echoBytes(byteBuffer, future1);
        Assert.assertEquals((Object)byteBuffer, (Object)future1.get(2L, TimeUnit.SECONDS));
        Assert.assertNull((Object)future1.getError());
        final CallFuture future2 = new CallFuture();
        simpleClient.echoBytes(byteBuffer, new Callback<ByteBuffer>(){

            @Override
            public void handleResult(ByteBuffer result2) {
                future2.handleResult(result2);
            }

            @Override
            public void handleError(Throwable error2) {
                future2.handleError(error2);
            }
        });
        Assert.assertEquals((Object)byteBuffer, future2.get(2L, TimeUnit.SECONDS));
        Assert.assertNull((Object)future2.getError());
    }

    @Test
    public void error() throws IOException, InterruptedException, TimeoutException {
        try {
            simpleClient.error();
            Assert.fail((String)("Expected " + TestError.class.getCanonicalName()));
        }
        catch (TestError e) {
        }
        catch (AvroRemoteException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected error: " + e.toString()));
        }
        CallFuture<Void> future = new CallFuture<Void>();
        simpleClient.error(future);
        try {
            future.get(2L, TimeUnit.SECONDS);
            Assert.fail((String)("Expected " + TestError.class.getCanonicalName() + " to be thrown"));
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected " + TestError.class.getCanonicalName()), (boolean)(e.getCause() instanceof TestError));
        }
        Assert.assertNotNull((Object)future.getError());
        Assert.assertTrue((String)("Expected " + TestError.class.getCanonicalName()), (boolean)(future.getError() instanceof TestError));
        Assert.assertNull((Object)future.getResult());
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference errorRef = new AtomicReference();
        simpleClient.error(new Callback<Void>(){

            @Override
            public void handleResult(Void result2) {
                Assert.fail((String)("Expected " + TestError.class.getCanonicalName()));
            }

            @Override
            public void handleError(Throwable error2) {
                errorRef.set(error2);
                latch.countDown();
            }
        });
        Assert.assertTrue((String)"Timed out waiting for error", (boolean)latch.await(2L, TimeUnit.SECONDS));
        Assert.assertNotNull(errorRef.get());
        Assert.assertTrue((boolean)(errorRef.get() instanceof TestError));
    }

    @Test
    public void ack() throws Exception {
        simpleClient.ack();
        ackLatch.get().await(2L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Expected ack flag to be set", (boolean)ackFlag.get());
        ackLatch.set(new CountDownLatch(1));
        simpleClient.ack();
        ackLatch.get().await(2L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"Expected ack flag to be cleared", (boolean)ackFlag.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendAfterChannelClose() throws Exception {
        NettyServer server2 = new NettyServer(new SpecificResponder(Simple.class, (Object)simpleService), new InetSocketAddress(0));
        server2.start();
        try {
            int serverPort = server2.getPort();
            System.out.println("server2 port : " + serverPort);
            NettyTransceiver transceiver2 = new NettyTransceiver(new InetSocketAddress(serverPort), 2000L);
            try {
                Simple.Callback simpleClient2 = SpecificRequestor.getClient(Simple.Callback.class, transceiver2);
                Assert.assertEquals((long)3L, (long)simpleClient2.add(1, 2));
                CallFuture<Integer> addFuture = new CallFuture<Integer>();
                simpleClient2.add(1, 2, addFuture);
                Assert.assertEquals((Object)new Integer(3), (Object)addFuture.get());
                server2.close();
                Thread.sleep(1000L);
                boolean ioeCaught = false;
                try {
                    simpleClient2.add(1, 2);
                    Assert.fail((String)"Send after server close should have thrown Exception");
                }
                catch (AvroRemoteException e) {
                    ioeCaught = e.getCause() instanceof IOException;
                    Assert.assertTrue((String)"Expected IOException", (boolean)ioeCaught);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                Assert.assertTrue((String)"Expected IOException", (boolean)ioeCaught);
                ioeCaught = false;
                try {
                    addFuture = new CallFuture();
                    simpleClient2.add(1, 2, addFuture);
                    addFuture.get();
                    Assert.fail((String)"Send after server close should have thrown Exception");
                }
                catch (IOException e) {
                    ioeCaught = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                Assert.assertTrue((String)"Expected IOException", (boolean)ioeCaught);
            }
            finally {
                ((Transceiver)transceiver2).close();
            }
        }
        finally {
            server2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cancelPendingRequestsOnTransceiverClose() throws Exception {
        BlockingSimpleImpl blockingSimpleImpl = new BlockingSimpleImpl();
        NettyServer server2 = new NettyServer(new SpecificResponder(Simple.class, (Object)blockingSimpleImpl), new InetSocketAddress(0));
        server2.start();
        try {
            int serverPort = server2.getPort();
            System.out.println("server2 port : " + serverPort);
            CallFuture<Integer> addFuture = new CallFuture<Integer>();
            NettyTransceiver transceiver2 = new NettyTransceiver(new InetSocketAddress(serverPort), 2000L);
            try {
                Simple.Callback simpleClient2 = SpecificRequestor.getClient(Simple.Callback.class, transceiver2);
                Assert.assertEquals((long)3L, (long)simpleClient2.add(1, 2));
                blockingSimpleImpl.acquireRunPermit();
                simpleClient2.add(1, 2, addFuture);
            }
            finally {
                ((Transceiver)transceiver2).close();
            }
            boolean ioeThrown = false;
            try {
                addFuture.get();
            }
            catch (ExecutionException e) {
                ioeThrown = e.getCause() instanceof IOException;
                Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Unexpected Exception: " + e.toString()));
            }
            Assert.assertTrue((String)"Expected IOException to be thrown", (boolean)ioeThrown);
        }
        finally {
            blockingSimpleImpl.releaseRunPermit();
            server2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cancelPendingRequestsAfterChannelCloseByServerShutdown() throws Exception {
        BlockingSimpleImpl blockingSimpleImpl = new BlockingSimpleImpl();
        NettyServer server2 = new NettyServer(new SpecificResponder(Simple.class, (Object)blockingSimpleImpl), new InetSocketAddress(0));
        server2.start();
        Transceiver transceiver2 = null;
        try {
            int serverPort = server2.getPort();
            System.out.println("server2 port : " + serverPort);
            transceiver2 = new NettyTransceiver(new InetSocketAddress(serverPort), 2000L);
            final Simple.Callback simpleClient2 = SpecificRequestor.getClient(Simple.Callback.class, transceiver2);
            blockingSimpleImpl.acquireEnterPermit();
            blockingSimpleImpl.acquireRunPermit();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        simpleClient2.add(3, 4);
                        Assert.fail((String)"Expected an exception");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            t.start();
            blockingSimpleImpl.acquireEnterPermit();
            server2.close();
            t.join(10000L);
            Assert.assertFalse((String)"Client request should not be blocked on server shutdown", (boolean)t.isAlive());
        }
        finally {
            blockingSimpleImpl.releaseRunPermit();
            server2.close();
            if (transceiver2 != null) {
                transceiver2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientReconnectAfterServerRestart() throws Exception {
        BlockingSimpleImpl simpleImpl = new BlockingSimpleImpl();
        NettyServer server2 = new NettyServer(new SpecificResponder(Simple.class, (Object)simpleImpl), new InetSocketAddress(0));
        try {
            server2.start();
            int serverPort = server2.getPort();
            System.out.println("server2 port : " + serverPort);
            NettyTransceiver transceiver2 = new NettyTransceiver(new InetSocketAddress(serverPort), 2000L);
            Simple.Callback simpleClient2 = SpecificRequestor.getClient(Simple.Callback.class, transceiver2);
            Assert.assertEquals((long)3L, (long)simpleClient2.add(1, 2));
            server2.close();
            try {
                simpleClient2.add(2, -1);
                Assert.fail((String)"Client should not be able to invoke RPCs because server is no longer running");
            }
            catch (Exception e) {
                // empty catch block
            }
            Thread.sleep(2000L);
            server2 = new NettyServer(new SpecificResponder(Simple.class, (Object)simpleImpl), new InetSocketAddress(serverPort));
            server2.start();
            Assert.assertEquals((long)3L, (long)simpleClient2.add(1, 2));
        }
        finally {
            server2.close();
        }
    }

    @Ignore
    @Test
    public void performanceTest() throws Exception {
        int threadCount = 8;
        long runTimeMillis = 10000L;
        ExecutorService threadPool = Executors.newFixedThreadPool(8);
        System.out.println("Running performance test for 10000ms...");
        final AtomicLong rpcCount = new AtomicLong(0L);
        final AtomicBoolean runFlag = new AtomicBoolean(true);
        final CountDownLatch startLatch = new CountDownLatch(8);
        for (int ii = 0; ii < 8; ++ii) {
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        startLatch.countDown();
                        startLatch.await(2L, TimeUnit.SECONDS);
                        while (runFlag.get()) {
                            rpcCount.incrementAndGet();
                            Assert.assertEquals((Object)"Hello, World!", (Object)simpleClient.hello("World!"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        startLatch.await(2L, TimeUnit.SECONDS);
        Thread.sleep(10000L);
        runFlag.set(false);
        threadPool.shutdown();
        Assert.assertTrue((String)"Timed out shutting down thread pool", (boolean)threadPool.awaitTermination(2L, TimeUnit.SECONDS));
        System.out.println("Completed " + rpcCount.get() + " RPCs in " + 10000L + "ms => " + (double)rpcCount.get() / 10000.0 * 1000.0 + " RPCs/sec, " + 10000.0 / (double)rpcCount.get() + " ms/RPC.");
    }

    static {
        ackFlag = new AtomicBoolean(false);
        ackLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        simpleService = new SimpleImpl(ackFlag);
    }

    private static class BlockingSimpleImpl
    extends SimpleImpl {
        private final Semaphore enterSemaphore = new Semaphore(1);
        private final Semaphore runSemaphore = new Semaphore(1);

        public BlockingSimpleImpl() {
            super(new AtomicBoolean());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String hello(String greeting) throws AvroRemoteException {
            this.releaseEnterPermit();
            this.acquireRunPermit();
            try {
                String string2 = super.hello(greeting);
                return string2;
            }
            finally {
                this.releaseRunPermit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TestRecord echo(TestRecord record2) throws AvroRemoteException {
            this.releaseEnterPermit();
            this.acquireRunPermit();
            try {
                TestRecord testRecord = super.echo(record2);
                return testRecord;
            }
            finally {
                this.releaseRunPermit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int add(int arg1, int arg2) throws AvroRemoteException {
            this.releaseEnterPermit();
            this.acquireRunPermit();
            try {
                int n = super.add(arg1, arg2);
                return n;
            }
            finally {
                this.releaseRunPermit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer echoBytes(ByteBuffer data2) throws AvroRemoteException {
            this.releaseEnterPermit();
            this.acquireRunPermit();
            try {
                ByteBuffer byteBuffer = super.echoBytes(data2);
                return byteBuffer;
            }
            finally {
                this.releaseRunPermit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void error() throws AvroRemoteException, TestError {
            this.releaseEnterPermit();
            this.acquireRunPermit();
            try {
                Void void_ = super.error();
                return void_;
            }
            finally {
                this.releaseRunPermit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ack() {
            this.releaseEnterPermit();
            this.acquireRunPermit();
            try {
                super.ack();
            }
            finally {
                this.releaseRunPermit();
            }
        }

        public void acquireRunPermit() {
            try {
                this.runSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        public void releaseRunPermit() {
            this.runSemaphore.release();
        }

        public void acquireEnterPermit() {
            try {
                this.enterSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        public void releaseEnterPermit() {
            this.enterSemaphore.release();
        }
    }

    private static class SimpleImpl
    implements Simple {
        private final AtomicBoolean ackFlag;

        public SimpleImpl(AtomicBoolean ackFlag) {
            this.ackFlag = ackFlag;
        }

        @Override
        public String hello(String greeting) throws AvroRemoteException {
            return "Hello, " + greeting;
        }

        @Override
        public TestRecord echo(TestRecord record2) throws AvroRemoteException {
            return record2;
        }

        @Override
        public int add(int arg1, int arg2) throws AvroRemoteException {
            return arg1 + arg2;
        }

        @Override
        public ByteBuffer echoBytes(ByteBuffer data2) throws AvroRemoteException {
            return data2;
        }

        @Override
        public Void error() throws AvroRemoteException, TestError {
            throw TestError.newBuilder().setMessage$("Test Message").build();
        }

        @Override
        public synchronized void ack() {
            this.ackFlag.set(!this.ackFlag.get());
            ((CountDownLatch)ackLatch.get()).countDown();
        }
    }
}

