/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.ipc.NettyServer;
import org.apache.avro.ipc.NettyTransceiver;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.test.Simple;
import org.apache.avro.test.TestError;
import org.apache.avro.test.TestRecord;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestNettyServerConcurrentExecution {
    private Server server;
    private Transceiver transceiver;

    @After
    public void cleanUpAfter() throws Exception {
        try {
            if (this.transceiver != null) {
                this.transceiver.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test(timeout=30000L)
    public void test() throws Exception {
        final CountDownLatch waitLatch = new CountDownLatch(1);
        this.server = new NettyServer(new SpecificResponder(Simple.class, (Object)new SimpleImpl(waitLatch)), new InetSocketAddress(0), new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), Executors.newCachedThreadPool()), new ExecutionHandler(Executors.newCachedThreadPool()));
        this.server.start();
        this.transceiver = new NettyTransceiver(new InetSocketAddress(this.server.getPort()), 2000L);
        final Simple.Callback simpleClient = SpecificRequestor.getClient(Simple.Callback.class, this.transceiver);
        SpecificRequestor.getRemote(simpleClient);
        new Thread(){

            @Override
            public void run() {
                this.setName(TestNettyServerConcurrentExecution.class.getSimpleName() + "Ack Thread");
                try {
                    waitLatch.await();
                    simpleClient.ack();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        String response = simpleClient.hello("wait");
        Assert.assertEquals((Object)"wait", (Object)response);
    }

    private static class SimpleImpl
    implements Simple {
        private final CountDownLatch waitLatch;
        private final CountDownLatch ackLatch = new CountDownLatch(1);

        public SimpleImpl(CountDownLatch waitLatch) {
            this.waitLatch = waitLatch;
        }

        @Override
        public int add(int arg1, int arg2) throws AvroRemoteException {
            return arg1 + arg2;
        }

        @Override
        public String hello(String greeting) throws AvroRemoteException {
            if (greeting.equals("wait")) {
                try {
                    this.waitLatch.countDown();
                    this.ackLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return e.toString();
                }
            }
            return greeting;
        }

        @Override
        public void ack() {
            this.ackLatch.countDown();
        }

        @Override
        public TestRecord echo(TestRecord record2) throws AvroRemoteException {
            return record2;
        }

        @Override
        public ByteBuffer echoBytes(ByteBuffer data2) throws AvroRemoteException {
            return data2;
        }

        @Override
        public Void error() throws AvroRemoteException, TestError {
            throw new TestError((Object)"TestError");
        }
    }
}

