/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.Protocol;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.ipc.LocalTransceiver;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.generic.GenericResponder;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;

public class TestLocalTransceiver {
    Protocol protocol = Protocol.parse("{\"protocol\": \"Minimal\", \"messages\": { \"m\": {   \"request\": [{\"name\": \"x\", \"type\": \"string\"}],    \"response\": \"string\"} } }");

    @Test
    public void testSingleRpc() throws IOException {
        LocalTransceiver t = new LocalTransceiver(new TestResponder(this.protocol));
        GenericData.Record params2 = new GenericData.Record(this.protocol.getMessages().get("m").getRequest());
        params2.put("x", (Object)new Utf8("hello"));
        GenericRequestor r = new GenericRequestor(this.protocol, t);
        for (int x = 0; x < 5; ++x) {
            Assert.assertEquals((Object)new Utf8("there"), (Object)r.request("m", params2));
        }
    }

    static class TestResponder
    extends GenericResponder {
        public TestResponder(Protocol local) {
            super(local);
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            Assert.assertEquals((Object)new Utf8("hello"), (Object)((GenericRecord)request).get("x"));
            return new Utf8("there");
        }
    }
}

