/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.ipc.Transceiver;

public class HttpTransceiver
extends Transceiver {
    static final String CONTENT_TYPE = "avro/binary";
    private URL url;
    private Proxy proxy;
    private HttpURLConnection connection;
    private int timeout;

    public HttpTransceiver(URL url) {
        this.url = url;
    }

    public HttpTransceiver(URL url, Proxy proxy) {
        this(url);
        this.proxy = proxy;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public String getRemoteName() {
        return this.url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<ByteBuffer> readBuffers() throws IOException {
        InputStream in = this.connection.getInputStream();
        try {
            List<ByteBuffer> list2 = HttpTransceiver.readBuffers(in);
            return list2;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writeBuffers(List<ByteBuffer> buffers) throws IOException {
        this.connection = this.proxy == null ? (HttpURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection(this.proxy);
        this.connection.setRequestMethod("POST");
        this.connection.setRequestProperty("Content-Type", CONTENT_TYPE);
        this.connection.setRequestProperty("Content-Length", Integer.toString(HttpTransceiver.getLength(buffers)));
        this.connection.setDoOutput(true);
        this.connection.setReadTimeout(this.timeout);
        this.connection.setConnectTimeout(this.timeout);
        OutputStream out = this.connection.getOutputStream();
        try {
            HttpTransceiver.writeBuffers(buffers, out);
        }
        finally {
            out.close();
        }
    }

    static int getLength(List<ByteBuffer> buffers) {
        int length = 0;
        for (ByteBuffer buffer2 : buffers) {
            length += 4;
            length += buffer2.remaining();
        }
        return length += 4;
    }

    static List<ByteBuffer> readBuffers(InputStream in) throws IOException {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        int length;
        while ((length = (in.read() << 24) + (in.read() << 16) + (in.read() << 8) + in.read()) != 0) {
            ByteBuffer buffer2 = ByteBuffer.allocate(length);
            while (buffer2.hasRemaining()) {
                int p = buffer2.position();
                int i = in.read(buffer2.array(), p, buffer2.remaining());
                if (i < 0) {
                    throw new EOFException("Unexpected EOF");
                }
                buffer2.position(p + i);
            }
            buffer2.flip();
            buffers.add(buffer2);
        }
        return buffers;
    }

    static void writeBuffers(List<ByteBuffer> buffers, OutputStream out) throws IOException {
        for (ByteBuffer buffer2 : buffers) {
            HttpTransceiver.writeLength(buffer2.limit(), out);
            out.write(buffer2.array(), buffer2.position(), buffer2.remaining());
            buffer2.position(buffer2.limit());
        }
        HttpTransceiver.writeLength(0, out);
    }

    private static void writeLength(int length, OutputStream out) throws IOException {
        out.write(0xFF & length >>> 24);
        out.write(0xFF & length >>> 16);
        out.write(0xFF & length >>> 8);
        out.write(0xFF & length);
    }
}

