/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import org.apache.avro.ipc.DatagramTransceiver;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.Transceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramServer
extends Thread
implements Server {
    private static final Logger LOG = LoggerFactory.getLogger(DatagramServer.class);
    private final Responder responder;
    private final DatagramChannel channel;
    private final Transceiver transceiver;

    public DatagramServer(Responder responder, SocketAddress addr) throws IOException {
        String name2 = "DatagramServer on " + addr;
        this.responder = responder;
        this.channel = DatagramChannel.open();
        this.channel.socket().bind(addr);
        this.transceiver = new DatagramTransceiver(this.channel);
        this.setName(name2);
        this.setDaemon(true);
    }

    @Override
    public int getPort() {
        return this.channel.socket().getLocalPort();
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.transceiver.writeBuffers(this.responder.respond(this.transceiver.readBuffers()));
            }
        }
        catch (ClosedChannelException e) {
            return;
        }
        catch (IOException e) {
            LOG.warn("unexpected error", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.interrupt();
    }

    public static void main(String[] arg) throws Exception {
        DatagramServer server = new DatagramServer(null, new InetSocketAddress(0));
        server.start();
        System.out.println("started");
        server.join();
    }
}

