/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.avro.ipc.Callback;

public class CallFuture<T>
implements Future<T>,
Callback<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Callback<T> chainedCallback;
    private T result = null;
    private Throwable error = null;

    public CallFuture() {
        this(null);
    }

    public CallFuture(Callback<T> chainedCallback) {
        this.chainedCallback = chainedCallback;
    }

    @Override
    public void handleResult(T result2) {
        this.result = result2;
        this.latch.countDown();
        if (this.chainedCallback != null) {
            this.chainedCallback.handleResult(result2);
        }
    }

    @Override
    public void handleError(Throwable error2) {
        this.error = error2;
        this.latch.countDown();
        if (this.chainedCallback != null) {
            this.chainedCallback.handleError(error2);
        }
    }

    public T getResult() {
        return this.result;
    }

    public Throwable getError() {
        return this.error;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.latch.await();
        if (this.error != null) {
            throw new ExecutionException(this.error);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit2) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.latch.await(timeout, unit2)) {
            if (this.error != null) {
                throw new ExecutionException(this.error);
            }
            return this.result;
        }
        throw new TimeoutException();
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public void await(long timeout, TimeUnit unit2) throws InterruptedException, TimeoutException {
        if (!this.latch.await(timeout, unit2)) {
            throw new TimeoutException();
        }
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() <= 0L;
    }
}

