/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.io.Encoder;
import org.apache.avro.util.Utf8;

public abstract class BinaryEncoder
extends Encoder {
    @Override
    public void writeNull() throws IOException {
    }

    @Override
    public void writeString(Utf8 utf8) throws IOException {
        this.writeBytes(utf8.getBytes(), 0, utf8.getByteLength());
    }

    @Override
    public void writeString(String string2) throws IOException {
        if (0 == string2.length()) {
            this.writeZero();
            return;
        }
        byte[] bytes2 = string2.getBytes("UTF-8");
        this.writeInt(bytes2.length);
        this.writeFixed(bytes2, 0, bytes2.length);
    }

    @Override
    public void writeBytes(ByteBuffer bytes2) throws IOException {
        int len = bytes2.limit() - bytes2.position();
        if (0 == len) {
            this.writeZero();
        } else {
            this.writeInt(len);
            this.writeFixed(bytes2);
        }
    }

    @Override
    public void writeBytes(byte[] bytes2, int start, int len) throws IOException {
        if (0 == len) {
            this.writeZero();
            return;
        }
        this.writeInt(len);
        this.writeFixed(bytes2, start, len);
    }

    @Override
    public void writeEnum(int e) throws IOException {
        this.writeInt(e);
    }

    @Override
    public void writeArrayStart() throws IOException {
    }

    @Override
    public void setItemCount(long itemCount) throws IOException {
        if (itemCount > 0L) {
            this.writeLong(itemCount);
        }
    }

    @Override
    public void startItem() throws IOException {
    }

    @Override
    public void writeArrayEnd() throws IOException {
        this.writeZero();
    }

    @Override
    public void writeMapStart() throws IOException {
    }

    @Override
    public void writeMapEnd() throws IOException {
        this.writeZero();
    }

    @Override
    public void writeIndex(int unionIndex) throws IOException {
        this.writeInt(unionIndex);
    }

    protected abstract void writeZero() throws IOException;

    public abstract int bytesBuffered();
}

