/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.util;

import java.util.Comparator;

public class AvroCharSequenceComparator<T>
implements Comparator<T> {
    public static final AvroCharSequenceComparator<CharSequence> INSTANCE = new AvroCharSequenceComparator();

    @Override
    public int compare(T o1, T o2) {
        if (!(o1 instanceof CharSequence) || !(o2 instanceof CharSequence)) {
            throw new RuntimeException("Attempted use of AvroCharSequenceComparator on non-CharSequence objects: " + o1.getClass().getName() + " and " + o2.getClass().getName());
        }
        return this.compareCharSequence((CharSequence)o1, (CharSequence)o2);
    }

    private int compareCharSequence(CharSequence o1, CharSequence o2) {
        for (int i = 0; i < Math.max(o1.length(), o2.length()); ++i) {
            int charComparison = this.compareCharacter(o1, o2, i);
            if (0 == charComparison) continue;
            return charComparison;
        }
        return 0;
    }

    private int compareCharacter(CharSequence o1, CharSequence o2, int index2) {
        if (index2 < o1.length() && index2 < o2.length()) {
            return Character.valueOf(o1.charAt(index2)).compareTo(Character.valueOf(o2.charAt(index2)));
        }
        if (index2 >= o1.length() && index2 >= o2.length()) {
            return 0;
        }
        return o1.length() - o2.length();
    }
}

