/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.UnresolvedUnionException;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryData;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.apache.avro.util.Utf8;
import org.codehaus.jackson.JsonNode;

public class GenericData {
    private static final GenericData INSTANCE = new GenericData();
    protected static final String STRING_PROP = "avro.java.string";
    protected static final String STRING_TYPE_STRING = "String";
    private final Map<Schema.Field, Object> defaultValueCache = Collections.synchronizedMap(new WeakHashMap());
    private static final Schema STRINGS = Schema.create(Schema.Type.STRING);

    public static void setStringType(Schema s2, StringType stringType) {
        if (stringType == StringType.String) {
            s2.addProp(STRING_PROP, STRING_TYPE_STRING);
        }
    }

    public static GenericData get() {
        return INSTANCE;
    }

    protected GenericData() {
    }

    public DatumReader createDatumReader(Schema schema) {
        return new GenericDatumReader(schema, schema, this);
    }

    public boolean validate(Schema schema, Object datum) {
        switch (schema.getType()) {
            case RECORD: {
                if (!this.isRecord(datum)) {
                    return false;
                }
                for (Schema.Field f2 : schema.getFields()) {
                    if (this.validate(f2.schema(), this.getField(datum, f2.name(), f2.pos()))) continue;
                    return false;
                }
                return true;
            }
            case ENUM: {
                return schema.getEnumSymbols().contains(datum.toString());
            }
            case ARRAY: {
                if (!this.isArray(datum)) {
                    return false;
                }
                for (Object element : (Collection)datum) {
                    if (this.validate(schema.getElementType(), element)) continue;
                    return false;
                }
                return true;
            }
            case MAP: {
                if (!this.isMap(datum)) {
                    return false;
                }
                Map map2 = (Map)datum;
                for (Map.Entry entry2 : map2.entrySet()) {
                    if (this.validate(schema.getValueType(), entry2.getValue())) continue;
                    return false;
                }
                return true;
            }
            case UNION: {
                for (Schema type : schema.getTypes()) {
                    if (!this.validate(type, datum)) continue;
                    return true;
                }
                return false;
            }
            case FIXED: {
                return datum instanceof GenericFixed && ((GenericFixed)datum).bytes().length == schema.getFixedSize();
            }
            case STRING: {
                return this.isString(datum);
            }
            case BYTES: {
                return this.isBytes(datum);
            }
            case INT: {
                return this.isInteger(datum);
            }
            case LONG: {
                return this.isLong(datum);
            }
            case FLOAT: {
                return this.isFloat(datum);
            }
            case DOUBLE: {
                return this.isDouble(datum);
            }
            case BOOLEAN: {
                return this.isBoolean(datum);
            }
            case NULL: {
                return datum == null;
            }
        }
        return false;
    }

    public String toString(Object datum) {
        StringBuilder buffer2 = new StringBuilder();
        this.toString(datum, buffer2);
        return buffer2.toString();
    }

    protected void toString(Object datum, StringBuilder buffer2) {
        if (this.isRecord(datum)) {
            buffer2.append("{");
            int count2 = 0;
            Schema schema = this.getRecordSchema(datum);
            for (Schema.Field f2 : schema.getFields()) {
                this.toString(f2.name(), buffer2);
                buffer2.append(": ");
                this.toString(this.getField(datum, f2.name(), f2.pos()), buffer2);
                if (++count2 >= schema.getFields().size()) continue;
                buffer2.append(", ");
            }
            buffer2.append("}");
        } else if (this.isArray(datum)) {
            Collection array2 = (Collection)datum;
            buffer2.append("[");
            long last2 = array2.size() - 1;
            int i = 0;
            for (Object element : array2) {
                this.toString(element, buffer2);
                if ((long)i++ >= last2) continue;
                buffer2.append(", ");
            }
            buffer2.append("]");
        } else if (this.isMap(datum)) {
            buffer2.append("{");
            int count3 = 0;
            Map map2 = (Map)datum;
            for (Map.Entry entry2 : map2.entrySet()) {
                this.toString(entry2.getKey(), buffer2);
                buffer2.append(": ");
                this.toString(entry2.getValue(), buffer2);
                if (++count3 >= map2.size()) continue;
                buffer2.append(", ");
            }
            buffer2.append("}");
        } else if (this.isString(datum) || this.isEnum(datum)) {
            buffer2.append("\"");
            this.writeEscapedString(datum.toString(), buffer2);
            buffer2.append("\"");
        } else if (this.isBytes(datum)) {
            buffer2.append("{\"bytes\": \"");
            ByteBuffer bytes2 = (ByteBuffer)datum;
            for (int i = bytes2.position(); i < bytes2.limit(); ++i) {
                buffer2.append((char)bytes2.get(i));
            }
            buffer2.append("\"}");
        } else {
            buffer2.append(datum);
        }
    }

    private void writeEscapedString(String string2, StringBuilder builder) {
        block10: for (int i = 0; i < string2.length(); ++i) {
            char ch = string2.charAt(i);
            switch (ch) {
                case '\"': {
                    builder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    builder.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block10;
                }
                case '/': {
                    builder.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String hex = Integer.toHexString(ch);
                        builder.append("\\u");
                        for (int j = 0; j < 4 - hex.length(); ++j) {
                            builder.append('0');
                        }
                        builder.append(hex.toUpperCase());
                        continue block10;
                    }
                    builder.append(ch);
                }
            }
        }
    }

    public Schema induce(Object datum) {
        if (this.isRecord(datum)) {
            return this.getRecordSchema(datum);
        }
        if (this.isArray(datum)) {
            Schema elementType2 = null;
            for (Object element : (Collection)datum) {
                if (elementType2 == null) {
                    elementType2 = this.induce(element);
                    continue;
                }
                if (elementType2.equals(this.induce(element))) continue;
                throw new AvroTypeException("No mixed type arrays.");
            }
            if (elementType2 == null) {
                throw new AvroTypeException("Empty array: " + datum);
            }
            return Schema.createArray(elementType2);
        }
        if (this.isMap(datum)) {
            Map map2 = (Map)datum;
            Schema value2 = null;
            for (Map.Entry entry2 : map2.entrySet()) {
                if (value2 == null) {
                    value2 = this.induce(entry2.getValue());
                    continue;
                }
                if (value2.equals(this.induce(entry2.getValue()))) continue;
                throw new AvroTypeException("No mixed type map values.");
            }
            if (value2 == null) {
                throw new AvroTypeException("Empty map: " + datum);
            }
            return Schema.createMap(value2);
        }
        if (datum instanceof GenericFixed) {
            return Schema.createFixed(null, null, null, ((GenericFixed)datum).bytes().length);
        }
        if (this.isString(datum)) {
            return Schema.create(Schema.Type.STRING);
        }
        if (this.isBytes(datum)) {
            return Schema.create(Schema.Type.BYTES);
        }
        if (this.isInteger(datum)) {
            return Schema.create(Schema.Type.INT);
        }
        if (this.isLong(datum)) {
            return Schema.create(Schema.Type.LONG);
        }
        if (this.isFloat(datum)) {
            return Schema.create(Schema.Type.FLOAT);
        }
        if (this.isDouble(datum)) {
            return Schema.create(Schema.Type.DOUBLE);
        }
        if (this.isBoolean(datum)) {
            return Schema.create(Schema.Type.BOOLEAN);
        }
        if (datum == null) {
            return Schema.create(Schema.Type.NULL);
        }
        throw new AvroTypeException("Can't create schema for: " + datum);
    }

    public void setField(Object record2, String name2, int position2, Object o) {
        ((IndexedRecord)record2).put(position2, o);
    }

    public Object getField(Object record2, String name2, int position2) {
        return ((IndexedRecord)record2).get(position2);
    }

    protected Object getRecordState(Object record2, Schema schema) {
        return null;
    }

    protected void setField(Object r, String n, int p, Object o, Object state) {
        this.setField(r, n, p, o);
    }

    protected Object getField(Object record2, String name2, int pos, Object state) {
        return this.getField(record2, name2, pos);
    }

    public int resolveUnion(Schema union2, Object datum) {
        Integer i = union2.getIndexNamed(this.getSchemaName(datum));
        if (i != null) {
            return i;
        }
        throw new UnresolvedUnionException(union2, datum);
    }

    protected String getSchemaName(Object datum) {
        if (datum == null) {
            return Schema.Type.NULL.getName();
        }
        if (this.isRecord(datum)) {
            return this.getRecordSchema(datum).getFullName();
        }
        if (this.isEnum(datum)) {
            return this.getEnumSchema(datum).getFullName();
        }
        if (this.isArray(datum)) {
            return Schema.Type.ARRAY.getName();
        }
        if (this.isMap(datum)) {
            return Schema.Type.MAP.getName();
        }
        if (this.isFixed(datum)) {
            return this.getFixedSchema(datum).getFullName();
        }
        if (this.isString(datum)) {
            return Schema.Type.STRING.getName();
        }
        if (this.isBytes(datum)) {
            return Schema.Type.BYTES.getName();
        }
        if (this.isInteger(datum)) {
            return Schema.Type.INT.getName();
        }
        if (this.isLong(datum)) {
            return Schema.Type.LONG.getName();
        }
        if (this.isFloat(datum)) {
            return Schema.Type.FLOAT.getName();
        }
        if (this.isDouble(datum)) {
            return Schema.Type.DOUBLE.getName();
        }
        if (this.isBoolean(datum)) {
            return Schema.Type.BOOLEAN.getName();
        }
        throw new AvroRuntimeException("Unknown datum type: " + datum);
    }

    protected boolean instanceOf(Schema schema, Object datum) {
        switch (schema.getType()) {
            case RECORD: {
                if (!this.isRecord(datum)) {
                    return false;
                }
                return schema.getFullName() == null ? this.getRecordSchema(datum).getFullName() == null : schema.getFullName().equals(this.getRecordSchema(datum).getFullName());
            }
            case ENUM: {
                if (!this.isEnum(datum)) {
                    return false;
                }
                return schema.getFullName().equals(this.getEnumSchema(datum).getFullName());
            }
            case ARRAY: {
                return this.isArray(datum);
            }
            case MAP: {
                return this.isMap(datum);
            }
            case FIXED: {
                if (!this.isFixed(datum)) {
                    return false;
                }
                return schema.getFullName().equals(this.getFixedSchema(datum).getFullName());
            }
            case STRING: {
                return this.isString(datum);
            }
            case BYTES: {
                return this.isBytes(datum);
            }
            case INT: {
                return this.isInteger(datum);
            }
            case LONG: {
                return this.isLong(datum);
            }
            case FLOAT: {
                return this.isFloat(datum);
            }
            case DOUBLE: {
                return this.isDouble(datum);
            }
            case BOOLEAN: {
                return this.isBoolean(datum);
            }
            case NULL: {
                return datum == null;
            }
        }
        throw new AvroRuntimeException("Unexpected type: " + schema);
    }

    protected boolean isArray(Object datum) {
        return datum instanceof Collection;
    }

    protected boolean isRecord(Object datum) {
        return datum instanceof IndexedRecord;
    }

    protected Schema getRecordSchema(Object record2) {
        return ((GenericContainer)record2).getSchema();
    }

    protected boolean isEnum(Object datum) {
        return datum instanceof GenericEnumSymbol;
    }

    protected Schema getEnumSchema(Object enu) {
        return ((GenericContainer)enu).getSchema();
    }

    protected boolean isMap(Object datum) {
        return datum instanceof Map;
    }

    protected boolean isFixed(Object datum) {
        return datum instanceof GenericFixed;
    }

    protected Schema getFixedSchema(Object fixed) {
        return ((GenericContainer)fixed).getSchema();
    }

    protected boolean isString(Object datum) {
        return datum instanceof CharSequence;
    }

    protected boolean isBytes(Object datum) {
        return datum instanceof ByteBuffer;
    }

    protected boolean isInteger(Object datum) {
        return datum instanceof Integer;
    }

    protected boolean isLong(Object datum) {
        return datum instanceof Long;
    }

    protected boolean isFloat(Object datum) {
        return datum instanceof Float;
    }

    protected boolean isDouble(Object datum) {
        return datum instanceof Double;
    }

    protected boolean isBoolean(Object datum) {
        return datum instanceof Boolean;
    }

    public int hashCode(Object o, Schema s2) {
        if (o == null) {
            return 0;
        }
        int hashCode = 1;
        switch (s2.getType()) {
            case RECORD: {
                for (Schema.Field f2 : s2.getFields()) {
                    if (f2.order() == Schema.Field.Order.IGNORE) continue;
                    hashCode = this.hashCodeAdd(hashCode, this.getField(o, f2.name(), f2.pos()), f2.schema());
                }
                return hashCode;
            }
            case ARRAY: {
                Collection a = (Collection)o;
                Schema elementType2 = s2.getElementType();
                for (Object e : a) {
                    hashCode = this.hashCodeAdd(hashCode, e, elementType2);
                }
                return hashCode;
            }
            case UNION: {
                return this.hashCode(o, s2.getTypes().get(this.resolveUnion(s2, o)));
            }
            case ENUM: {
                return s2.getEnumOrdinal(o.toString());
            }
            case NULL: {
                return 0;
            }
            case STRING: {
                return (o instanceof Utf8 ? o : new Utf8(o.toString())).hashCode();
            }
        }
        return o.hashCode();
    }

    protected int hashCodeAdd(int hashCode, Object o, Schema s2) {
        return 31 * hashCode + this.hashCode(o, s2);
    }

    public int compare(Object o1, Object o2, Schema s2) {
        return this.compare(o1, o2, s2, false);
    }

    protected int compare(Object o1, Object o2, Schema s2, boolean equals2) {
        if (o1 == o2) {
            return 0;
        }
        switch (s2.getType()) {
            case RECORD: {
                for (Schema.Field f2 : s2.getFields()) {
                    if (f2.order() == Schema.Field.Order.IGNORE) continue;
                    int pos = f2.pos();
                    String name2 = f2.name();
                    int compare2 = this.compare(this.getField(o1, name2, pos), this.getField(o2, name2, pos), f2.schema(), equals2);
                    if (compare2 == 0) continue;
                    return f2.order() == Schema.Field.Order.DESCENDING ? -compare2 : compare2;
                }
                return 0;
            }
            case ENUM: {
                return s2.getEnumOrdinal(o1.toString()) - s2.getEnumOrdinal(o2.toString());
            }
            case ARRAY: {
                Collection a1 = (Collection)o1;
                Collection a2 = (Collection)o2;
                Iterator e1 = a1.iterator();
                Iterator e2 = a2.iterator();
                Schema elementType2 = s2.getElementType();
                while (e1.hasNext() && e2.hasNext()) {
                    int compare3 = this.compare(e1.next(), e2.next(), elementType2, equals2);
                    if (compare3 == 0) continue;
                    return compare3;
                }
                return e1.hasNext() ? 1 : (e2.hasNext() ? -1 : 0);
            }
            case MAP: {
                if (equals2) {
                    return ((Map)o1).equals(o2) ? 0 : 1;
                }
                throw new AvroRuntimeException("Can't compare maps!");
            }
            case UNION: {
                int i1 = this.resolveUnion(s2, o1);
                int i2 = this.resolveUnion(s2, o2);
                return i1 == i2 ? this.compare(o1, o2, s2.getTypes().get(i1), equals2) : i1 - i2;
            }
            case NULL: {
                return 0;
            }
            case STRING: {
                Utf8 u1 = o1 instanceof Utf8 ? (Utf8)o1 : new Utf8(o1.toString());
                Utf8 u2 = o2 instanceof Utf8 ? (Utf8)o2 : new Utf8(o2.toString());
                return u1.compareTo(u2);
            }
        }
        return ((Comparable)o1).compareTo(o2);
    }

    public Object getDefaultValue(Schema.Field field2) {
        JsonNode json = field2.defaultValue();
        if (json == null) {
            throw new AvroRuntimeException("Field " + field2 + " not set and has no default value");
        }
        if (json.isNull() && (field2.schema().getType() == Schema.Type.NULL || field2.schema().getType() == Schema.Type.UNION && field2.schema().getTypes().get(0).getType() == Schema.Type.NULL)) {
            return null;
        }
        Object defaultValue2 = this.defaultValueCache.get(field2);
        if (defaultValue2 == null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryEncoder encoder2 = EncoderFactory.get().binaryEncoder(baos, null);
                ResolvingGrammarGenerator.encode(encoder2, field2.schema(), json);
                encoder2.flush();
                BinaryDecoder decoder2 = DecoderFactory.get().binaryDecoder(baos.toByteArray(), null);
                defaultValue2 = this.createDatumReader(field2.schema()).read(null, decoder2);
                this.defaultValueCache.put(field2, defaultValue2);
            }
            catch (IOException e) {
                throw new AvroRuntimeException(e);
            }
        }
        return defaultValue2;
    }

    public <T> T deepCopy(Schema schema, T value2) {
        if (value2 == null) {
            return null;
        }
        switch (schema.getType()) {
            case ARRAY: {
                List arrayValue = (List)value2;
                Array arrayCopy = new Array(arrayValue.size(), schema);
                for (Object obj : arrayValue) {
                    arrayCopy.add(this.deepCopy(schema.getElementType(), obj));
                }
                return (T)arrayCopy;
            }
            case BOOLEAN: {
                return (T)new Boolean((Boolean)value2);
            }
            case BYTES: {
                ByteBuffer byteBufferValue = (ByteBuffer)value2;
                int start = byteBufferValue.position();
                int length = byteBufferValue.limit() - start;
                byte[] bytesCopy = new byte[length];
                byteBufferValue.get(bytesCopy, 0, length);
                byteBufferValue.position(start);
                return (T)ByteBuffer.wrap(bytesCopy, 0, length);
            }
            case DOUBLE: {
                return (T)new Double((Double)value2);
            }
            case ENUM: {
                return value2;
            }
            case FIXED: {
                return (T)this.createFixed(null, ((GenericFixed)value2).bytes(), schema);
            }
            case FLOAT: {
                return (T)new Float(((Float)value2).floatValue());
            }
            case INT: {
                return (T)new Integer((Integer)value2);
            }
            case LONG: {
                return (T)new Long((Long)value2);
            }
            case MAP: {
                Map mapValue = (Map)value2;
                HashMap mapCopy = new HashMap(mapValue.size());
                for (Map.Entry entry2 : mapValue.entrySet()) {
                    mapCopy.put((CharSequence)this.deepCopy(STRINGS, entry2.getKey()), this.deepCopy(schema.getValueType(), entry2.getValue()));
                }
                return (T)mapCopy;
            }
            case NULL: {
                return null;
            }
            case RECORD: {
                IndexedRecord recordValue = (IndexedRecord)value2;
                IndexedRecord recordCopy = (IndexedRecord)this.newRecord(null, schema);
                for (Schema.Field field2 : schema.getFields()) {
                    recordCopy.put(field2.pos(), this.deepCopy(field2.schema(), recordValue.get(field2.pos())));
                }
                return (T)recordCopy;
            }
            case STRING: {
                if (value2 instanceof String) {
                    return value2;
                }
                if (value2 instanceof Utf8) {
                    return (T)new Utf8((Utf8)value2);
                }
                return (T)new Utf8(value2.toString());
            }
            case UNION: {
                return this.deepCopy(schema.getTypes().get(this.resolveUnion(schema, value2)), value2);
            }
        }
        throw new AvroRuntimeException("Deep copy failed for schema \"" + schema + "\" and value \"" + value2 + "\"");
    }

    public Object createFixed(Object old, Schema schema) {
        if (old instanceof GenericFixed && ((GenericFixed)old).bytes().length == schema.getFixedSize()) {
            return old;
        }
        return new Fixed(schema);
    }

    public Object createFixed(Object old, byte[] bytes2, Schema schema) {
        GenericFixed fixed = (GenericFixed)this.createFixed(old, schema);
        System.arraycopy(bytes2, 0, fixed.bytes(), 0, schema.getFixedSize());
        return fixed;
    }

    public Object newRecord(Object old, Schema schema) {
        IndexedRecord record2;
        if (old instanceof IndexedRecord && (record2 = (IndexedRecord)old).getSchema() == schema) {
            return record2;
        }
        return new Record(schema);
    }

    public static class EnumSymbol
    implements GenericEnumSymbol {
        private Schema schema;
        private String symbol;

        public EnumSymbol(Schema schema, String symbol) {
            this.schema = schema;
            this.symbol = symbol;
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof GenericEnumSymbol && this.symbol.equals(o.toString());
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }

        @Override
        public String toString() {
            return this.symbol;
        }
    }

    public static class Fixed
    implements GenericFixed,
    Comparable<Fixed> {
        private Schema schema;
        private byte[] bytes;

        public Fixed(Schema schema) {
            this.setSchema(schema);
        }

        public Fixed(Schema schema, byte[] bytes2) {
            this.schema = schema;
            this.bytes = bytes2;
        }

        protected Fixed() {
        }

        protected void setSchema(Schema schema) {
            this.schema = schema;
            this.bytes = new byte[schema.getFixedSize()];
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        public void bytes(byte[] bytes2) {
            this.bytes = bytes2;
        }

        @Override
        public byte[] bytes() {
            return this.bytes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof GenericFixed && Arrays.equals(this.bytes, ((GenericFixed)o).bytes());
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public String toString() {
            return Arrays.toString(this.bytes);
        }

        @Override
        public int compareTo(Fixed that) {
            return BinaryData.compareBytes(this.bytes, 0, this.bytes.length, that.bytes, 0, that.bytes.length);
        }
    }

    public static class Array<T>
    extends AbstractList<T>
    implements GenericArray<T>,
    Comparable<GenericArray<T>> {
        private static final Object[] EMPTY = new Object[0];
        private final Schema schema;
        private int size;
        private Object[] elements = EMPTY;

        public Array(int capacity, Schema schema) {
            if (schema == null || !Schema.Type.ARRAY.equals((Object)schema.getType())) {
                throw new AvroRuntimeException("Not an array schema: " + schema);
            }
            this.schema = schema;
            if (capacity != 0) {
                this.elements = new Object[capacity];
            }
        }

        public Array(Schema schema, Collection<T> c) {
            if (schema == null || !Schema.Type.ARRAY.equals((Object)schema.getType())) {
                throw new AvroRuntimeException("Not an array schema: " + schema);
            }
            this.schema = schema;
            if (c != null) {
                this.elements = new Object[c.size()];
                this.addAll(c);
            }
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int position = 0;

                @Override
                public boolean hasNext() {
                    return this.position < Array.this.size;
                }

                @Override
                public T next() {
                    return Array.this.elements[this.position++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public T get(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            return (T)this.elements[i];
        }

        @Override
        public boolean add(T o) {
            if (this.size == this.elements.length) {
                Object[] newElements = new Object[this.size * 3 / 2 + 1];
                System.arraycopy(this.elements, 0, newElements, 0, this.size);
                this.elements = newElements;
            }
            this.elements[this.size++] = o;
            return true;
        }

        @Override
        public void add(int location, T o) {
            if (location > this.size || location < 0) {
                throw new IndexOutOfBoundsException("Index " + location + " out of bounds.");
            }
            if (this.size == this.elements.length) {
                Object[] newElements = new Object[this.size * 3 / 2 + 1];
                System.arraycopy(this.elements, 0, newElements, 0, this.size);
                this.elements = newElements;
            }
            System.arraycopy(this.elements, location, this.elements, location + 1, this.size - location);
            this.elements[location] = o;
            ++this.size;
        }

        @Override
        public T set(int i, T o) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            Object response = this.elements[i];
            this.elements[i] = o;
            return (T)response;
        }

        @Override
        public T remove(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            Object result2 = this.elements[i];
            --this.size;
            System.arraycopy(this.elements, i + 1, this.elements, i, this.size - i);
            this.elements[this.size] = null;
            return (T)result2;
        }

        @Override
        public T peek() {
            return (T)(this.size < this.elements.length ? this.elements[this.size] : null);
        }

        @Override
        public int compareTo(GenericArray<T> that) {
            return GenericData.get().compare(this, that, this.getSchema());
        }

        @Override
        public void reverse() {
            int left3 = 0;
            for (int right = this.elements.length - 1; left3 < right; ++left3, --right) {
                Object tmp = this.elements[left3];
                this.elements[left3] = this.elements[right];
                this.elements[right] = tmp;
            }
        }

        @Override
        public String toString() {
            StringBuilder buffer2 = new StringBuilder();
            buffer2.append("[");
            int count2 = 0;
            for (T e : this) {
                buffer2.append(e == null ? "null" : e.toString());
                if (++count2 >= this.size()) continue;
                buffer2.append(", ");
            }
            buffer2.append("]");
            return buffer2.toString();
        }
    }

    public static class Record
    implements GenericRecord,
    Comparable<Record> {
        private final Schema schema;
        private final Object[] values;

        public Record(Schema schema) {
            if (schema == null || !Schema.Type.RECORD.equals((Object)schema.getType())) {
                throw new AvroRuntimeException("Not a record schema: " + schema);
            }
            this.schema = schema;
            this.values = new Object[schema.getFields().size()];
        }

        public Record(Record other, boolean deepCopy) {
            this.schema = other.schema;
            this.values = new Object[this.schema.getFields().size()];
            if (deepCopy) {
                for (int ii = 0; ii < this.values.length; ++ii) {
                    this.values[ii] = INSTANCE.deepCopy(this.schema.getFields().get(ii).schema(), other.values[ii]);
                }
            } else {
                System.arraycopy(other.values, 0, this.values, 0, other.values.length);
            }
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        @Override
        public void put(String key, Object value2) {
            Schema.Field field2 = this.schema.getField(key);
            if (field2 == null) {
                throw new AvroRuntimeException("Not a valid schema field: " + key);
            }
            this.values[field2.pos()] = value2;
        }

        @Override
        public void put(int i, Object v) {
            this.values[i] = v;
        }

        @Override
        public Object get(String key) {
            Schema.Field field2 = this.schema.getField(key);
            if (field2 == null) {
                return null;
            }
            return this.values[field2.pos()];
        }

        @Override
        public Object get(int i) {
            return this.values[i];
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            Record that = (Record)o;
            if (!this.schema.equals(that.schema)) {
                return false;
            }
            return GenericData.get().compare(this, that, this.schema, true) == 0;
        }

        public int hashCode() {
            return GenericData.get().hashCode(this, this.schema);
        }

        @Override
        public int compareTo(Record that) {
            return GenericData.get().compare(this, that, this.schema);
        }

        public String toString() {
            return GenericData.get().toString(this);
        }
    }

    public static enum StringType {
        CharSequence,
        String,
        Utf8;

    }
}

