/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import org.apache.avro.SimpleException;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.ipc.SocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.reflect.ReflectRequestor;
import org.apache.avro.ipc.reflect.ReflectResponder;
import org.apache.avro.reflect.ReflectData;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestProtocolReflect {
    private static boolean throwUndeclaredError;
    protected static Server server;
    protected static Transceiver client;
    protected static Simple proxy;

    @Before
    public void testStartServer() throws Exception {
        if (server != null) {
            return;
        }
        server = new SocketServer(new ReflectResponder(Simple.class, (Object)new TestImpl()), new InetSocketAddress(0));
        server.start();
        client = new SocketTransceiver(new InetSocketAddress(server.getPort()));
        proxy = ReflectRequestor.getClient(Simple.class, client);
    }

    @Test
    public void testClassLoader() throws Exception {
        ClassLoader loader = new ClassLoader(){};
        ReflectResponder responder = new ReflectResponder(Simple.class, (Object)new TestImpl(), new ReflectData(loader));
        Assert.assertEquals((Object)responder.getReflectData().getClassLoader(), (Object)loader);
        ReflectRequestor requestor = new ReflectRequestor(Simple.class, client, new ReflectData(loader));
        Assert.assertEquals((Object)requestor.getReflectData().getClassLoader(), (Object)loader);
    }

    @Test
    public void testHello() throws IOException {
        String response = proxy.hello("bob");
        Assert.assertEquals((Object)"goodbye", (Object)response);
    }

    @Test
    public void testEcho() throws IOException {
        TestRecord record2 = new TestRecord();
        record2.name = "foo";
        TestRecord echoed = proxy.echo(record2);
        Assert.assertEquals((Object)record2, (Object)echoed);
    }

    @Test
    public void testAdd() throws IOException {
        int result2 = proxy.add(1, 2);
        Assert.assertEquals((long)3L, (long)result2);
    }

    @Test
    public void testEchoBytes() throws IOException {
        Random random = new Random();
        int length = random.nextInt(16384);
        byte[] data2 = new byte[length];
        random.nextBytes(data2);
        byte[] echoed = proxy.echoBytes(data2);
        Assert.assertArrayEquals((byte[])data2, (byte[])echoed);
    }

    @Test
    public void testError() throws IOException {
        SimpleException error2 = null;
        try {
            proxy.error();
        }
        catch (SimpleException e) {
            error2 = e;
        }
        Assert.assertNotNull((Object)error2);
        Assert.assertEquals((Object)"foo", (Object)error2.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUndeclaredError() throws Exception {
        throwUndeclaredError = true;
        RuntimeException error2 = null;
        try {
            proxy.error();
        }
        catch (RuntimeException e) {
            error2 = e;
        }
        finally {
            throwUndeclaredError = false;
        }
        Assert.assertNotNull((Object)error2);
        Assert.assertTrue((boolean)error2.toString().contains("foo"));
    }

    @AfterClass
    public static void testStopServer() throws IOException {
        client.close();
        server.close();
    }

    public static class TestImpl
    implements Simple {
        @Override
        public String hello(String greeting) {
            return "goodbye";
        }

        @Override
        public int add(int arg1, int arg2) {
            return arg1 + arg2;
        }

        @Override
        public TestRecord echo(TestRecord record2) {
            return record2;
        }

        @Override
        public byte[] echoBytes(byte[] data2) {
            return data2;
        }

        @Override
        public void error() throws SimpleException {
            if (throwUndeclaredError) {
                throw new RuntimeException("foo");
            }
            throw new SimpleException("foo");
        }
    }

    public static interface Simple {
        public String hello(String var1);

        public TestRecord echo(TestRecord var1);

        public int add(int var1, int var2);

        public byte[] echoBytes(byte[] var1);

        public void error() throws SimpleException;
    }

    public static class TestRecord {
        private String name;

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object that) {
            return this.name.equals(((TestRecord)that).name);
        }
    }
}

