/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.ipc.SocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.generic.GenericResponder;
import org.apache.avro.util.Utf8;
import org.codehaus.jackson.node.BooleanNode;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProtocolGeneric {
    private static final Logger LOG = LoggerFactory.getLogger(TestProtocolGeneric.class);
    protected static final File FILE = new File("../../../share/test/schemas/simple.avpr");
    protected static final Protocol PROTOCOL;
    private static boolean throwUndeclaredError;
    protected static SocketServer server;
    protected static Transceiver client;
    protected static GenericRequestor requestor;

    @Before
    public void testStartServer() throws Exception {
        if (server != null) {
            return;
        }
        server = new SocketServer(new TestResponder(), new InetSocketAddress(0));
        server.start();
        client = new SocketTransceiver(new InetSocketAddress(server.getPort()));
        requestor = new GenericRequestor(PROTOCOL, client);
    }

    @Test
    public void testHello() throws IOException {
        GenericData.Record params2 = new GenericData.Record(PROTOCOL.getMessages().get("hello").getRequest());
        params2.put("greeting", (Object)new Utf8("bob"));
        Utf8 response = (Utf8)requestor.request("hello", params2);
        Assert.assertEquals((Object)new Utf8("goodbye"), (Object)response);
    }

    @Test
    public void testEcho() throws IOException {
        GenericData.Record record2 = new GenericData.Record(PROTOCOL.getType("TestRecord"));
        record2.put("name", (Object)new Utf8("foo"));
        record2.put("kind", (Object)new GenericData.EnumSymbol(PROTOCOL.getType("Kind"), "BAR"));
        record2.put("hash", (Object)new GenericData.Fixed(PROTOCOL.getType("MD5"), new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
        GenericData.Record params2 = new GenericData.Record(PROTOCOL.getMessages().get("echo").getRequest());
        params2.put("record", (Object)record2);
        Object echoed = requestor.request("echo", params2);
        Assert.assertEquals((Object)record2, (Object)echoed);
    }

    @Test
    public void testEchoBytes() throws IOException {
        Random random = new Random();
        int length = random.nextInt(16384);
        GenericData.Record params2 = new GenericData.Record(PROTOCOL.getMessages().get("echoBytes").getRequest());
        ByteBuffer data2 = ByteBuffer.allocate(length);
        random.nextBytes(data2.array());
        data2.flip();
        params2.put("data", (Object)data2);
        Object echoed = requestor.request("echoBytes", params2);
        Assert.assertEquals((Object)data2, (Object)echoed);
    }

    @Test
    public void testError() throws IOException {
        GenericData.Record params2 = new GenericData.Record(PROTOCOL.getMessages().get("error").getRequest());
        AvroRemoteException error2 = null;
        try {
            requestor.request("error", params2);
        }
        catch (AvroRemoteException e) {
            error2 = e;
        }
        Assert.assertNotNull((Object)error2);
        Assert.assertEquals((Object)"an error", (Object)((GenericRecord)error2.getValue()).get("message").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUndeclaredError() throws IOException {
        throwUndeclaredError = true;
        RuntimeException error2 = null;
        GenericData.Record params2 = new GenericData.Record(PROTOCOL.getMessages().get("error").getRequest());
        try {
            requestor.request("error", params2);
        }
        catch (RuntimeException e) {
            error2 = e;
        }
        finally {
            throwUndeclaredError = false;
        }
        Assert.assertNotNull((Object)error2);
        Assert.assertTrue((boolean)error2.toString().contains("foo"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandshake() throws IOException {
        Protocol protocol = new Protocol("Simple", "org.apache.avro.test");
        ArrayList<Schema.Field> fields2 = new ArrayList<Schema.Field>();
        fields2.add(new Schema.Field("extra", Schema.create(Schema.Type.BOOLEAN), null, null));
        fields2.add(new Schema.Field("greeting", Schema.create(Schema.Type.STRING), null, null));
        Protocol.Message message = protocol.createMessage("hello", null, Schema.createRecord(fields2), Schema.create(Schema.Type.STRING), Schema.createUnion(new ArrayList<Schema>()));
        protocol.getMessages().put("hello", message);
        SocketTransceiver t = new SocketTransceiver(new InetSocketAddress(server.getPort()));
        try {
            GenericRequestor r = new GenericRequestor(protocol, t);
            GenericData.Record params2 = new GenericData.Record(message.getRequest());
            params2.put("extra", (Object)Boolean.TRUE);
            params2.put("greeting", (Object)new Utf8("bob"));
            Utf8 response = (Utf8)r.request("hello", params2);
            Assert.assertEquals((Object)new Utf8("goodbye"), (Object)response);
        }
        finally {
            ((Transceiver)t).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResponseChange() throws IOException {
        ArrayList<Schema.Field> fields2 = new ArrayList<Schema.Field>();
        for (Schema.Field f2 : PROTOCOL.getType("TestRecord").getFields()) {
            fields2.add(new Schema.Field(f2.name(), f2.schema(), null, null));
        }
        fields2.add(new Schema.Field("extra", Schema.create(Schema.Type.BOOLEAN), null, BooleanNode.TRUE));
        Schema record2 = Schema.createRecord("TestRecord", null, "org.apache.avro.test", false);
        record2.setFields(fields2);
        Protocol protocol = new Protocol("Simple", "org.apache.avro.test");
        ArrayList<Schema.Field> params2 = new ArrayList<Schema.Field>();
        params2.add(new Schema.Field("record", record2, null, null));
        Protocol.Message message = protocol.createMessage("echo", null, Schema.createRecord(params2), record2, Schema.createUnion(new ArrayList<Schema>()));
        protocol.getMessages().put("echo", message);
        SocketTransceiver t = new SocketTransceiver(new InetSocketAddress(server.getPort()));
        try {
            GenericRequestor r = new GenericRequestor(protocol, t);
            GenericData.Record args2 = new GenericData.Record(message.getRequest());
            GenericData.Record rec = new GenericData.Record(record2);
            rec.put("name", (Object)new Utf8("foo"));
            rec.put("kind", (Object)new GenericData.EnumSymbol(PROTOCOL.getType("Kind"), "BAR"));
            rec.put("hash", (Object)new GenericData.Fixed(PROTOCOL.getType("MD5"), new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
            rec.put("extra", (Object)Boolean.TRUE);
            args2.put("record", (Object)rec);
            GenericRecord response = (GenericRecord)r.request("echo", args2);
            Assert.assertEquals((Object)rec, (Object)response);
        }
        finally {
            ((Transceiver)t).close();
        }
    }

    @AfterClass
    public static void testStopServer() throws IOException {
        client.close();
        server.close();
    }

    static {
        try {
            PROTOCOL = Protocol.parse(FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class TestResponder
    extends GenericResponder {
        public TestResponder() {
            super(PROTOCOL);
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            GenericRecord params2 = (GenericRecord)request;
            if ("hello".equals(message.getName())) {
                LOG.info("hello: " + params2.get("greeting"));
                return new Utf8("goodbye");
            }
            if ("echo".equals(message.getName())) {
                Object record2 = params2.get("record");
                LOG.info("echo: " + record2);
                return record2;
            }
            if ("echoBytes".equals(message.getName())) {
                Object data2 = params2.get("data");
                LOG.info("echoBytes: " + data2);
                return data2;
            }
            if ("error".equals(message.getName())) {
                if (throwUndeclaredError) {
                    throw new RuntimeException("foo");
                }
                GenericData.Record error2 = new GenericData.Record(PROTOCOL.getType("TestError"));
                error2.put("message", (Object)new Utf8("an error"));
                throw new AvroRemoteException(error2);
            }
            throw new AvroRuntimeException("unexpected message: " + message.getName());
        }
    }
}

