/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.util.Utf8;

public class RandomData
implements Iterable<Object> {
    private final Schema root;
    private final long seed;
    private final int count;

    public RandomData(Schema schema, int count2) {
        this(schema, count2, System.currentTimeMillis());
    }

    public RandomData(Schema schema, int count2, long seed) {
        this.root = schema;
        this.seed = seed;
        this.count = count2;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private int n;
            private Random random;
            {
                this.random = new Random(RandomData.this.seed);
            }

            @Override
            public boolean hasNext() {
                return this.n < RandomData.this.count;
            }

            @Override
            public Object next() {
                ++this.n;
                return RandomData.generate(RandomData.this.root, this.random, 0);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Object generate(Schema schema, Random random, int d) {
        switch (schema.getType()) {
            case RECORD: {
                GenericData.Record record2 = new GenericData.Record(schema);
                for (Schema.Field field2 : schema.getFields()) {
                    record2.put(field2.name(), RandomData.generate(field2.schema(), random, d + 1));
                }
                return record2;
            }
            case ENUM: {
                List<String> symbols2 = schema.getEnumSymbols();
                return new GenericData.EnumSymbol(schema, symbols2.get(random.nextInt(symbols2.size())));
            }
            case ARRAY: {
                int length = random.nextInt(5) + 2 - d;
                GenericData.Array array2 = new GenericData.Array(length <= 0 ? 0 : length, schema);
                for (int i = 0; i < length; ++i) {
                    array2.add(RandomData.generate(schema.getElementType(), random, d + 1));
                }
                return array2;
            }
            case MAP: {
                int length = random.nextInt(5) + 2 - d;
                HashMap<Utf8, Object> map2 = new HashMap<Utf8, Object>(length <= 0 ? 0 : length);
                for (int i = 0; i < length; ++i) {
                    map2.put(RandomData.randomUtf8(random, 40), RandomData.generate(schema.getValueType(), random, d + 1));
                }
                return map2;
            }
            case UNION: {
                List<Schema> types2 = schema.getTypes();
                return RandomData.generate(types2.get(random.nextInt(types2.size())), random, d);
            }
            case FIXED: {
                byte[] bytes2 = new byte[schema.getFixedSize()];
                random.nextBytes(bytes2);
                return new GenericData.Fixed(schema, bytes2);
            }
            case STRING: {
                return RandomData.randomUtf8(random, 40);
            }
            case BYTES: {
                return RandomData.randomBytes(random, 40);
            }
            case INT: {
                return random.nextInt();
            }
            case LONG: {
                return random.nextLong();
            }
            case FLOAT: {
                return Float.valueOf(random.nextFloat());
            }
            case DOUBLE: {
                return random.nextDouble();
            }
            case BOOLEAN: {
                return random.nextBoolean();
            }
            case NULL: {
                return null;
            }
        }
        throw new RuntimeException("Unknown type: " + schema);
    }

    private static Utf8 randomUtf8(Random rand, int maxLength) {
        Utf8 utf8 = new Utf8().setLength(rand.nextInt(maxLength));
        for (int i = 0; i < utf8.getLength(); ++i) {
            utf8.getBytes()[i] = (byte)(97 + rand.nextInt(25));
        }
        return utf8;
    }

    private static ByteBuffer randomBytes(Random rand, int maxLength) {
        ByteBuffer bytes2 = ByteBuffer.allocate(rand.nextInt(maxLength));
        bytes2.limit(bytes2.capacity());
        rand.nextBytes(bytes2.array());
        return bytes2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) throws Exception {
        if (args2.length != 3) {
            System.out.println("Usage: RandomData <schemafile> <outputfile> <count>");
            System.exit(-1);
        }
        Schema sch = Schema.parse(new File(args2[0]));
        DataFileWriter<Object> writer = new DataFileWriter(new GenericDatumWriter()).create(sch, new File(args2[1]));
        try {
            for (Object datum : new RandomData(sch, Integer.parseInt(args2[2]))) {
                writer.append(datum);
            }
        }
        finally {
            writer.close();
        }
    }
}

