/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.NoBodyOutputStream;

class NoBodyResponse
implements HttpServletResponse {
    private HttpServletResponse resp;
    private NoBodyOutputStream noBody;
    private PrintWriter writer;
    private boolean didSetContentLength;

    NoBodyResponse(HttpServletResponse r) {
        this.resp = r;
        this.noBody = new NoBodyOutputStream();
    }

    void setContentLength() {
        if (!this.didSetContentLength) {
            this.resp.setContentLength(this.noBody.getContentLength());
        }
    }

    public void setContentLength(int len) {
        this.resp.setContentLength(len);
        this.didSetContentLength = true;
    }

    public void setCharacterEncoding(String charset) {
        this.resp.setCharacterEncoding(charset);
    }

    public void setContentType(String type) {
        this.resp.setContentType(type);
    }

    public String getContentType() {
        return this.resp.getContentType();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.noBody;
    }

    public String getCharacterEncoding() {
        return this.resp.getCharacterEncoding();
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)this.noBody, this.getCharacterEncoding());
            this.writer = new PrintWriter(w);
        }
        return this.writer;
    }

    public void setBufferSize(int size2) throws IllegalStateException {
        this.resp.setBufferSize(size2);
    }

    public int getBufferSize() {
        return this.resp.getBufferSize();
    }

    public void reset() throws IllegalStateException {
        this.resp.reset();
    }

    public void resetBuffer() throws IllegalStateException {
        this.resp.resetBuffer();
    }

    public boolean isCommitted() {
        return this.resp.isCommitted();
    }

    public void flushBuffer() throws IOException {
        this.resp.flushBuffer();
    }

    public void setLocale(Locale loc) {
        this.resp.setLocale(loc);
    }

    public Locale getLocale() {
        return this.resp.getLocale();
    }

    public void addCookie(Cookie cookie) {
        this.resp.addCookie(cookie);
    }

    public boolean containsHeader(String name2) {
        return this.resp.containsHeader(name2);
    }

    public void setStatus(int sc, String sm) {
        this.resp.setStatus(sc, sm);
    }

    public void setStatus(int sc) {
        this.resp.setStatus(sc);
    }

    public void setHeader(String name2, String value2) {
        this.resp.setHeader(name2, value2);
    }

    public void setIntHeader(String name2, int value2) {
        this.resp.setIntHeader(name2, value2);
    }

    public void setDateHeader(String name2, long date) {
        this.resp.setDateHeader(name2, date);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.resp.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.resp.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.resp.sendRedirect(location);
    }

    public String encodeURL(String url) {
        return this.resp.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.resp.encodeRedirectURL(url);
    }

    public void addHeader(String name2, String value2) {
        this.resp.addHeader(name2, value2);
    }

    public void addDateHeader(String name2, long value2) {
        this.resp.addDateHeader(name2, value2);
    }

    public void addIntHeader(String name2, int value2) {
        this.resp.addIntHeader(name2, value2);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }
}

