/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Cookie
implements Cloneable {
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
    private String name;
    private String value;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version = 0;
    private static final String tspecials = ",; ";

    public Cookie(String name2, String value2) {
        if (!this.isToken(name2) || name2.equalsIgnoreCase("Comment") || name2.equalsIgnoreCase("Discard") || name2.equalsIgnoreCase("Domain") || name2.equalsIgnoreCase("Expires") || name2.equalsIgnoreCase("Max-Age") || name2.equalsIgnoreCase("Path") || name2.equalsIgnoreCase("Secure") || name2.equalsIgnoreCase("Version") || name2.startsWith("$")) {
            String errMsg2 = lStrings.getString("err.cookie_name_is_token");
            Object[] errArgs = new Object[]{name2};
            errMsg2 = MessageFormat.format(errMsg2, errArgs);
            throw new IllegalArgumentException(errMsg2);
        }
        this.name = name2;
        this.value = value2;
    }

    public void setComment(String purpose) {
        this.comment = purpose;
    }

    public String getComment() {
        return this.comment;
    }

    public void setDomain(String pattern) {
        this.domain = pattern.toLowerCase();
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(int expiry) {
        this.maxAge = expiry;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String uri) {
        this.path = uri;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    private boolean isToken(String value2) {
        int len = value2.length();
        for (int i = 0; i < len; ++i) {
            char c = value2.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

