/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.reducer_estimation;

import cascading.flow.Flow;
import cascading.flow.FlowStep;
import cascading.flow.FlowStepStrategy;
import com.twitter.algebird.Monoid;
import com.twitter.algebird.Monoid$;
import com.twitter.scalding.Config$;
import com.twitter.scalding.StringUtility$;
import com.twitter.scalding.reducer_estimation.EstimatorConfig$;
import com.twitter.scalding.reducer_estimation.FlowStrategyInfo;
import com.twitter.scalding.reducer_estimation.ReducerEstimator;
import com.twitter.scalding.reducer_estimation.ReducerEstimatorStepStrategy$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class ReducerEstimatorStepStrategy$
implements FlowStepStrategy<JobConf> {
    public static final ReducerEstimatorStepStrategy$ MODULE$;
    private final Logger com$twitter$scalding$reducer_estimation$ReducerEstimatorStepStrategy$$LOG;
    private final Monoid<ReducerEstimator> estimatorMonoid;

    static {
        new ReducerEstimatorStepStrategy$();
    }

    public Logger com$twitter$scalding$reducer_estimation$ReducerEstimatorStepStrategy$$LOG() {
        return this.com$twitter$scalding$reducer_estimation$ReducerEstimatorStepStrategy$$LOG;
    }

    public Monoid<ReducerEstimator> estimatorMonoid() {
        return this.estimatorMonoid;
    }

    @Override
    public final void apply(Flow<JobConf> flow, java.util.List<FlowStep<JobConf>> preds, FlowStep<JobConf> step) {
        JobConf conf = step.getConfig();
        int n = conf.getNumReduceTasks();
        switch (n) {
            default: {
                if (this.skipReducerEstimation(step)) {
                    this.com$twitter$scalding$reducer_estimation$ReducerEstimatorStepStrategy$$LOG().info(new StringOps(Predef$.MODULE$.augmentString(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |Flow step ", " was configured with reducers\n               |set explicitly (", "=true) and the estimator\n               |explicit override turned off (", "=false). Skipping\n               |reducer estimation.\n             "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{step.getName(), Config$.MODULE$.WithReducersSetExplicitly(), Config$.MODULE$.ReducerEstimatorOverride()})))).stripMargin());
                    break;
                }
                this.estimate(flow, preds, step);
                break;
            }
            case 0: {
                this.com$twitter$scalding$reducer_estimation$ReducerEstimatorStepStrategy$$LOG().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is a map-only step. Skipping reducer estimation."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{flow.getName()})));
            }
        }
    }

    public boolean com$twitter$scalding$reducer_estimation$ReducerEstimatorStepStrategy$$reducersSetExplicitly(FlowStep<JobConf> step) {
        return ((Configuration)step.getConfig()).getBoolean(Config$.MODULE$.WithReducersSetExplicitly(), false);
    }

    private boolean overrideExplicitReducers(FlowStep<JobConf> step) {
        return ((Configuration)step.getConfig()).getBoolean(Config$.MODULE$.ReducerEstimatorOverride(), false);
    }

    private boolean skipReducerEstimation(FlowStep<JobConf> step) {
        return this.com$twitter$scalding$reducer_estimation$ReducerEstimatorStepStrategy$$reducersSetExplicitly(step) && !this.overrideExplicitReducers(step);
    }

    private void estimate(Flow<JobConf> flow, java.util.List<FlowStep<JobConf>> preds, FlowStep<JobConf> step) {
        JobConf conf = step.getConfig();
        String stepNumReducers = conf.get(Config$.MODULE$.HadoopNumReducers());
        Option$.MODULE$.apply(conf.get(Config$.MODULE$.ReducerEstimators())).foreach(new Serializable(flow, preds, step, conf, stepNumReducers){
            public static final long serialVersionUID = 0L;
            private final Flow flow$1;
            private final java.util.List preds$1;
            private final FlowStep step$1;
            public final JobConf conf$2;
            private final String stepNumReducers$1;

            public final void apply(String clsNames) {
                ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
                List<A> estimators = StringUtility$.MODULE$.fastSplit(clsNames, ",").map(new Serializable(this, clsLoader){
                    public static final long serialVersionUID = 0L;
                    private final ClassLoader clsLoader$1;

                    public final ReducerEstimator apply(String x$2) {
                        return (ReducerEstimator)this.clsLoader$1.loadClass(x$2).newInstance();
                    }
                    {
                        this.clsLoader$1 = clsLoader$1;
                    }
                }, List$.MODULE$.canBuildFrom());
                ReducerEstimator combinedEstimator = Monoid$.MODULE$.sum(estimators, ReducerEstimatorStepStrategy$.MODULE$.estimatorMonoid());
                FlowStrategyInfo info2 = new FlowStrategyInfo(this.flow$1, (Seq<FlowStep<JobConf>>)JavaConverters$.MODULE$.asScalaBufferConverter(this.preds$1).asScala(), this.step$1);
                Option<Object> estimatedNumReducers = combinedEstimator.estimateReducers(info2);
                Option<Object> cappedNumReducers = estimatedNumReducers.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.estimate.1 $outer;

                    public final int apply(int n) {
                        return this.apply$mcII$sp(n);
                    }

                    public int apply$mcII$sp(int n) {
                        int n2;
                        int configuredMax = this.$outer.conf$2.getInt(EstimatorConfig$.MODULE$.maxEstimatedReducersKey(), EstimatorConfig$.MODULE$.defaultMaxEstimatedReducers());
                        if (n > configuredMax) {
                            ReducerEstimatorStepStrategy$.MODULE$.com$twitter$scalding$reducer_estimation$ReducerEstimatorStepStrategy$$LOG().warn(new StringOps(Predef$.MODULE$.augmentString(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |Reducer estimator estimated ", " reducers, which is more than the configured maximum of ", ".\n               |Will use ", " instead.\n             "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(n), BoxesRunTime.boxToInteger(configuredMax), BoxesRunTime.boxToInteger(configuredMax)})))).stripMargin());
                            n2 = configuredMax;
                        } else {
                            n2 = n;
                        }
                        return n2;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.conf$2.setInt(EstimatorConfig$.MODULE$.estimatedNumReducers(), BoxesRunTime.unboxToInt(estimatedNumReducers.getOrElse(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })));
                this.conf$2.setInt(EstimatorConfig$.MODULE$.cappedEstimatedNumReducersKey(), BoxesRunTime.unboxToInt(cappedNumReducers.getOrElse(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })));
                cappedNumReducers.foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.estimate.1 $outer;

                    public final void apply(int x$1) {
                        this.apply$mcVI$sp(x$1);
                    }

                    public void apply$mcVI$sp(int x$1) {
                        this.$outer.conf$2.setNumReduceTasks(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                if (ReducerEstimatorStepStrategy$.MODULE$.com$twitter$scalding$reducer_estimation$ReducerEstimatorStepStrategy$$reducersSetExplicitly(this.step$1)) {
                    this.conf$2.set(EstimatorConfig$.MODULE$.originalNumReducers(), this.stepNumReducers$1);
                }
            }
            {
                this.flow$1 = flow$1;
                this.preds$1 = preds$1;
                this.step$1 = step$1;
                this.conf$2 = conf$2;
                this.stepNumReducers$1 = stepNumReducers$1;
            }
        });
    }

    private ReducerEstimatorStepStrategy$() {
        MODULE$ = this;
        this.com$twitter$scalding$reducer_estimation$ReducerEstimatorStepStrategy$$LOG = LoggerFactory.getLogger(this.getClass());
        this.estimatorMonoid = new anon.1();
    }
}

