/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.reducer_estimation;

import com.twitter.scalding.reducer_estimation.Common$;
import com.twitter.scalding.reducer_estimation.EstimatorConfig$;
import com.twitter.scalding.reducer_estimation.FlowStepHistory;
import com.twitter.scalding.reducer_estimation.FlowStrategyInfo;
import com.twitter.scalding.reducer_estimation.HistoryService;
import com.twitter.scalding.reducer_estimation.InputSizeReducerEstimator$;
import com.twitter.scalding.reducer_estimation.RatioBasedEstimator$;
import com.twitter.scalding.reducer_estimation.ReducerEstimator;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$DoubleIsFractional$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001M<Q!\u0001\u0002\t\u0002-\t1CU1uS>\u0014\u0015m]3e\u000bN$\u0018.\\1u_JT!a\u0001\u0003\u0002%I,G-^2fe~+7\u000f^5nCRLwN\u001c\u0006\u0003\u000b\u0019\t\u0001b]2bY\u0012Lgn\u001a\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u0005M\u0011\u0016\r^5p\u0005\u0006\u001cX\rZ#ti&l\u0017\r^8s'\ti\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006/5!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-AqAG\u0007C\u0002\u0013\u00051$\u0001\fj]B,HOU1uS>$\u0006N]3tQ>dGmS3z+\u0005a\u0002CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\nAA[1wC&\u00111E\b\u0002\u0007'R\u0014\u0018N\\4\t\r\u0015j\u0001\u0015!\u0003\u001d\u0003]Ig\u000e];u%\u0006$\u0018n\u001c+ie\u0016\u001c\bn\u001c7e\u0017\u0016L\b\u0005C\u0003(\u001b\u0011\u0005\u0001&\u0001\fhKRLe\u000e];u%\u0006$\u0018n\u001c+ie\u0016\u001c\bn\u001c7e)\tIC\u0006\u0005\u0002\u0012U%\u00111F\u0005\u0002\u0006\r2|\u0017\r\u001e\u0005\u0006[\u0019\u0002\rAL\u0001\u0005G>tg\r\u0005\u00020q5\t\u0001G\u0003\u00022e\u00051Q.\u00199sK\u0012T!a\r\u001b\u0002\r!\fGm\\8q\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\n\u0005e\u0002$a\u0002&pE\u000e{gN\u001a\u0004\u0006\u001d\t\t\taO\n\u0004uAa\u0004C\u0001\u0007>\u0013\tq$A\u0001\tSK\u0012,8-\u001a:FgRLW.\u0019;pe\")qC\u000fC\u0001\u0001R\t\u0011\t\u0005\u0002\ru!)1I\u000fD\u0001\t\u0006q\u0001.[:u_JL8+\u001a:wS\u000e,W#A#\u0011\u000511\u0015BA$\u0003\u00059A\u0015n\u001d;pef\u001cVM\u001d<jG\u0016Dq!\u0013\u001eC\u0002\u0013%!*A\u0002M\u001f\u001e+\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dZ\nQa\u001d7gi)L!\u0001U'\u0003\r1{wmZ3s\u0011\u0019\u0011&\b)A\u0005\u0017\u0006!AjT$!\u0011\u0015!&\b\"\u0003V\u0003Q\t7mY3qi\u0006\u0014G.Z%oaV$(+\u0019;j_R!a+\u00170a!\t\tr+\u0003\u0002Y%\t9!i\\8mK\u0006t\u0007\"\u0002.T\u0001\u0004Y\u0016aB2veJ,g\u000e\u001e\t\u0003#qK!!\u0018\n\u0003\t1{gn\u001a\u0005\u0006?N\u0003\raW\u0001\u0005a\u0006\u001cH\u000fC\u0003b'\u0002\u0007!-A\u0005uQJ,7\u000f[8mIB\u0011\u0011cY\u0005\u0003IJ\u0011a\u0001R8vE2,\u0007\"\u00024;\t\u0003:\u0017\u0001E3ti&l\u0017\r^3SK\u0012,8-\u001a:t)\tAg\u000eE\u0002\u0012S.L!A\u001b\n\u0003\r=\u0003H/[8o!\t\tB.\u0003\u0002n%\t\u0019\u0011J\u001c;\t\u000b=,\u0007\u0019\u00019\u0002\t%tgm\u001c\t\u0003\u0019EL!A\u001d\u0002\u0003!\u0019cwn^*ue\u0006$XmZ=J]\u001a|\u0007")
public abstract class RatioBasedEstimator
implements ReducerEstimator {
    private final Logger com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$LOG = LoggerFactory.getLogger(this.getClass());

    public static float getInputRatioThreshold(JobConf jobConf) {
        return RatioBasedEstimator$.MODULE$.getInputRatioThreshold(jobConf);
    }

    public static String inputRatioThresholdKey() {
        return RatioBasedEstimator$.MODULE$.inputRatioThresholdKey();
    }

    public abstract HistoryService historyService();

    public Logger com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$LOG() {
        return this.com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$LOG;
    }

    public boolean com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$acceptableInputRatio(long current, long past, double threshold) {
        boolean bl;
        double ratio = (double)current / (double)past;
        if (threshold > 0.0 && (ratio < threshold || ratio > 1.0 / threshold)) {
            this.com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$LOG().warn(new StringBuilder().append((Object)"Input sizes differ too much to use for estimation: current: ").append(BoxesRunTime.boxToLong(current)).append((Object)", past: ").append(BoxesRunTime.boxToLong(past)).toString());
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public Option<Object> estimateReducers(FlowStrategyInfo info2) {
        Try<Seq<FlowStepHistory>> try_;
        block10: {
            None$ none$;
            block8: {
                block9: {
                    Option option2;
                    Success success2;
                    boolean bl;
                    float threshold;
                    block7: {
                        JobConf conf = info2.step().getConfig();
                        int maxHistory = EstimatorConfig$.MODULE$.getMaxHistory(conf);
                        threshold = RatioBasedEstimator$.MODULE$.getInputRatioThreshold(conf);
                        bl = false;
                        success2 = null;
                        try_ = this.historyService().fetchHistory(info2, maxHistory);
                        if (!(try_ instanceof Success)) break block7;
                        bl = true;
                        success2 = (Success)try_;
                        Seq h = (Seq)success2.value();
                        if (!h.isEmpty()) break block7;
                        this.com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$LOG().warn("No matching history found.");
                        none$ = None$.MODULE$;
                        break block8;
                    }
                    if (!bl) break block9;
                    Seq history = (Seq)success2.value();
                    long inputBytes = Common$.MODULE$.totalInputSize(info2.step());
                    if (inputBytes == 0L) {
                        this.com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$LOG().warn("No input detected.");
                        option2 = None$.MODULE$;
                    } else {
                        Seq ratios = history.withFilter(new Serializable(this, threshold, inputBytes){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ RatioBasedEstimator $outer;
                            private final float threshold$1;
                            private final long inputBytes$1;

                            public final boolean apply(FlowStepHistory h) {
                                return this.$outer.com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$acceptableInputRatio(this.inputBytes$1, h.hdfsBytesRead(), this.threshold$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.threshold$1 = threshold$1;
                                this.inputBytes$1 = inputBytes$1;
                            }
                        }).map(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(FlowStepHistory h) {
                                return (double)h.reduceFileBytesRead() / (double)h.hdfsBytesRead();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        if (ratios.isEmpty()) {
                            this.com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$LOG().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No matching history found within input ratio threshold: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToFloat(threshold)})));
                            option2 = None$.MODULE$;
                        } else {
                            double reducerRatio = BoxesRunTime.unboxToDouble(ratios.sum(Numeric$DoubleIsFractional$.MODULE$)) / (double)ratios.length();
                            this.com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$LOG().info("Getting base estimate from InputSizeReducerEstimator");
                            Option<Object> inputSizeBasedEstimate = InputSizeReducerEstimator$.MODULE$.estimateReducersWithoutRounding(info2);
                            option2 = inputSizeBasedEstimate.map(new Serializable(this, reducerRatio){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ RatioBasedEstimator $outer;
                                private final double reducerRatio$1;

                                public final int apply(double baseEstimate) {
                                    return this.apply$mcID$sp(baseEstimate);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public int apply$mcID$sp(double baseEstimate) {
                                    void var3_2;
                                    int e = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(baseEstimate * this.reducerRatio$1))), 1);
                                    this.$outer.com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$LOG().info(new StringBuilder().append((Object)"\nRatioBasedEstimator\n - past reducer ratio: ").append(BoxesRunTime.boxToDouble(this.reducerRatio$1)).append((Object)"\n - reducer estimate:   ").append(BoxesRunTime.boxToInteger(e)).toString());
                                    return (int)var3_2;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.reducerRatio$1 = reducerRatio$1;
                                }
                            });
                        }
                    }
                    none$ = option2;
                    break block8;
                }
                if (!(try_ instanceof Failure)) break block10;
                Failure failure2 = (Failure)try_;
                Throwable e = failure2.exception();
                this.com$twitter$scalding$reducer_estimation$RatioBasedEstimator$$LOG().warn("Unable to fetch history. Disabling RatioBasedEstimator.", e);
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(try_);
    }
}

