/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.reducer_estimation;

import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import com.twitter.scalding.reducer_estimation.Common$;
import com.twitter.scalding.reducer_estimation.FlowStrategyInfo;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$LongIsIntegral$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class InputSizeReducerEstimator$ {
    public static final InputSizeReducerEstimator$ MODULE$;
    private final Logger LOG;
    private final String BytesPerReducer;
    private final long defaultBytesPerReducer;

    static {
        new InputSizeReducerEstimator$();
    }

    public String BytesPerReducer() {
        return this.BytesPerReducer;
    }

    public long defaultBytesPerReducer() {
        return this.defaultBytesPerReducer;
    }

    public long getBytesPerReducer(JobConf conf) {
        return conf.getLongBytes(this.BytesPerReducer(), this.defaultBytesPerReducer());
    }

    public Option<Object> estimateReducersWithoutRounding(FlowStrategyInfo info2) {
        Option option2;
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        Seq<Tuple2<String, Object>> seq = Common$.MODULE$.inputSizes(info2.step());
        Nil$ nil$ = Nil$.MODULE$;
        Seq<Tuple2<String, Object>> seq2 = seq;
        if (!(nil$ != null ? !((Object)nil$).equals(seq2) : seq2 != null)) {
            this.LOG.warn(new StringBuilder().append((Object)"InputSizeReducerEstimator unable to estimate reducers; cannot compute size of:\n - ").append((Object)((TraversableOnce)Common$.MODULE$.unrollTaps(info2.step()).filterNot((Function1<Tap<?, ?, ?>, Object>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tap<?, ?, ?> x$1) {
                    return x$1 instanceof Hfs;
                }
            }))).mkString("\n - ")).toString());
            option2 = None$.MODULE$;
        } else {
            ObjectRef<Object> logStr$lzy = new ObjectRef<Object>(null);
            long bytesPerReducer = this.getBytesPerReducer(info2.step().getConfig());
            long totalBytes = BoxesRunTime.unboxToLong(((TraversableOnce)seq.map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple2<String, Object> x$2) {
                    return x$2._2$mcJ$sp();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum(Numeric$LongIsIntegral$.MODULE$));
            double nReducers = (double)totalBytes / (double)bytesPerReducer;
            this.LOG.info(new StringBuilder().append((Object)"\nInputSizeReducerEstimator\n - input size (bytes): ").append(BoxesRunTime.boxToLong(totalBytes)).append((Object)"\n - reducer estimate:   ").append(BoxesRunTime.boxToDouble(nReducers)).append((Object)"\n - Breakdown:\n").append((Object)this.logStr$1(logStr$lzy, seq, bitmap$0)).toString());
            option2 = new Some<Double>(BoxesRunTime.boxToDouble(nReducers));
        }
        return option2;
    }

    private final String logStr$lzycompute$1(ObjectRef logStr$lzy$1, Seq x1$1, VolatileByteRef bitmap$0$1) {
        InputSizeReducerEstimator$ inputSizeReducerEstimator$ = this;
        synchronized (inputSizeReducerEstimator$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                logStr$lzy$1.elem = ((TraversableOnce)x1$1.map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String name2 = tuple2._1();
                            long bytes2 = tuple2._2$mcJ$sp();
                            String string2 = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"   - ", "\\t", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2, BoxesRunTime.boxToLong(bytes2)}));
                            return string2;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (String)logStr$lzy$1.elem;
        }
    }

    private final String logStr$1(ObjectRef logStr$lzy$1, Seq x1$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.logStr$lzycompute$1(logStr$lzy$1, x1$1, bitmap$0$1) : (String)logStr$lzy$1.elem;
    }

    private InputSizeReducerEstimator$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger(this.getClass());
        this.BytesPerReducer = "scalding.reducer.estimator.bytes.per.reducer";
        this.defaultBytesPerReducer = 0x100000000L;
    }
}

