/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.reducer_estimation;

import com.twitter.scalding.reducer_estimation.Common$;
import com.twitter.scalding.reducer_estimation.FlowStepHistory;
import com.twitter.scalding.reducer_estimation.FlowStrategyInfo;
import com.twitter.scalding.reducer_estimation.InputScaledRuntimeReducerEstimator;
import com.twitter.scalding.reducer_estimation.RuntimeReducerEstimator$;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public abstract class InputScaledRuntimeReducerEstimator$class {
    public static Option estimateReducers(InputScaledRuntimeReducerEstimator $this, FlowStrategyInfo info2, Seq history) {
        Option option2;
        Seq<Seq<Object>> reduceTimes = RuntimeReducerEstimator$.MODULE$.getReduceTimes(history);
        $this.com$twitter$scalding$reducer_estimation$InputScaledRuntimeReducerEstimator$$LOG().info(new StringOps(Predef$.MODULE$.augmentString(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n          |History items have the following numbers of tasks:\n          | ", ",\n          |and the following numbers of tasks have valid task histories:\n          | ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{history.map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(FlowStepHistory x$4) {
                return x$4.tasks().length();
            }
        }, Seq$.MODULE$.canBuildFrom()), reduceTimes.map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$5) {
                return x$5.length();
            }
        }, Seq$.MODULE$.canBuildFrom())})))).stripMargin());
        Seq jobTimes = reduceTimes.map(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputScaledRuntimeReducerEstimator $outer;

            public final Option<Object> apply(Seq<Object> xs) {
                return this.$outer.runtimeEstimationScheme().estimateTaskTime(xs).map(new Serializable(this, xs){
                    public static final long serialVersionUID = 0L;
                    private final Seq xs$2;

                    public final double apply(double x$6) {
                        return this.apply$mcDD$sp(x$6);
                    }

                    public double apply$mcDD$sp(double x$6) {
                        return x$6 * (double)this.xs$2.length();
                    }
                    {
                        this.xs$2 = xs$2;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<Object> timeToByteRatios = ((TraversableLike)jobTimes.zip(history.map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(FlowStepHistory x$7) {
                return x$7.hdfsBytesRead();
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).collect(new Serializable($this){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Option<Object>, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var10_10;
                A1 A1 = x1;
                if (A1 != null) {
                    Option<Object> option2 = A1._1();
                    long bytes2 = A1._2$mcJ$sp();
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        double time = BoxesRunTime.unboxToDouble(some.x());
                        Double d = BoxesRunTime.boxToDouble(time / (double)bytes2);
                        return var10_10;
                    }
                }
                B1 B1 = function1.apply(x1);
                return var10_10;
            }

            public final boolean isDefinedAt(Tuple2<Option<Object>, Object> x1) {
                Option<Object> option2;
                Tuple2<Option<Object>, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (option2 = tuple2._1()) instanceof Some;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Option<Object> typicalTimeToByteRatio = $this.runtimeEstimationScheme().estimateJobTime(timeToByteRatios);
        long desiredRuntime = RuntimeReducerEstimator$.MODULE$.getRuntimePerReducer(info2.step().getConfig());
        long inputBytes = Common$.MODULE$.totalInputSize(info2.step());
        if (inputBytes == 0L) {
            $this.com$twitter$scalding$reducer_estimation$InputScaledRuntimeReducerEstimator$$LOG().warn("Input bytes is zero in current step.");
            option2 = None$.MODULE$;
        } else {
            Option<Object> estimate2 = typicalTimeToByteRatio.map(new Serializable($this, desiredRuntime, inputBytes){
                public static final long serialVersionUID = 0L;
                private final long desiredRuntime$2;
                private final long inputBytes$1;

                public final int apply(double t) {
                    return this.apply$mcID$sp(t);
                }

                public int apply$mcID$sp(double t) {
                    return (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(t * (double)this.inputBytes$1 / (double)this.desiredRuntime$2));
                }
                {
                    this.desiredRuntime$2 = desiredRuntime$2;
                    this.inputBytes$1 = inputBytes$1;
                }
            });
            $this.com$twitter$scalding$reducer_estimation$InputScaledRuntimeReducerEstimator$$LOG().info(new StringOps(Predef$.MODULE$.augmentString(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        | - HDFS bytes read: ", "\n        | - Time-to-byte-ratios: ", "\n        | - Typical type-to-byte-ratio: ", "\n        | - Desired runtime: ", "\n        | - Input bytes: ", "\n        | - Estimate: ", "\n        "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{history.map(new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final long apply(FlowStepHistory x$8) {
                    return x$8.hdfsBytesRead();
                }
            }, Seq$.MODULE$.canBuildFrom()), timeToByteRatios, typicalTimeToByteRatio, BoxesRunTime.boxToLong(desiredRuntime), BoxesRunTime.boxToLong(inputBytes), estimate2})))).stripMargin());
            option2 = estimate2;
        }
        return option2;
    }

    public static void $init$(InputScaledRuntimeReducerEstimator $this) {
        $this.com$twitter$scalding$reducer_estimation$InputScaledRuntimeReducerEstimator$_setter_$com$twitter$scalding$reducer_estimation$InputScaledRuntimeReducerEstimator$$LOG_$eq(LoggerFactory.getLogger($this.getClass()));
    }
}

