/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.parquet.tuple;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import com.twitter.scalding.parquet.tuple.SchemaIntersection;
import com.twitter.scalding.parquet.tuple.TupleRecordMaterializer;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;

public class TupleReadSupport
extends ReadSupport<Tuple> {
    static final String PARQUET_CASCADING_REQUESTED_FIELDS = "parquet.cascading.requested.fields";

    protected static Fields getRequestedFields(Configuration configuration) {
        String string2 = configuration.get(PARQUET_CASCADING_REQUESTED_FIELDS);
        if (string2 == null) {
            return Fields.ALL;
        }
        String[] stringArray = StringUtils.split(string2, ":");
        if (stringArray.length == 0) {
            return Fields.ALL;
        }
        return new Fields((Comparable[])stringArray);
    }

    protected static void setRequestedFields(JobConf jobConf, Fields fields2) {
        String string2 = StringUtils.join(fields2.iterator(), ":");
        jobConf.set(PARQUET_CASCADING_REQUESTED_FIELDS, string2);
    }

    @Override
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> map2, MessageType messageType) {
        Fields fields2 = TupleReadSupport.getRequestedFields(configuration);
        if (fields2 == null) {
            return new ReadSupport.ReadContext(messageType);
        }
        SchemaIntersection schemaIntersection = new SchemaIntersection(messageType, fields2);
        return new ReadSupport.ReadContext(schemaIntersection.getRequestedSchema());
    }

    @Override
    public RecordMaterializer<Tuple> prepareForRead(Configuration configuration, Map<String, String> map2, MessageType messageType, ReadSupport.ReadContext readContext) {
        MessageType messageType2 = readContext.getRequestedSchema();
        return new TupleRecordMaterializer(messageType2);
    }
}

