/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.parquet.tuple;

import cascading.tuple.Tuple;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

public class ParquetTupleConverter
extends GroupConverter {
    protected Tuple currentTuple;
    private final Converter[] converters;

    public ParquetTupleConverter(GroupType groupType) {
        int n = groupType.getFieldCount();
        this.converters = new Converter[n];
        for (int i = 0; i < n; ++i) {
            Type type = groupType.getType(i);
            this.converters[i] = this.newConverter(type, i);
        }
    }

    private Converter newConverter(Type type, int n) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("cascading can only build tuples from primitive types");
        }
        return new TuplePrimitiveConverter(this, n);
    }

    @Override
    public Converter getConverter(int n) {
        return this.converters[n];
    }

    @Override
    public final void start() {
        this.currentTuple = Tuple.size(this.converters.length);
    }

    @Override
    public void end() {
    }

    public final Tuple getCurrentTuple() {
        return this.currentTuple;
    }

    static final class TuplePrimitiveConverter
    extends PrimitiveConverter {
        private final ParquetTupleConverter parent;
        private final int index;

        public TuplePrimitiveConverter(ParquetTupleConverter parquetTupleConverter, int n) {
            this.parent = parquetTupleConverter;
            this.index = n;
        }

        @Override
        public void addBinary(Binary binary) {
            this.parent.getCurrentTuple().setString(this.index, binary.toStringUsingUTF8());
        }

        @Override
        public void addBoolean(boolean bl) {
            this.parent.getCurrentTuple().setBoolean(this.index, bl);
        }

        @Override
        public void addDouble(double d) {
            this.parent.getCurrentTuple().setDouble(this.index, d);
        }

        @Override
        public void addFloat(float f2) {
            this.parent.getCurrentTuple().setFloat(this.index, f2);
        }

        @Override
        public void addInt(int n) {
            this.parent.getCurrentTuple().setInteger(this.index, n);
        }

        @Override
        public void addLong(long l) {
            this.parent.getCurrentTuple().setLong(this.index, l);
        }
    }
}

