/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.parquet.thrift;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import com.twitter.scalding.parquet.ParquetValueScheme;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.mapred.DeprecatedParquetInputFormat;
import org.apache.parquet.hadoop.mapred.DeprecatedParquetOutputFormat;
import org.apache.parquet.hadoop.thrift.TBaseWriteSupport;
import org.apache.parquet.hadoop.thrift.ThriftReadSupport;
import org.apache.parquet.thrift.TBaseRecordConverter;
import org.apache.thrift.TBase;

public class ParquetTBaseScheme<T extends TBase<?, ?>>
extends ParquetValueScheme<T> {
    public ParquetTBaseScheme() {
        this(new ParquetValueScheme.Config());
    }

    public ParquetTBaseScheme(Class<T> clazz2) {
        this(new ParquetValueScheme.Config<T>().withRecordClass(clazz2));
    }

    public ParquetTBaseScheme(FilterPredicate filterPredicate) {
        this(new ParquetValueScheme.Config().withFilterPredicate(filterPredicate));
    }

    public ParquetTBaseScheme(FilterPredicate filterPredicate, Class<T> clazz2) {
        this(new ParquetValueScheme.Config<T>().withRecordClass(clazz2).withFilterPredicate(filterPredicate));
    }

    public ParquetTBaseScheme(ParquetValueScheme.Config<T> config2) {
        super(config2);
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        super.sourceConfInit(flowProcess, tap, jobConf);
        jobConf.setInputFormat(DeprecatedParquetInputFormat.class);
        ParquetInputFormat.setReadSupportClass(jobConf, ThriftReadSupport.class);
        ThriftReadSupport.setRecordConverterClass(jobConf, TBaseRecordConverter.class);
    }

    @Override
    public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        if (this.config.getKlass() == null) {
            throw new IllegalArgumentException("To use ParquetTBaseScheme as a sink, you must specify a thrift class in the constructor");
        }
        DeprecatedParquetOutputFormat.setAsOutputFormat(jobConf);
        DeprecatedParquetOutputFormat.setWriteSupportClass((Configuration)jobConf, TBaseWriteSupport.class);
        TBaseWriteSupport.setThriftClass((Configuration)jobConf, this.config.getKlass());
    }
}

