/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.parquet;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.parquet.Preconditions;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.mapred.Container;
import org.apache.parquet.hadoop.thrift.ParquetThriftInputFormat;
import org.apache.parquet.hadoop.thrift.ThriftReadSupport;

public abstract class ParquetValueScheme<T>
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Object[]> {
    private static final long serialVersionUID = 157560846420730043L;
    protected final Config<T> config;

    public ParquetValueScheme() {
        this(new Config());
    }

    public ParquetValueScheme(FilterPredicate filterPredicate) {
        this(new Config().withFilterPredicate(filterPredicate));
    }

    public ParquetValueScheme(Config<T> config2) {
        this.config = config2;
    }

    @Deprecated
    private void setProjectionPushdown(JobConf jobConf) {
        if (((Config)this.config).deprecatedProjectionString != null) {
            ThriftReadSupport.setProjectionPushdown(jobConf, ((Config)this.config).deprecatedProjectionString);
        }
    }

    private void setStrictProjectionPushdown(JobConf jobConf) {
        if (((Config)this.config).strictProjectionString != null) {
            ThriftReadSupport.setStrictFieldProjectionFilter((Configuration)jobConf, ((Config)this.config).strictProjectionString);
        }
    }

    private void setPredicatePushdown(JobConf jobConf) {
        if (((Config)this.config).filterPredicate != null) {
            ParquetInputFormat.setFilterPredicate((Configuration)jobConf, ((Config)this.config).filterPredicate);
        }
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        this.setPredicatePushdown(jobConf);
        this.setProjectionPushdown(jobConf);
        this.setStrictProjectionPushdown(jobConf);
        this.setRecordClass(jobConf);
    }

    private void setRecordClass(JobConf jobConf) {
        if (((Config)this.config).klass != null) {
            ParquetThriftInputFormat.setThriftClass(jobConf, ((Config)this.config).klass);
        }
    }

    @Override
    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Container container2 = (Container)sourceCall.getInput().createValue();
        boolean bl = sourceCall.getInput().next(null, (Object)container2);
        if (!bl) {
            return false;
        }
        if (container2 == null) {
            return true;
        }
        sourceCall.getIncomingEntry().setTuple(new Tuple(container2.get()));
        return true;
    }

    @Override
    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        if (tupleEntry.size() != 1) {
            throw new RuntimeException("ParquetValueScheme expects tuples with an arity of exactly 1, but found " + tupleEntry.getFields());
        }
        Object object = tupleEntry.getObject(0);
        OutputCollector outputCollector = sinkCall.getOutput();
        outputCollector.collect(null, object);
    }

    public static final class Config<T>
    implements Serializable {
        private final FilterPredicate filterPredicate;
        private final String deprecatedProjectionString;
        private final String strictProjectionString;
        private final Class<T> klass;

        private Config(Class<T> clazz2, FilterPredicate filterPredicate, String string2, String string3) {
            this.filterPredicate = filterPredicate;
            this.deprecatedProjectionString = string2;
            this.strictProjectionString = string3;
            this.klass = clazz2;
        }

        public Config() {
            this.filterPredicate = null;
            this.deprecatedProjectionString = null;
            this.strictProjectionString = null;
            this.klass = null;
        }

        public FilterPredicate getFilterPredicate() {
            return this.filterPredicate;
        }

        @Deprecated
        public String getProjectionString() {
            return this.deprecatedProjectionString;
        }

        public String getStrictProjectionString() {
            return this.strictProjectionString;
        }

        public Class<T> getKlass() {
            return this.klass;
        }

        public Config<T> withFilterPredicate(FilterPredicate filterPredicate) {
            return new Config<T>(this.klass, Preconditions.checkNotNull(filterPredicate, "filterPredicate"), this.deprecatedProjectionString, this.strictProjectionString);
        }

        @Deprecated
        public Config<T> withProjectionString(String string2) {
            return new Config<T>(this.klass, this.filterPredicate, Preconditions.checkNotNull(string2, "projectionString"), this.strictProjectionString);
        }

        public Config<T> withStrictProjectionString(String string2) {
            return new Config<T>(this.klass, this.filterPredicate, this.deprecatedProjectionString, Preconditions.checkNotNull(string2, "projectionString"));
        }

        public Config<T> withRecordClass(Class<T> clazz2) {
            return new Config<T>(Preconditions.checkNotNull(clazz2, "recordClass"), this.filterPredicate, this.deprecatedProjectionString, this.strictProjectionString);
        }
    }
}

