/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.mathematics;

import cascading.flow.FlowDef;
import com.twitter.algebird.Field;
import com.twitter.algebird.Group;
import com.twitter.algebird.Monoid;
import com.twitter.algebird.Ring;
import com.twitter.algebird.Ring$;
import com.twitter.scalding.Mode;
import com.twitter.scalding.mathematics.HadamardProduct;
import com.twitter.scalding.mathematics.Matrix2;
import com.twitter.scalding.mathematics.Matrix2$;
import com.twitter.scalding.mathematics.MatrixJoiner2;
import com.twitter.scalding.mathematics.MatrixLiteral;
import com.twitter.scalding.mathematics.NoClue$;
import com.twitter.scalding.mathematics.OneC;
import com.twitter.scalding.mathematics.Product;
import com.twitter.scalding.mathematics.Product$;
import com.twitter.scalding.mathematics.Scalar2;
import com.twitter.scalding.mathematics.Scalar2$;
import com.twitter.scalding.mathematics.SizeHint$;
import com.twitter.scalding.mathematics.Sum;
import com.twitter.scalding.typed.KeyedListLike$;
import com.twitter.scalding.typed.TypedPipe;
import com.twitter.scalding.typed.TypedSink;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Predef$$eq$colon$eq$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.Ordering$Unit$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble;
import scala.runtime.VolatileByteRef;

public abstract class Matrix2$class {
    public static Matrix2 $plus(Matrix2 $this, Matrix2 that, Monoid mon) {
        return new Sum($this, that, mon);
    }

    public static Matrix2 $minus(Matrix2 $this, Matrix2 that, Group g) {
        return new Sum($this, that.negate(g), g);
    }

    public static Matrix2 unary_$minus(Matrix2 $this, Group g) {
        return $this.negate(g);
    }

    public static Matrix2 $hash$times$hash(Matrix2 $this, Matrix2 that, Ring ring) {
        return new HadamardProduct($this, that, ring);
    }

    public static Matrix2 $times(Matrix2 $this, Matrix2 that, Ring ring, MatrixJoiner2 mj) {
        return new Product($this, that, ring, Product$.MODULE$.apply$default$4(), mj);
    }

    public static Matrix2 $times(Matrix2 $this, Scalar2 that, Ring ring, MatrixJoiner2 mj) {
        return that.$times($this, ring, mj);
    }

    public static Matrix2 $div(Matrix2 $this, Scalar2 that, Field field2) {
        return that.divMatrix($this, field2);
    }

    public static Matrix2 optimizedSelf(Matrix2 $this) {
        return Matrix2$.MODULE$.optimize($this)._2();
    }

    public static Matrix2 $up(Matrix2 $this, int power, Predef$.eq.colon.eq ev, Ring ring, MatrixJoiner2 mj) {
        Predef$.MODULE$.assert(power > 0, (Function0<Object>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "exponent must be >= 1";
            }
        }));
        Matrix2 literal = $this;
        return power == 1 ? literal : literal.$times(literal.$up(power - 1, Predef$$eq$colon$eq$.MODULE$.tpEquals(), ring, mj), ring, mj);
    }

    public static Matrix2 sumColVectors(Matrix2 $this, Ring ring, MatrixJoiner2 mj) {
        return new Product($this, new OneC($this.colOrd()), ring, Product$.MODULE$.apply$default$4(), mj);
    }

    public static Matrix2 propagate(Matrix2 $this, Matrix2 vec, Predef$.eq.colon.eq ev, Monoid mon, MatrixJoiner2 mj) {
        ObjectRef<Object> joinedBool$lzy = new ObjectRef<Object>(null);
        ObjectRef<Object> resultPipe$lzy = new ObjectRef<Object>(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        Ordering ord2 = vec.colOrd();
        return new MatrixLiteral(Matrix2$class.resultPipe$1($this, joinedBool$lzy, ord2, resultPipe$lzy, vec, mon, mj, bitmap$0), $this.sizeHint(), $this.rowOrd(), ord2);
    }

    public static Matrix2 propagateRow(Matrix2 $this, Matrix2 mat, Predef$.eq.colon.eq ev, Monoid mon, MatrixJoiner2 mj) {
        return mat.transpose().propagate($this.transpose(), Predef$$eq$colon$eq$.MODULE$.tpEquals(), mon, mj).transpose();
    }

    public static Matrix2 binarizeAs(Matrix2 $this, Monoid mon, Ring ring) {
        ObjectRef<Object> newPipe$lzy = new ObjectRef<Object>(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        return new MatrixLiteral(Matrix2$class.newPipe$1($this, newPipe$lzy, mon, ring, bitmap$0), $this.sizeHint(), $this.rowOrd(), $this.colOrd());
    }

    public static Matrix2 rowL2Normalize(Matrix2 $this, Numeric num, MatrixJoiner2 mj) {
        ObjectRef<Object> result$lzy = new ObjectRef<Object>(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        MatrixLiteral matD = new MatrixLiteral($this.toTypedPipe().map(new Serializable($this, num){
            public static final long serialVersionUID = 0L;
            private final Numeric num$1;

            public final Tuple3<R, C, Object> apply(Tuple3<R, C, V> x0$6) {
                Tuple3<R, C, V> tuple3 = x0$6;
                if (tuple3 != null) {
                    R r = tuple3._1();
                    C c = tuple3._2();
                    V x = tuple3._3();
                    Tuple3<R, C, Double> tuple32 = new Tuple3<R, C, Double>(r, c, BoxesRunTime.boxToDouble(this.num$1.toDouble(x)));
                    return tuple32;
                }
                throw new MatchError(tuple3);
            }
            {
                this.num$1 = num$1;
            }
        }), $this.sizeHint(), $this.rowOrd(), $this.colOrd());
        return new MatrixLiteral(Matrix2$class.result$1($this, result$lzy, num, mj, bitmap$0), SizeHint$.MODULE$.asDiagonal($this.sizeHint().setRowsToCols()), $this.rowOrd(), $this.rowOrd()).$times(matD, Ring$.MODULE$.doubleRing(), mj);
    }

    public static Matrix2 rowL1Normalize(Matrix2 $this, Numeric num, MatrixJoiner2 mj) {
        ObjectRef<Object> result$lzy = new ObjectRef<Object>(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        MatrixLiteral matD = new MatrixLiteral($this.toTypedPipe().map(new Serializable($this, num){
            public static final long serialVersionUID = 0L;
            private final Numeric num$2;

            public final Tuple3<R, C, Object> apply(Tuple3<R, C, V> x0$7) {
                Tuple3<R, C, V> tuple3 = x0$7;
                if (tuple3 != null) {
                    R r = tuple3._1();
                    C c = tuple3._2();
                    V x = tuple3._3();
                    Tuple3<R, C, Object> tuple32 = new Tuple3<R, C, Object>(r, c, new RichDouble(Predef$.MODULE$.doubleWrapper(this.num$2.toDouble(x))).abs());
                    return tuple32;
                }
                throw new MatchError(tuple3);
            }
            {
                this.num$2 = num$2;
            }
        }), $this.sizeHint(), $this.rowOrd(), $this.colOrd());
        return new MatrixLiteral(Matrix2$class.result$2($this, matD, result$lzy, mj, bitmap$0), SizeHint$.MODULE$.asDiagonal($this.sizeHint().setRowsToCols()), $this.rowOrd(), $this.rowOrd()).$times(matD, Ring$.MODULE$.doubleRing(), mj);
    }

    public static Matrix2 getRow(Matrix2 $this, Object index2) {
        return new MatrixLiteral($this.toTypedPipe().filter(new Serializable($this, index2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Matrix2 $outer;
            private final Object index$1;

            public final boolean apply(Tuple3<R, C, V> x0$9) {
                Tuple3<R, C, V> tuple3 = x0$9;
                if (tuple3 != null) {
                    R r = tuple3._1();
                    boolean bl = package$.MODULE$.Ordering().apply(this.$outer.rowOrd()).equiv(r, this.index$1);
                    return bl;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.index$1 = index$1;
            }
        }).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<BoxedUnit, C, V> apply(Tuple3<R, C, V> x0$10) {
                Tuple3<R, C, V> tuple3 = x0$10;
                if (tuple3 != null) {
                    C c = tuple3._2();
                    V v = tuple3._3();
                    Tuple3<BoxedUnit, C, V> tuple32 = new Tuple3<BoxedUnit, C, V>(BoxedUnit.UNIT, c, v);
                    return tuple32;
                }
                throw new MatchError(tuple3);
            }
        }), $this.sizeHint().setRows(1L), Ordering$Unit$.MODULE$, $this.colOrd());
    }

    public static Matrix2 getColumn(Matrix2 $this, Object index2) {
        return new MatrixLiteral($this.toTypedPipe().filter(new Serializable($this, index2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Matrix2 $outer;
            private final Object index$2;

            public final boolean apply(Tuple3<R, C, V> x0$11) {
                Tuple3<R, C, V> tuple3 = x0$11;
                if (tuple3 != null) {
                    C c = tuple3._2();
                    boolean bl = package$.MODULE$.Ordering().apply(this.$outer.colOrd()).equiv(c, this.index$2);
                    return bl;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.index$2 = index$2;
            }
        }).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<R, BoxedUnit, V> apply(Tuple3<R, C, V> x0$12) {
                Tuple3<R, C, V> tuple3 = x0$12;
                if (tuple3 != null) {
                    R r = tuple3._1();
                    V v = tuple3._3();
                    Tuple3<R, BoxedUnit, V> tuple32 = new Tuple3<R, BoxedUnit, V>(r, BoxedUnit.UNIT, v);
                    return tuple32;
                }
                throw new MatchError(tuple3);
            }
        }), $this.sizeHint().setCols(1L), $this.rowOrd(), Ordering$Unit$.MODULE$);
    }

    public static Matrix2 asRow(Matrix2 $this, Object r2, Predef$.eq.colon.eq ev, Ordering rowOrd) {
        return new MatrixLiteral($this.toTypedPipe().map(new Serializable($this, r2){
            public static final long serialVersionUID = 0L;
            private final Object r2$1;

            public final Tuple3<R2, C, V> apply(Tuple3<R, C, V> x0$13) {
                Tuple3<R, C, V> tuple3 = x0$13;
                if (tuple3 != null) {
                    C c = tuple3._2();
                    V v = tuple3._3();
                    Tuple3<Object, C, V> tuple32 = new Tuple3<Object, C, V>(this.r2$1, c, v);
                    return tuple32;
                }
                throw new MatchError(tuple3);
            }
            {
                this.r2$1 = r2$1;
            }
        }), $this.sizeHint(), rowOrd, $this.colOrd());
    }

    public static Matrix2 asCol(Matrix2 $this, Object c2, Predef$.eq.colon.eq ev, Ordering colOrd) {
        return new MatrixLiteral($this.toTypedPipe().map(new Serializable($this, c2){
            public static final long serialVersionUID = 0L;
            private final Object c2$1;

            public final Tuple3<R, C2, V> apply(Tuple3<R, C, V> x0$14) {
                Tuple3<R, C, V> tuple3 = x0$14;
                if (tuple3 != null) {
                    R r = tuple3._1();
                    V v = tuple3._3();
                    Tuple3<R, Object, V> tuple32 = new Tuple3<R, Object, V>(r, this.c2$1, v);
                    return tuple32;
                }
                throw new MatchError(tuple3);
            }
            {
                this.c2$1 = c2$1;
            }
        }), $this.sizeHint(), $this.rowOrd(), colOrd);
    }

    public static Scalar2 trace(Matrix2 $this, Monoid mon, Predef$.eq.colon.eq ev) {
        return Scalar2$.MODULE$.apply($this.toTypedPipe().filter(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Matrix2 $outer;

            public final boolean apply(Tuple3<R, R, V> x0$15) {
                Tuple3<R, R, V> tuple3 = x0$15;
                if (tuple3 != null) {
                    R r1 = tuple3._1();
                    R r2 = tuple3._2();
                    boolean bl = package$.MODULE$.Ordering().apply(this.$outer.rowOrd()).equiv(r1, r2);
                    return bl;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final V apply(Tuple3<R, R, V> x0$16) {
                Tuple3<R, R, V> tuple3 = x0$16;
                if (tuple3 != null) {
                    V x;
                    V v = x = tuple3._3();
                    return v;
                }
                throw new MatchError(tuple3);
            }
        }).sum(mon));
    }

    public static Matrix2 write(Matrix2 $this, TypedSink sink2, FlowDef fd, Mode m) {
        return new MatrixLiteral($this.toTypedPipe().write(sink2, fd, m), $this.sizeHint(), $this.rowOrd(), $this.colOrd());
    }

    private static final TypedPipe joinedBool$lzycompute$1(Matrix2 $this, ObjectRef joinedBool$lzy$1, Matrix2 vec$1, MatrixJoiner2 mj$1, VolatileByteRef bitmap$0$1) {
        Matrix2 matrix2 = $this;
        synchronized (matrix2) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                joinedBool$lzy$1.elem = mj$1.join($this, vec$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (TypedPipe)joinedBool$lzy$1.elem;
        }
    }

    private static final TypedPipe joinedBool$1(Matrix2 $this, ObjectRef joinedBool$lzy$1, Matrix2 vec$1, MatrixJoiner2 mj$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? Matrix2$class.joinedBool$lzycompute$1($this, joinedBool$lzy$1, vec$1, mj$1, bitmap$0$1) : (TypedPipe)joinedBool$lzy$1.elem;
    }

    private static final TypedPipe resultPipe$lzycompute$1(Matrix2 $this, ObjectRef joinedBool$lzy$1, Ordering ord2$1, ObjectRef resultPipe$lzy$1, Matrix2 vec$1, Monoid mon$1, MatrixJoiner2 mj$1, VolatileByteRef bitmap$0$1) {
        Matrix2 matrix2 = $this;
        synchronized (matrix2) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                resultPipe$lzy$1.elem = KeyedListLike$.MODULE$.toTypedPipe(Matrix2$class.joinedBool$1($this, joinedBool$lzy$1, vec$1, mj$1, bitmap$0$1).flatMap(new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Tuple2<Tuple2<R, C2>, VecV>> apply(Tuple2<C, Tuple2<Tuple2<R, Object>, Tuple2<C2, VecV>>> x0$1) {
                        Tuple2<Tuple2<R, Object>, Tuple2<C2, VecV>> tuple2;
                        Tuple2<C, Tuple2<Tuple2<R, Object>, Tuple2<C2, VecV>>> tuple22 = x0$1;
                        if (tuple22 != null && (tuple2 = tuple22._2()) != null) {
                            Tuple2<R, Object> tuple23 = tuple2._1();
                            Tuple2<C2, VecV> tuple24 = tuple2._2();
                            if (tuple23 != null) {
                                R row = tuple23._1();
                                boolean bool2 = tuple23._2$mcZ$sp();
                                if (tuple24 != null) {
                                    C2 col2 = tuple24._1();
                                    VecV v = tuple24._2();
                                    Iterable<Nothing$> iterable = bool2 ? Option$.MODULE$.option2Iterable(new Some<Tuple2<Tuple2<R, C2>, VecV>>(new Tuple2<Tuple2<R, C2>, VecV>(new Tuple2<R, C2>(row, col2), v))) : Option$.MODULE$.option2Iterable(None$.MODULE$);
                                    return iterable;
                                }
                            }
                        }
                        throw new MatchError(tuple22);
                    }
                }).group(Predef$.MODULE$.conforms(), Ordering$.MODULE$.Tuple2($this.rowOrd(), ord2$1)).sum(mon$1).filter(new Serializable($this, mon$1){
                    public static final long serialVersionUID = 0L;
                    private final Monoid mon$1;

                    public final boolean apply(Tuple2<Tuple2<R, C2>, VecV> kv) {
                        return this.mon$1.isNonZero(kv._2());
                    }
                    {
                        this.mon$1 = mon$1;
                    }
                })).map(new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<R, C2, VecV> apply(Tuple2<Tuple2<R, C2>, VecV> x0$2) {
                        Tuple2<Tuple2<R, C2>, VecV> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Tuple2<R, C2> tuple22 = tuple2._1();
                            VecV v = tuple2._2();
                            if (tuple22 != null) {
                                R r = tuple22._1();
                                C2 c2 = tuple22._2();
                                Tuple3<R, C2, VecV> tuple3 = new Tuple3<R, C2, VecV>(r, c2, v);
                                return tuple3;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                });
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (TypedPipe)resultPipe$lzy$1.elem;
        }
    }

    private static final TypedPipe resultPipe$1(Matrix2 $this, ObjectRef joinedBool$lzy$1, Ordering ord2$1, ObjectRef resultPipe$lzy$1, Matrix2 vec$1, Monoid mon$1, MatrixJoiner2 mj$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? Matrix2$class.resultPipe$lzycompute$1($this, joinedBool$lzy$1, ord2$1, resultPipe$lzy$1, vec$1, mon$1, mj$1, bitmap$0$1) : (TypedPipe)resultPipe$lzy$1.elem;
    }

    private static final TypedPipe newPipe$lzycompute$1(Matrix2 $this, ObjectRef newPipe$lzy$1, Monoid mon$2, Ring ring$1, VolatileByteRef bitmap$0$2) {
        Matrix2 matrix2 = $this;
        synchronized (matrix2) {
            if ((byte)(bitmap$0$2.elem & 1) == 0) {
                newPipe$lzy$1.elem = $this.toTypedPipe().map(new Serializable($this, mon$2, ring$1){
                    public static final long serialVersionUID = 0L;
                    private final Monoid mon$2;
                    private final Ring ring$1;

                    public final Tuple3<R, C, NewValT> apply(Tuple3<R, C, V> x0$3) {
                        Tuple3<R, C, V> tuple3 = x0$3;
                        if (tuple3 != null) {
                            R r = tuple3._1();
                            C c = tuple3._2();
                            V x = tuple3._3();
                            Tuple3<R, C, T> tuple32 = new Tuple3<R, C, T>(r, c, this.mon$2.isNonZero(x) ? this.ring$1.one() : this.ring$1.zero());
                            return tuple32;
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        void var3_3;
                        this.mon$2 = mon$2;
                        this.ring$1 = var3_3;
                    }
                }).filter(new Serializable($this, ring$1){
                    public static final long serialVersionUID = 0L;
                    private final Ring ring$1;

                    public final boolean apply(Tuple3<R, C, NewValT> kv) {
                        return this.ring$1.isNonZero(kv._3());
                    }
                    {
                        this.ring$1 = ring$1;
                    }
                });
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 1);
            }
            return (TypedPipe)newPipe$lzy$1.elem;
        }
    }

    private static final TypedPipe newPipe$1(Matrix2 $this, ObjectRef newPipe$lzy$1, Monoid mon$2, Ring ring$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 1) == 0 ? Matrix2$class.newPipe$lzycompute$1($this, newPipe$lzy$1, mon$2, ring$1, bitmap$0$2) : (TypedPipe)newPipe$lzy$1.elem;
    }

    private static final TypedPipe result$lzycompute$1(Matrix2 $this, ObjectRef result$lzy$1, Numeric num$1, MatrixJoiner2 mj$2, VolatileByteRef bitmap$0$3) {
        Matrix2 matrix2 = $this;
        synchronized (matrix2) {
            if ((byte)(bitmap$0$3.elem & 1) == 0) {
                result$lzy$1.elem = new MatrixLiteral($this.toTypedPipe().map(new Serializable($this, num$1){
                    public static final long serialVersionUID = 0L;
                    private final Numeric num$1;

                    public final Tuple3<R, C, Object> apply(Tuple3<R, C, V> x0$4) {
                        Tuple3<R, C, V> tuple3 = x0$4;
                        if (tuple3 != null) {
                            R r = tuple3._1();
                            C c = tuple3._2();
                            V x = tuple3._3();
                            Tuple3<R, C, Double> tuple32 = new Tuple3<R, C, Double>(r, c, BoxesRunTime.boxToDouble(this.num$1.toDouble(x) * this.num$1.toDouble(x)));
                            return tuple32;
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        this.num$1 = num$1;
                    }
                }), $this.sizeHint(), $this.rowOrd(), $this.colOrd()).sumColVectors(Ring$.MODULE$.doubleRing(), mj$2).toTypedPipe().map(new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<R, R, Object> apply(Tuple3<R, BoxedUnit, Object> x0$5) {
                        Tuple3<R, BoxedUnit, Object> tuple3 = x0$5;
                        if (tuple3 != null) {
                            R r = tuple3._1();
                            double x = BoxesRunTime.unboxToDouble(tuple3._3());
                            Tuple3<R, R, Double> tuple32 = new Tuple3<R, R, Double>(r, r, BoxesRunTime.boxToDouble(1.0 / scala.math.package$.MODULE$.sqrt(x)));
                            return tuple32;
                        }
                        throw new MatchError(tuple3);
                    }
                });
                bitmap$0$3.elem = (byte)(bitmap$0$3.elem | 1);
            }
            return (TypedPipe)result$lzy$1.elem;
        }
    }

    private static final TypedPipe result$1(Matrix2 $this, ObjectRef result$lzy$1, Numeric num$1, MatrixJoiner2 mj$2, VolatileByteRef bitmap$0$3) {
        return (byte)(bitmap$0$3.elem & 1) == 0 ? Matrix2$class.result$lzycompute$1($this, result$lzy$1, num$1, mj$2, bitmap$0$3) : (TypedPipe)result$lzy$1.elem;
    }

    private static final TypedPipe result$lzycompute$2(Matrix2 $this, MatrixLiteral matD$1, ObjectRef result$lzy$2, MatrixJoiner2 mj$3, VolatileByteRef bitmap$0$4) {
        Matrix2 matrix2 = $this;
        synchronized (matrix2) {
            if ((byte)(bitmap$0$4.elem & 1) == 0) {
                result$lzy$2.elem = matD$1.sumColVectors(Ring$.MODULE$.doubleRing(), mj$3).toTypedPipe().map(new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<R, R, Object> apply(Tuple3<R, BoxedUnit, Object> x0$8) {
                        Tuple3<R, BoxedUnit, Object> tuple3 = x0$8;
                        if (tuple3 != null) {
                            R r = tuple3._1();
                            double x = BoxesRunTime.unboxToDouble(tuple3._3());
                            Tuple3<R, R, Double> tuple32 = new Tuple3<R, R, Double>(r, r, BoxesRunTime.boxToDouble(1.0 / x));
                            return tuple32;
                        }
                        throw new MatchError(tuple3);
                    }
                });
                bitmap$0$4.elem = (byte)(bitmap$0$4.elem | 1);
            }
            return (TypedPipe)result$lzy$2.elem;
        }
    }

    private static final TypedPipe result$2(Matrix2 $this, MatrixLiteral matD$1, ObjectRef result$lzy$2, MatrixJoiner2 mj$3, VolatileByteRef bitmap$0$4) {
        return (byte)(bitmap$0$4.elem & 1) == 0 ? Matrix2$class.result$lzycompute$2($this, matD$1, result$lzy$2, mj$3, bitmap$0$4) : (TypedPipe)result$lzy$2.elem;
    }

    public static void $init$(Matrix2 $this) {
        $this.com$twitter$scalding$mathematics$Matrix2$_setter_$sizeHint_$eq(NoClue$.MODULE$);
    }
}

