/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.mathematics;

import com.twitter.algebird.Monoid;
import com.twitter.algebird.Ring;
import com.twitter.scalding.mathematics.HadamardProduct;
import com.twitter.scalding.mathematics.Matrix2;
import com.twitter.scalding.mathematics.MatrixJoiner2;
import com.twitter.scalding.mathematics.MatrixLiteral;
import com.twitter.scalding.mathematics.OneC;
import com.twitter.scalding.mathematics.OneR;
import com.twitter.scalding.mathematics.Product;
import com.twitter.scalding.mathematics.Product$;
import com.twitter.scalding.mathematics.SizeHint;
import com.twitter.scalding.mathematics.Sum;
import com.twitter.scalding.package$;
import com.twitter.scalding.typed.TypedPipe;
import com.twitter.scalding.typed.TypedSource;
import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenMap;
import scala.collection.GenTraversable;
import scala.collection.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Matrix2$
implements scala.Serializable {
    public static final Matrix2$ MODULE$;

    static {
        new Matrix2$();
    }

    public <R, C, V> Matrix2<R, C, V> apply(TypedPipe<Tuple3<R, C, V>> t, SizeHint hint, Ordering<R> evidence$1, Ordering<C> evidence$2) {
        return new MatrixLiteral<R, C, V>(t, hint, evidence$1, evidence$2);
    }

    public <R, C, V> Matrix2<R, C, V> read(TypedSource<Tuple3<R, C, V>> t, SizeHint hint, Ordering<R> ordr, Ordering<C> ordc) {
        return new MatrixLiteral<R, C, V>(package$.MODULE$.TypedPipe().from(t), hint, ordr, ordc);
    }

    public <R, C, V> Product<R, BoxedUnit, C, V> J(Ordering<R> ordR, Ordering<C> ordC, Ring<V> ring, MatrixJoiner2 mj) {
        return new Product(new OneC(ordR), new OneR(ordC), ring, Product$.MODULE$.apply$default$4(), mj);
    }

    public <V> Tuple2<BigInt, Matrix2<Object, Object, V>> optimizeProductChain(IndexedSeq<Matrix2<Object, Object, V>> p, Option<Tuple2<Ring<V>, MatrixJoiner2>> product2) {
        GenMap subchainCosts = HashMap$.MODULE$.empty();
        GenMap splitMarkers = HashMap$.MODULE$.empty();
        GenMap sharedMap = HashMap$.MODULE$.empty();
        BigInt best = this.com$twitter$scalding$mathematics$Matrix2$$computeCosts$1(p, 0, p.length() - 1, (HashMap)subchainCosts, (HashMap)splitMarkers);
        return new Tuple2<BigInt, Matrix2<Object, Object, V>>(best, this.generatePlan$1(0, p.length() - 1, p, product2, (HashMap)splitMarkers, (HashMap)sharedMap));
    }

    public <V> Tuple2<BigInt, Matrix2<Object, Object, V>> optimize(Matrix2<Object, Object, V> mf) {
        Tuple4 tuple4 = this.optimizeBasicBlocks$1(mf);
        if (tuple4 != null) {
            Tuple4<List, BigInt, Option, Option> tuple42;
            List lastChain = (List)tuple4._1();
            BigInt lastCost = (BigInt)tuple4._2();
            Option ring = (Option)tuple4._3();
            Option joiner = (Option)tuple4._4();
            Tuple4<List, BigInt, Option, Option> tuple43 = tuple42 = new Tuple4<List, BigInt, Option, Option>(lastChain, lastCost, ring, joiner);
            List lastChain2 = tuple43._1();
            BigInt lastCost2 = tuple43._2();
            Option ring2 = tuple43._3();
            Option joiner2 = tuple43._4();
            Tuple2<BigInt, Matrix2<Object, Object, V>> tuple2 = this.optimizeProductChain(lastChain2.toIndexedSeq(), this.pair$1(ring2, joiner2));
            if (tuple2 != null) {
                Tuple2<BigInt, Matrix2<Object, Object, V>> tuple22;
                BigInt potentialCost = tuple2._1();
                Matrix2<Object, Object, V> finalResult = tuple2._2();
                Tuple2<BigInt, Matrix2<Object, Object, V>> tuple23 = tuple22 = new Tuple2<BigInt, Matrix2<Object, Object, V>>(potentialCost, finalResult);
                BigInt potentialCost2 = tuple23._1();
                Matrix2<Object, Object, V> finalResult2 = tuple23._2();
                return new Tuple2<BigInt, Matrix2<Object, Object, V>>(lastCost2.$plus(potentialCost2), finalResult2);
            }
            throw new MatchError(tuple2);
        }
        throw new MatchError(tuple4);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final BigInt com$twitter$scalding$mathematics$Matrix2$$computeCosts$1(IndexedSeq p, int i, int j, HashMap subchainCosts$1, HashMap splitMarkers$1) {
        Serializable serializable2;
        BoxedUnit boxedUnit = subchainCosts$1.contains(new Tuple2$mcII$sp(i, j)) ? subchainCosts$1.apply(new Tuple2$mcII$sp(i, j)) : BoxedUnit.UNIT;
        if (i == j) {
            serializable2 = subchainCosts$1.put(new Tuple2$mcII$sp(i, j), BigInt$.MODULE$.int2bigInt(0));
        } else {
            subchainCosts$1.put(new Tuple2$mcII$sp(i, j), BigInt$.MODULE$.long2bigInt(Long.MAX_VALUE));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(i), j - 1).foreach(new scala.Serializable(subchainCosts$1, splitMarkers$1, p, i, j){
                public static final long serialVersionUID = 0L;
                private final HashMap subchainCosts$1;
                private final HashMap splitMarkers$1;
                private final IndexedSeq p$2;
                private final int i$1;
                private final int j$1;

                public final Object apply(int k) {
                    Serializable serializable2;
                    BigInt cost = BigInt$.MODULE$.int2bigInt(k - this.i$1).$times(Matrix2$.MODULE$.com$twitter$scalding$mathematics$Matrix2$$computeCosts$1(this.p$2, this.i$1, k, this.subchainCosts$1, this.splitMarkers$1)).$plus(BigInt$.MODULE$.int2bigInt(this.j$1 - k - 1).$times(Matrix2$.MODULE$.com$twitter$scalding$mathematics$Matrix2$$computeCosts$1(this.p$2, k + 1, this.j$1, this.subchainCosts$1, this.splitMarkers$1))).$plus(((Matrix2)this.p$2.apply(this.i$1)).sizeHint().$times(((Matrix2)this.p$2.apply(k)).sizeHint().$times(((Matrix2)this.p$2.apply(this.j$1)).sizeHint())).total().getOrElse(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final BigInt apply() {
                            return scala.package$.MODULE$.BigInt().apply(0L);
                        }
                    }));
                    if (cost.$less((BigInt)this.subchainCosts$1.apply(new Tuple2$mcII$sp(this.i$1, this.j$1)))) {
                        this.subchainCosts$1.put(new Tuple2$mcII$sp(this.i$1, this.j$1), cost);
                        serializable2 = this.splitMarkers$1.put(new Tuple2$mcII$sp(this.i$1, this.j$1), BoxesRunTime.boxToInteger(k));
                    } else {
                        serializable2 = BoxedUnit.UNIT;
                    }
                    return serializable2;
                }
                {
                    this.subchainCosts$1 = subchainCosts$1;
                    this.splitMarkers$1 = splitMarkers$1;
                    this.p$2 = p$2;
                    this.i$1 = i$1;
                    this.j$1 = j$1;
                }
            });
            serializable2 = BoxedUnit.UNIT;
        }
        return (BigInt)subchainCosts$1.apply(new Tuple2$mcII$sp(i, j));
    }

    @SuppressWarnings(value={"org.brianmckenna.wartremover.warts.OptionPartial"})
    private final Matrix2 generatePlan$1(int i, int j, IndexedSeq p$1, Option product$1, HashMap splitMarkers$1, HashMap sharedMap$1) {
        Tuple2 tuple2;
        block4: {
            Matrix2 matrix2;
            block3: {
                Tuple2<Ring, MatrixJoiner2> tuple22;
                block2: {
                    if (i != j) break block2;
                    matrix2 = (Matrix2)p$1.apply(i);
                    break block3;
                }
                int k = BoxesRunTime.unboxToInt(splitMarkers$1.apply(new Tuple2$mcII$sp(i, j)));
                Matrix2 left3 = this.generatePlan$1(i, k, p$1, product$1, splitMarkers$1, sharedMap$1);
                Matrix2 right = this.generatePlan$1(k + 1, j, p$1, product$1, splitMarkers$1, sharedMap$1);
                tuple2 = (Tuple2)product$1.get();
                if (tuple2 == null) break block4;
                Ring ring = (Ring)tuple2._1();
                MatrixJoiner2 joiner = (MatrixJoiner2)tuple2._2();
                Tuple2<Ring, MatrixJoiner2> tuple23 = tuple22 = new Tuple2<Ring, MatrixJoiner2>(ring, joiner);
                Ring ring2 = tuple23._1();
                MatrixJoiner2 joiner2 = tuple23._2();
                matrix2 = new Product(left3, right, ring2, new Some(sharedMap$1), joiner2);
            }
            return matrix2;
        }
        throw new MatchError(tuple2);
    }

    private final Option pair$1(Option x, Option y) {
        return x.flatMap(new scala.Serializable(y){
            public static final long serialVersionUID = 0L;
            private final Option y$1;

            public final Option<Tuple2<X, Y>> apply(X xi) {
                return this.y$1.map(new scala.Serializable(this, xi){
                    public static final long serialVersionUID = 0L;
                    private final Object xi$1;

                    public final Tuple2<X, Y> apply(Y yi) {
                        return new Tuple2<Object, Y>(this.xi$1, yi);
                    }
                    {
                        this.xi$1 = xi$1;
                    }
                });
            }
            {
                this.y$1 = y$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Tuple4 optimizeBasicBlocks$1(Matrix2 mf) {
        void var4_9;
        Matrix2 matrix2 = mf;
        if (matrix2 instanceof MatrixLiteral) {
            MatrixLiteral matrixLiteral = (MatrixLiteral)matrix2;
            Tuple4<GenTraversable, BigInt, None$, None$> tuple4 = new Tuple4<GenTraversable, BigInt, None$, None$>(List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new MatrixLiteral[]{matrixLiteral})), BigInt$.MODULE$.int2bigInt(0), None$.MODULE$, None$.MODULE$);
            return var4_9;
        } else if (matrix2 instanceof Sum) {
            Tuple2 tuple2;
            Tuple2 tuple22;
            Tuple4<List, BigInt, Option, Option> tuple4;
            Tuple4<List, BigInt, Option, Option> tuple42;
            Sum sum2 = (Sum)matrix2;
            Matrix2 left3 = sum2.left();
            Matrix2 right = sum2.right();
            Monoid mon = sum2.mon();
            Tuple4 tuple43 = this.optimizeBasicBlocks$1(left3);
            if (tuple43 == null) throw new MatchError(tuple43);
            List lastLChain = (List)tuple43._1();
            BigInt lastCost1 = (BigInt)tuple43._2();
            Option ringL = (Option)tuple43._3();
            Option joinerL = (Option)tuple43._4();
            Tuple4<List, BigInt, Option, Option> tuple44 = tuple42 = new Tuple4<List, BigInt, Option, Option>(lastLChain, lastCost1, ringL, joinerL);
            List lastLChain2 = tuple44._1();
            BigInt lastCost12 = tuple44._2();
            Option ringL2 = tuple44._3();
            Option joinerL2 = tuple44._4();
            Tuple4 tuple45 = this.optimizeBasicBlocks$1(right);
            if (tuple45 == null) throw new MatchError(tuple45);
            List lastRChain = (List)tuple45._1();
            BigInt lastCost2 = (BigInt)tuple45._2();
            Option ringR = (Option)tuple45._3();
            Option joinerR = (Option)tuple45._4();
            Tuple4<List, BigInt, Option, Option> tuple46 = tuple4 = new Tuple4<List, BigInt, Option, Option>(lastRChain, lastCost2, ringR, joinerR);
            List lastRChain2 = tuple46._1();
            BigInt lastCost22 = tuple46._2();
            Option ringR2 = tuple46._3();
            Option joinerR2 = tuple46._4();
            Tuple2 tuple23 = this.optimizeProductChain(lastLChain2.toIndexedSeq(), this.pair$1(ringL2, joinerL2));
            if (tuple23 == null) throw new MatchError(tuple23);
            BigInt cost1 = tuple23._1();
            Matrix2 newLeft = tuple23._2();
            Tuple2 tuple24 = tuple22 = new Tuple2(cost1, newLeft);
            BigInt cost12 = tuple24._1();
            Matrix2 newLeft2 = tuple24._2();
            Tuple2 tuple25 = this.optimizeProductChain(lastRChain2.toIndexedSeq(), this.pair$1(ringR2, joinerR2));
            if (tuple25 == null) throw new MatchError(tuple25);
            BigInt cost2 = tuple25._1();
            Matrix2 newRight = tuple25._2();
            Tuple2 tuple26 = tuple2 = new Tuple2(cost2, newRight);
            BigInt cost22 = tuple26._1();
            Matrix2 newRight2 = tuple26._2();
            Tuple4 tuple47 = new Tuple4(List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Sum[]{new Sum(newLeft2, newRight2, mon)})), lastCost12.$plus(lastCost22).$plus(cost12).$plus(cost22), ringL2.orElse(new scala.Serializable(ringR2){
                public static final long serialVersionUID = 0L;
                private final Option ringR$1;

                public final Option<Ring<V>> apply() {
                    return this.ringR$1;
                }
                {
                    this.ringR$1 = ringR$1;
                }
            }), joinerL2.orElse(new scala.Serializable(joinerR2){
                public static final long serialVersionUID = 0L;
                private final Option joinerR$1;

                public final Option<MatrixJoiner2> apply() {
                    return this.joinerR$1;
                }
                {
                    this.joinerR$1 = joinerR$1;
                }
            }));
            return var4_9;
        } else if (matrix2 instanceof HadamardProduct) {
            Tuple2 tuple2;
            Tuple2 tuple27;
            Tuple4<List, BigInt, Option, Option> tuple4;
            Tuple4<List, BigInt, Option, Option> tuple48;
            HadamardProduct hadamardProduct = (HadamardProduct)matrix2;
            Matrix2 left4 = hadamardProduct.left();
            Matrix2 right = hadamardProduct.right();
            Ring ring = hadamardProduct.ring();
            Tuple4 tuple49 = this.optimizeBasicBlocks$1(left4);
            if (tuple49 == null) throw new MatchError(tuple49);
            List lastLChain = (List)tuple49._1();
            BigInt lastCost1 = (BigInt)tuple49._2();
            Option ringL = (Option)tuple49._3();
            Option joinerL = (Option)tuple49._4();
            Tuple4<List, BigInt, Option, Option> tuple410 = tuple48 = new Tuple4<List, BigInt, Option, Option>(lastLChain, lastCost1, ringL, joinerL);
            List lastLChain3 = tuple410._1();
            BigInt lastCost13 = tuple410._2();
            Option ringL3 = tuple410._3();
            Option joinerL3 = tuple410._4();
            Tuple4 tuple411 = this.optimizeBasicBlocks$1(right);
            if (tuple411 == null) throw new MatchError(tuple411);
            List lastRChain = (List)tuple411._1();
            BigInt lastCost2 = (BigInt)tuple411._2();
            Option ringR = (Option)tuple411._3();
            Option joinerR = (Option)tuple411._4();
            Tuple4<List, BigInt, Option, Option> tuple412 = tuple4 = new Tuple4<List, BigInt, Option, Option>(lastRChain, lastCost2, ringR, joinerR);
            List lastRChain3 = tuple412._1();
            BigInt lastCost23 = tuple412._2();
            Option ringR3 = tuple412._3();
            Option joinerR3 = tuple412._4();
            Tuple2 tuple28 = this.optimizeProductChain(lastLChain3.toIndexedSeq(), this.pair$1(ringL3, joinerL3));
            if (tuple28 == null) throw new MatchError(tuple28);
            BigInt cost1 = tuple28._1();
            Matrix2 newLeft = tuple28._2();
            Tuple2 tuple29 = tuple27 = new Tuple2(cost1, newLeft);
            BigInt cost13 = tuple29._1();
            Matrix2 newLeft3 = tuple29._2();
            Tuple2 tuple210 = this.optimizeProductChain(lastRChain3.toIndexedSeq(), this.pair$1(ringR3, joinerR3));
            if (tuple210 == null) throw new MatchError(tuple210);
            BigInt cost2 = tuple210._1();
            Matrix2 newRight = tuple210._2();
            Tuple2 tuple211 = tuple2 = new Tuple2(cost2, newRight);
            BigInt cost23 = tuple211._1();
            Matrix2 newRight3 = tuple211._2();
            Tuple4 tuple413 = new Tuple4(List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new HadamardProduct[]{new HadamardProduct(newLeft3, newRight3, ring)})), lastCost13.$plus(lastCost23).$plus(cost13).$plus(cost23), ringL3.orElse(new scala.Serializable(ringR3){
                public static final long serialVersionUID = 0L;
                private final Option ringR$2;

                public final Option<Ring<V>> apply() {
                    return this.ringR$2;
                }
                {
                    this.ringR$2 = ringR$2;
                }
            }), joinerL3.orElse(new scala.Serializable(joinerR3){
                public static final long serialVersionUID = 0L;
                private final Option joinerR$2;

                public final Option<MatrixJoiner2> apply() {
                    return this.joinerR$2;
                }
                {
                    this.joinerR$2 = joinerR$2;
                }
            }));
            return var4_9;
        } else if (matrix2 instanceof Product) {
            Tuple4<List, BigInt, Option, Option> tuple4;
            Tuple4<List, BigInt, Option, Option> tuple414;
            Product product2 = (Product)matrix2;
            Matrix2 left5 = product2.left();
            Matrix2 right = product2.right();
            Ring ring = product2.ring();
            Tuple4 tuple415 = this.optimizeBasicBlocks$1(left5);
            if (tuple415 == null) throw new MatchError(tuple415);
            List lastLChain = (List)tuple415._1();
            BigInt lastCost1 = (BigInt)tuple415._2();
            Option ringL = (Option)tuple415._3();
            Option joinerL = (Option)tuple415._4();
            Tuple4<List, BigInt, Option, Option> tuple416 = tuple414 = new Tuple4<List, BigInt, Option, Option>(lastLChain, lastCost1, ringL, joinerL);
            List lastLChain4 = tuple416._1();
            BigInt lastCost14 = tuple416._2();
            Option ringL4 = tuple416._3();
            Option joinerL4 = tuple416._4();
            Tuple4 tuple417 = this.optimizeBasicBlocks$1(right);
            if (tuple417 == null) throw new MatchError(tuple417);
            List lastRChain = (List)tuple417._1();
            BigInt lastCost2 = (BigInt)tuple417._2();
            Option ringR = (Option)tuple417._3();
            Option joinerR = (Option)tuple417._4();
            Tuple4<List, BigInt, Option, Option> tuple418 = tuple4 = new Tuple4<List, BigInt, Option, Option>(lastRChain, lastCost2, ringR, joinerR);
            List lastRChain4 = tuple418._1();
            BigInt lastCost24 = tuple418._2();
            Option ringR4 = tuple418._3();
            Option joinerR4 = tuple418._4();
            Tuple4 tuple419 = new Tuple4(lastLChain4.$plus$plus(lastRChain4, List$.MODULE$.canBuildFrom()), lastCost14.$plus(lastCost24), new Some(ring), new Some<MatrixJoiner2>(product2.joiner()));
            return var4_9;
        } else {
            Tuple4<GenTraversable, BigInt, None$, None$> tuple4 = new Tuple4<GenTraversable, BigInt, None$, None$>(List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Matrix2[]{matrix2})), BigInt$.MODULE$.int2bigInt(0), None$.MODULE$, None$.MODULE$);
        }
        return var4_9;
    }

    private Matrix2$() {
        MODULE$ = this;
    }
}

