/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.commons.tap;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.tap.hadoop.Hfs;
import com.twitter.scalding.commons.datastores.VersionedStore;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class VersionedTap
extends Hfs {
    public Long version = null;
    private int versionsToKeep = 3;
    public TapMode mode;
    private String newVersionPath;

    public VersionedTap(String string2, Scheme<JobConf, RecordReader, OutputCollector, ?, ?> scheme, TapMode tapMode) throws IOException {
        super(scheme, string2);
        this.mode = tapMode;
    }

    public VersionedTap setVersion(long l) {
        this.version = l;
        return this;
    }

    public VersionedTap setVersionsToKeep(int n) {
        this.versionsToKeep = n;
        return this;
    }

    public int getVersionsToKeep() {
        return this.versionsToKeep;
    }

    public String getOutputDirectory() {
        return this.getPath().toString();
    }

    public VersionedStore getStore(JobConf jobConf) throws IOException {
        return new VersionedStore(this.getPath().getFileSystem((Configuration)jobConf), this.getOutputDirectory());
    }

    public String getSourcePath(JobConf jobConf) {
        try {
            String string2;
            VersionedStore versionedStore = this.getStore(jobConf);
            String string3 = string2 = this.version != null ? versionedStore.versionPath(this.version) : versionedStore.mostRecentVersionPath();
            if (string2 == null) {
                throw new RuntimeException("Could not find valid source path for VersionTap with root: " + versionedStore.getRoot());
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String getSinkPath(JobConf jobConf) {
        try {
            String string2;
            VersionedStore versionedStore = this.getStore(jobConf);
            String string3 = string2 = this.version == null ? versionedStore.createVersion() : versionedStore.createVersion(this.version);
            if (string2 == null) {
                throw new RuntimeException("Could not find valid sink path for VersionTap with root: " + versionedStore.getRoot());
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> flowProcess, JobConf jobConf) {
        super.sourceConfInit(flowProcess, jobConf);
        FileInputFormat.setInputPaths((JobConf)jobConf, (String)this.getSourcePath(jobConf));
    }

    @Override
    public void sinkConfInit(FlowProcess<JobConf> flowProcess, JobConf jobConf) {
        super.sinkConfInit(flowProcess, jobConf);
        if (this.newVersionPath == null) {
            this.newVersionPath = this.getSinkPath(jobConf);
        }
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)new Path(this.newVersionPath));
    }

    @Override
    public boolean resourceExists(JobConf jobConf) throws IOException {
        return this.getStore(jobConf).mostRecentVersion() != null;
    }

    @Override
    public boolean createResource(JobConf jobConf) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean deleteResource(JobConf jobConf) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getIdentifier() {
        String string2 = this.getOutputDirectory();
        String string3 = this.version == null ? "LATEST" : this.version.toString();
        return string2 + "/" + (this.mode == TapMode.SINK ? "sink" : "source") + "/" + string3;
    }

    @Override
    public long getModifiedTime(JobConf jobConf) throws IOException {
        VersionedStore versionedStore = this.getStore(jobConf);
        return this.mode == TapMode.SINK ? 0L : versionedStore.mostRecentVersion();
    }

    @Override
    public boolean commitResource(JobConf jobConf) throws IOException {
        VersionedStore versionedStore = this.getStore(jobConf);
        if (this.newVersionPath != null) {
            versionedStore.succeedVersion(this.newVersionPath);
            VersionedTap.markSuccessfulOutputDir(new Path(this.newVersionPath), jobConf);
            this.newVersionPath = null;
            versionedStore.cleanup(this.getVersionsToKeep());
        }
        return true;
    }

    private static void markSuccessfulOutputDir(Path path, JobConf jobConf) throws IOException {
        FileSystem fileSystem = path.getFileSystem((Configuration)jobConf);
        if (fileSystem.exists(path)) {
            Path path2 = new Path(path, "_SUCCESS");
            fileSystem.create(path2).close();
        }
    }

    @Override
    public boolean rollbackResource(JobConf jobConf) throws IOException {
        if (this.newVersionPath != null) {
            this.getStore(jobConf).failVersion(this.newVersionPath);
            this.newVersionPath = null;
        }
        return true;
    }

    public static enum TapMode {
        SOURCE,
        SINK;

    }
}

