/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.commons.scheme;

import cascading.flow.FlowProcess;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.hadoop.WritableSequenceFile;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class KeyValueByteScheme
extends WritableSequenceFile {
    public KeyValueByteScheme(Fields fields2) {
        super(fields2, BytesWritable.class, BytesWritable.class);
    }

    public static byte[] getBytes(BytesWritable bytesWritable) {
        return Arrays.copyOfRange(bytesWritable.getBytes(), 0, bytesWritable.getLength());
    }

    @Override
    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        BytesWritable bytesWritable = (BytesWritable)sourceCall.getContext()[0];
        BytesWritable bytesWritable2 = (BytesWritable)sourceCall.getContext()[1];
        boolean bl = sourceCall.getInput().next((Object)bytesWritable, (Object)bytesWritable2);
        if (!bl) {
            return false;
        }
        Tuple tuple = sourceCall.getIncomingEntry().getTuple();
        tuple.clear();
        tuple.add(KeyValueByteScheme.getBytes(bytesWritable));
        tuple.add(KeyValueByteScheme.getBytes(bytesWritable2));
        return true;
    }

    @Override
    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Void, OutputCollector> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        byte[] byArray = (byte[])tupleEntry.getObject(0);
        byte[] byArray2 = (byte[])tupleEntry.getObject(1);
        sinkCall.getOutput().collect((Object)new BytesWritable(byArray), (Object)new BytesWritable(byArray2));
    }
}

