/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.commons.extensions;

import cascading.flow.FlowDef;
import cascading.pipe.Pipe;
import cascading.tuple.Fields;
import com.twitter.scalding.Args;
import com.twitter.scalding.Dsl$;
import com.twitter.scalding.FixedPathSource;
import com.twitter.scalding.HadoopTest;
import com.twitter.scalding.Hdfs;
import com.twitter.scalding.Mode;
import com.twitter.scalding.SequenceFile;
import com.twitter.scalding.SequenceFile$;
import com.twitter.scalding.Source;
import com.twitter.scalding.Tsv;
import com.twitter.scalding.Tsv$;
import com.twitter.scalding.TupleConverter;
import com.twitter.scalding.TupleSetter;
import com.twitter.scalding.commons.extensions.Checkpoint;
import com.twitter.scalding.package$;
import com.twitter.scalding.typed.TypedPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$IntIsIntegral$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Checkpoint$ {
    public static final Checkpoint$ MODULE$;
    private final Logger LOG;

    static {
        new Checkpoint$();
    }

    private Logger LOG() {
        return this.LOG;
    }

    public <A> Pipe apply(String checkpointName, Fields resultFields, Function0<Pipe> flow, Args args2, Mode mode2, FlowDef flowDef, TupleConverter<A> conv, TupleSetter<A> setter2) {
        Option<String> option2;
        block5: {
            Pipe pipe;
            block3: {
                block4: {
                    Some some;
                    boolean bl;
                    String format2;
                    block2: {
                        conv.assertArityMatches(resultFields);
                        setter2.assertArityMatches(resultFields);
                        Option<String> filename = this.getFilename(checkpointName, args2, mode2);
                        format2 = this.getFormat(checkpointName, args2, mode2);
                        bl = false;
                        some = null;
                        option2 = filename;
                        if (!(option2 instanceof Some)) break block2;
                        bl = true;
                        some = (Some)option2;
                        String name2 = (String)some.x();
                        if (!this.hasInput(checkpointName, name2, args2, mode2)) break block2;
                        this.LOG().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint \"", "\": reading ", " input from \"", "\""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{checkpointName, format2, name2})));
                        pipe = Dsl$.MODULE$.pipeToRichPipe(this.getSource(format2, name2, mode2).read(flowDef, mode2)).mapTo(Dsl$.MODULE$.tuple2ToFieldsPair(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(List$.MODULE$.range(BoxesRunTime.boxToInteger(0), BoxesRunTime.boxToInteger(resultFields.size()), Numeric$IntIsIntegral$.MODULE$)), resultFields), new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Fields apply(TraversableOnce<Object> f2) {
                                return Dsl$.MODULE$.intFields(f2);
                            }
                        }, Predef$.MODULE$.conforms()), new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final A apply(A x) {
                                return x;
                            }
                        }, conv, setter2);
                        break block3;
                    }
                    if (!bl) break block4;
                    String name3 = (String)some.x();
                    Pipe pipe2 = Dsl$.MODULE$.pipeToRichPipe(flow.apply()).project(resultFields);
                    this.LOG().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint \"", "\": writing ", " output to \"", "\""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{checkpointName, format2, name3})));
                    pipe = Dsl$.MODULE$.pipeToRichPipe(pipe2).write(this.getSource(format2, name3, mode2), flowDef, mode2);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option3 = option2;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                pipe = Dsl$.MODULE$.pipeToRichPipe(flow.apply()).project(resultFields);
            }
            return pipe;
        }
        throw new MatchError(option2);
    }

    public <A> TypedPipe<A> apply(String checkpointName, Function0<TypedPipe<A>> flow, Args args2, Mode mode2, FlowDef flowDef, TupleConverter<A> conv, TupleSetter<A> setter2) {
        Pipe rPipe = this.apply(checkpointName, Dsl$.MODULE$.intFields(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), conv.arity())), (Function0<Pipe>)((Object)new Serializable(flow, mode2, flowDef, conv, setter2){
            public static final long serialVersionUID = 0L;
            private final Function0 flow$1;
            private final Mode mode$1;
            private final FlowDef flowDef$1;
            private final TupleConverter conv$1;
            private final TupleSetter setter$1;

            public final Pipe apply() {
                return ((TypedPipe)this.flow$1.apply()).toPipe(Dsl$.MODULE$.intFields(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.conv$1.arity())), this.flowDef$1, this.mode$1, this.setter$1);
            }
            {
                this.flow$1 = flow$1;
                this.mode$1 = mode$1;
                this.flowDef$1 = flowDef$1;
                this.conv$1 = conv$1;
                this.setter$1 = setter$1;
            }
        }), args2, mode2, flowDef, conv, setter2);
        return package$.MODULE$.TypedPipe().from(rPipe, Dsl$.MODULE$.intFields(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), conv.arity())), flowDef, mode2, conv);
    }

    private Option<String> getFilename(String checkpointName, Args args2, Mode mode2) {
        Checkpoint.CheckpointArg fileArg = new Checkpoint.CheckpointArg(checkpointName, "file", args2);
        return fileArg.overrideValue().isDefined() ? fileArg.overrideValue() : fileArg.baseValue().map(new Serializable(checkpointName){
            public static final long serialVersionUID = 0L;
            private final String checkpointName$1;

            public final String apply(String value2) {
                return new StringBuilder().append((Object)value2).append((Object)"_").append((Object)this.checkpointName$1).toString();
            }
            {
                this.checkpointName$1 = checkpointName$1;
            }
        });
    }

    private String getFormat(String checkpointName, Args args2, Mode mode2) {
        Mode mode3 = mode2;
        boolean bl = mode3 instanceof Hdfs ? true : mode3 instanceof HadoopTest;
        String string2 = bl ? "sequencefile" : "tsv";
        String defaultFormat = string2;
        return new Checkpoint.CheckpointArg(checkpointName, "format", args2).value().getOrElse(new Serializable(defaultFormat){
            public static final long serialVersionUID = 0L;
            private final String defaultFormat$1;

            public final String apply() {
                return this.defaultFormat$1;
            }
            {
                this.defaultFormat$1 = defaultFormat$1;
            }
        }).toLowerCase();
    }

    private Source getSource(String format2, String filename, Mode mode2) {
        block4: {
            FixedPathSource fixedPathSource;
            block3: {
                String string2;
                block2: {
                    String string3 = string2 = format2;
                    if ("sequencefile" != null ? !"sequencefile".equals(string3) : string3 != null) break block2;
                    fixedPathSource = new SequenceFile(filename, SequenceFile$.MODULE$.apply$default$2(), SequenceFile$.MODULE$.apply$default$3());
                    break block3;
                }
                String string4 = string2;
                if ("tsv" != null ? !"tsv".equals(string4) : string4 != null) break block4;
                fixedPathSource = new Tsv(filename, Tsv$.MODULE$.apply$default$2(), Tsv$.MODULE$.apply$default$3(), Tsv$.MODULE$.apply$default$4(), Tsv$.MODULE$.apply$default$5());
            }
            return fixedPathSource;
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"Invalid value for --checkpoint.format: ").append((Object)format2).toString());
    }

    private boolean hasInput(String checkpointName, String filename, Args args2, Mode mode2) {
        return !new Checkpoint.CheckpointArg(checkpointName, "clobber", args2).isTrue() && mode2.fileExists(filename);
    }

    private Checkpoint$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

