/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.commons.datastores;

import com.twitter.scalding.commons.datastores.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.AccessControlException;

public class VersionedStore {
    public static final String FINISHED_VERSION_SUFFIX = ".version";
    public static final String HADOOP_SUCCESS_FLAG = "_SUCCESS";
    private String root;
    private FileSystem fs;

    public VersionedStore(String string2) throws IOException {
        this(Utils.getFS(string2), string2);
    }

    public VersionedStore(FileSystem fileSystem, String string2) throws IOException {
        this.fs = fileSystem;
        this.root = string2;
        this.mkdirs(this.root);
    }

    public VersionedStore(Path path, Configuration configuration) throws IOException {
        this.fs = path.getFileSystem(configuration);
        this.root = path.toString();
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public String getRoot() {
        return this.root;
    }

    public String versionPath(long l) {
        return new Path(this.getRoot(), "" + l).toString();
    }

    public String mostRecentVersionPath() throws IOException {
        Long l = this.mostRecentVersion();
        return l == null ? null : this.versionPath(l);
    }

    public String mostRecentVersionPath(long l) throws IOException {
        Long l2 = this.mostRecentVersion(l);
        return l2 == null ? null : this.versionPath(l2);
    }

    public Long mostRecentVersion() throws IOException {
        return this.mostRecentVersion(false, null);
    }

    public Long mostRecentVersion(boolean bl) throws IOException {
        return this.mostRecentVersion(bl, null);
    }

    public Long mostRecentVersion(long l) throws IOException {
        return this.mostRecentVersion(false, l);
    }

    public Long mostRecentVersion(boolean bl, Long l) throws IOException {
        List<Long> list2 = this.getAllVersions(bl);
        if (l == null) {
            return list2.size() == 0 ? null : list2.get(0);
        }
        for (Long l2 : list2) {
            if (l2 > l) continue;
            return l2;
        }
        return null;
    }

    public long newVersion() {
        return System.currentTimeMillis();
    }

    public String createVersion() throws IOException {
        return this.createVersion(this.newVersion());
    }

    public String createVersion(long l) throws IOException {
        String string2 = this.versionPath(l);
        if (this.getAllVersions().contains(l)) {
            throw new RuntimeException("Version already exists or data already exists");
        }
        this.fs.delete(new Path(this.versionPath(l)), true);
        return string2;
    }

    public void failVersion(String string2) throws IOException {
        this.deleteVersion(this.validateAndGetVersion(string2));
    }

    public void deleteVersion(long l) throws IOException {
        this.fs.delete(new Path(this.tokenPath(l)), false);
        this.fs.delete(new Path(this.successFlagPath(l)), false);
        this.fs.delete(new Path(this.versionPath(l)), true);
    }

    public void succeedVersion(String string2) throws IOException {
        this.succeedVersion(this.validateAndGetVersion(string2));
    }

    public void succeedVersion(long l) throws IOException {
        this.createNewFile(this.tokenPath(l));
    }

    public void cleanup() throws IOException {
        this.cleanup(-1);
    }

    public void cleanup(int n) throws IOException {
        if (n < 0) {
            return;
        }
        List<Long> list2 = this.getAllVersions();
        int n2 = list2.size();
        if (n2 <= n) {
            return;
        }
        for (Long l : list2.subList(n, n2)) {
            this.deleteVersion(l);
        }
    }

    public List<Long> getAllVersions() throws IOException {
        return this.getAllVersions(false);
    }

    public List<Long> getAllVersions(boolean bl) throws IOException {
        Path path = new Path(this.getRoot());
        if (this.getFileSystem().exists(path)) {
            HashSet<Long> hashSet = new HashSet<Long>();
            for (Path path2 : this.listDir(this.getRoot())) {
                FileStatus fileStatus = this.getFileSystem().getFileStatus(path2);
                if (bl) {
                    if (!Utils.isLong(path2.getName())) continue;
                    hashSet.add(Long.valueOf(path2.getName()));
                    continue;
                }
                if (path2.getName().startsWith("_")) continue;
                try {
                    if (path2.getName().endsWith(FINISHED_VERSION_SUFFIX)) {
                        hashSet.add(this.validateAndGetVersion(path2.toString()));
                        continue;
                    }
                    if (fileStatus == null || !fileStatus.isDir() || !this.getFileSystem().exists(new Path(path2, HADOOP_SUCCESS_FLAG))) continue;
                    hashSet.add(this.validateAndGetVersion(path2.toString() + FINISHED_VERSION_SUFFIX));
                }
                catch (RuntimeException runtimeException) {}
            }
            ArrayList arrayList = new ArrayList(hashSet);
            Collections.sort(arrayList);
            Collections.reverse(arrayList);
            return arrayList;
        }
        return Collections.emptyList();
    }

    public boolean hasVersion(long l) throws IOException {
        return this.getAllVersions().contains(l);
    }

    private String tokenPath(long l) {
        return new Path(this.root, "" + l + FINISHED_VERSION_SUFFIX).toString();
    }

    private String successFlagPath(long l) {
        return new Path(this.versionPath(l), HADOOP_SUCCESS_FLAG).toString();
    }

    private Path normalizePath(String string2) {
        return new Path(string2).makeQualified(this.fs);
    }

    private long validateAndGetVersion(String string2) {
        Path path = new Path(string2).getParent();
        if (!this.normalizePath(string2).getParent().equals((Object)this.normalizePath(this.root))) {
            throw new RuntimeException(string2 + " " + path + " is not part of the versioned store located at " + this.root);
        }
        Long l = this.parseVersion(string2);
        if (l == null) {
            throw new RuntimeException(string2 + " is not a valid version");
        }
        Path path2 = new Path(path, l.toString());
        try {
            FileStatus fileStatus = this.getFileSystem().getFileStatus(path2);
            if (fileStatus == null || !fileStatus.isDir()) {
                throw new RuntimeException(path2 + " is not a valid version subfolder");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("could not stat path: " + path2);
        }
        return l;
    }

    public Long parseVersion(String string2) {
        String string3 = new Path(string2).getName();
        if (string3.endsWith(FINISHED_VERSION_SUFFIX)) {
            string3 = string3.substring(0, string3.length() - FINISHED_VERSION_SUFFIX.length());
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private void createNewFile(String string2) throws IOException {
        if (this.fs instanceof LocalFileSystem) {
            new File(string2).createNewFile();
        } else {
            this.fs.createNewFile(new Path(string2));
        }
    }

    private void mkdirs(String string2) throws IOException {
        if (this.fs instanceof LocalFileSystem) {
            new File(string2).mkdirs();
        } else {
            try {
                this.fs.mkdirs(new Path(string2));
            }
            catch (AccessControlException accessControlException) {
                throw new RuntimeException("Root directory doesn't exist, and user doesn't have the permissions to create" + string2 + ".", accessControlException);
            }
        }
    }

    private List<Path> listDir(String string2) throws IOException {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        if (this.fs instanceof LocalFileSystem) {
            for (File file : new File(string2).listFiles()) {
                arrayList.add(new Path(file.getAbsolutePath()));
            }
        } else {
            for (FileStatus fileStatus : this.fs.listStatus(new Path(string2))) {
                arrayList.add(fileStatus.getPath());
            }
        }
        return arrayList;
    }
}

