/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.maple.tap;

import cascading.tuple.Tuple;
import com.twitter.maple.tap.TupleWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleMemoryInputFormat
implements InputFormat<TupleWrapper, NullWritable> {
    private static final Logger logger = LoggerFactory.getLogger(TupleMemoryInputFormat.class);
    public static final String ENCODING = "US-ASCII";
    public static final String TUPLES_PROPERTY = "memory.format.tuples";

    public InputSplit[] getSplits(JobConf jobConf, int n) throws IOException {
        List<Tuple> list2 = TupleMemoryInputFormat.retrieveTuples(jobConf, TUPLES_PROPERTY);
        return new InputSplit[]{new TupleInputSplit(list2.size())};
    }

    public RecordReader<TupleWrapper, NullWritable> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
        return new TupleRecordReader(TupleMemoryInputFormat.retrieveTuples(jobConf, TUPLES_PROPERTY));
    }

    public static String encodeBytes(byte[] byArray) {
        try {
            return new String(Base64.encodeBase64(byArray), ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static byte[] decodeBytes(String string2) {
        try {
            byte[] byArray = string2.getBytes(ENCODING);
            return Base64.decodeBase64(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static void storeTuples(JobConf jobConf, String string2, List<Tuple> list2) {
        SerializationFactory serializationFactory = new SerializationFactory((Configuration)jobConf);
        logger.debug("Storing tuples: {}", (Object)list2);
        Serializer serializer = serializationFactory.getSerializer(Tuple.class);
        logger.debug("Storing tuples with serializer: {}", (Object)serializer);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            serializer.open((OutputStream)byteArrayOutputStream);
            for (Tuple tuple : list2) {
                serializer.serialize((Object)tuple);
            }
            serializer.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        String string3 = list2.size() + ":" + TupleMemoryInputFormat.encodeBytes(byteArrayOutputStream.toByteArray());
        jobConf.set(string2, string3);
    }

    public static List<Tuple> retrieveTuples(JobConf jobConf, String string2) {
        String string3 = jobConf.get(string2);
        if (string3 == null) {
            return null;
        }
        String[] stringArray = string3.split(":");
        int n = Integer.valueOf(stringArray[0]);
        byte[] byArray = stringArray.length > 1 ? TupleMemoryInputFormat.decodeBytes(stringArray[1]) : new byte[]{};
        SerializationFactory serializationFactory = new SerializationFactory((Configuration)jobConf);
        Deserializer deserializer = serializationFactory.getDeserializer(Tuple.class);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        try {
            deserializer.open((InputStream)byteArrayInputStream);
            for (int i = 0; i < n; ++i) {
                arrayList.add((Tuple)deserializer.deserialize(null));
            }
            deserializer.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return arrayList;
    }

    public static class TupleRecordReader
    implements RecordReader<TupleWrapper, NullWritable> {
        List<Tuple> tuples;
        int pos = 0;

        public TupleRecordReader(List<Tuple> list2) {
            this.tuples = list2;
        }

        public boolean next(TupleWrapper tupleWrapper, NullWritable nullWritable) throws IOException {
            if (this.pos >= this.tuples.size()) {
                return false;
            }
            tupleWrapper.tuple = this.tuples.get(this.pos++);
            return true;
        }

        public TupleWrapper createKey() {
            return new TupleWrapper();
        }

        public NullWritable createValue() {
            return NullWritable.get();
        }

        public long getPos() throws IOException {
            return this.pos;
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException {
            if (this.tuples.size() == 0) {
                return 1.0f;
            }
            return (float)((double)this.pos * 1.0 / (double)this.tuples.size());
        }
    }

    public static class TupleInputSplit
    implements InputSplit {
        public int numTuples;

        public TupleInputSplit() {
        }

        public TupleInputSplit(int n) {
            this.numTuples = n;
        }

        public long getLength() throws IOException {
            return this.numTuples;
        }

        public String[] getLocations() throws IOException {
            return new String[0];
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.numTuples);
        }

        public void readFields(DataInput dataInput) throws IOException {
            this.numTuples = dataInput.readInt();
        }
    }
}

