/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.maple.tap;

import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.SequenceFile;
import cascading.tap.hadoop.Lfs;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;

public class StdoutTap
extends Lfs {
    public StdoutTap() {
        super((Scheme)new SequenceFile(Fields.ALL), StdoutTap.getTempDir());
    }

    public static String getTempDir() {
        File file;
        try {
            file = File.createTempFile("temp", Long.toString(System.nanoTime()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        file.deleteOnExit();
        if (!file.delete()) {
            throw new RuntimeException("Could not delete temp file: " + file.getAbsolutePath());
        }
        return file.getAbsoluteFile().getPath();
    }

    @Override
    public boolean commitResource(JobConf jobConf) throws IOException {
        TupleEntryIterator tupleEntryIterator = new HadoopFlowProcess(jobConf).openTapForRead(this);
        System.out.println("");
        System.out.println("");
        System.out.println("RESULTS");
        System.out.println("-----------------------");
        while (tupleEntryIterator.hasNext()) {
            System.out.println(((TupleEntry)tupleEntryIterator.next()).getTuple());
        }
        System.out.println("-----------------------");
        tupleEntryIterator.close();
        return true;
    }
}

