/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.maple.tap;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.SourceTap;
import cascading.tap.Tap;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeIterator;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryIterator;
import com.twitter.maple.tap.TupleMemoryInputFormat;
import com.twitter.maple.tap.TupleWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

public class MemorySourceTap
extends SourceTap<JobConf, RecordReader<TupleWrapper, NullWritable>>
implements Serializable {
    private final String id = ((MemorySourceScheme)this.getScheme()).getId();

    public MemorySourceTap(List<Tuple> list2, Fields fields2) {
        super(new MemorySourceScheme(list2, fields2, "/" + UUID.randomUUID().toString()));
    }

    @Override
    public String getIdentifier() {
        return this.getPath().toString();
    }

    public Path getPath() {
        return new Path(this.id);
    }

    @Override
    public boolean resourceExists(JobConf jobConf) throws IOException {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        MemorySourceTap memorySourceTap = (MemorySourceTap)object;
        return this.id.equals(memorySourceTap.id);
    }

    @Override
    public TupleEntryIterator openForRead(FlowProcess<JobConf> flowProcess, RecordReader<TupleWrapper, NullWritable> recordReader) throws IOException {
        return new HadoopTupleEntrySchemeIterator(flowProcess, this, recordReader);
    }

    @Override
    public long getModifiedTime(JobConf jobConf) throws IOException {
        return System.currentTimeMillis();
    }

    public static class MemorySourceScheme
    extends Scheme<JobConf, RecordReader<TupleWrapper, NullWritable>, Void, Object[], Void> {
        private transient List<Tuple> tuples;
        private final String id;

        public MemorySourceScheme(List<Tuple> list2, Fields fields2, String string2) {
            super(fields2);
            assert (list2 != null);
            this.tuples = list2;
            this.id = string2;
        }

        public String getId() {
            return this.id;
        }

        public List<Tuple> getTuples() {
            return this.tuples;
        }

        @Override
        public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader<TupleWrapper, NullWritable>, Void> tap, JobConf jobConf) {
            FileInputFormat.setInputPaths((JobConf)jobConf, (String)this.id);
            jobConf.setInputFormat(TupleMemoryInputFormat.class);
            TupleMemoryInputFormat.storeTuples(jobConf, "memory.format.tuples", this.tuples);
        }

        @Override
        public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader<TupleWrapper, NullWritable>, Void> tap, JobConf jobConf) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void sourcePrepare(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader<TupleWrapper, NullWritable>> sourceCall) {
            sourceCall.setContext(new Object[2]);
            sourceCall.getContext()[0] = sourceCall.getInput().createKey();
            sourceCall.getContext()[1] = sourceCall.getInput().createValue();
        }

        @Override
        public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader<TupleWrapper, NullWritable>> sourceCall) throws IOException {
            TupleWrapper tupleWrapper = (TupleWrapper)sourceCall.getContext()[0];
            NullWritable nullWritable = (NullWritable)sourceCall.getContext()[1];
            boolean bl = sourceCall.getInput().next((Object)tupleWrapper, (Object)nullWritable);
            if (!bl) {
                return false;
            }
            sourceCall.getIncomingEntry().setTuple(tupleWrapper.tuple);
            return true;
        }

        @Override
        public void sourceCleanup(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader<TupleWrapper, NullWritable>> sourceCall) {
            sourceCall.setContext(null);
        }

        @Override
        public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Void, Void> sinkCall) throws IOException {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

