/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.maple.tap;

import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.SequenceFile;
import cascading.tap.hadoop.Lfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.mapred.JobConf;

public class MemorySinkTap
extends Lfs {
    private List<Tuple> results;
    private Fields fields;

    public MemorySinkTap(List<Tuple> list2, Fields fields2) {
        super((Scheme)new SequenceFile(Fields.ALL), MemorySinkTap.getTempDir());
        this.results = list2;
        this.fields = fields2;
    }

    public MemorySinkTap(List<Tuple> list2) {
        this(list2, new Fields(new Comparable[0]));
    }

    public static String getTempDir() {
        File file;
        try {
            file = File.createTempFile("temp", Long.toString(System.nanoTime()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        file.deleteOnExit();
        if (!file.delete()) {
            throw new RuntimeException("Could not delete temp file: " + file.getAbsolutePath());
        }
        return file.getAbsoluteFile().getPath();
    }

    @Override
    public boolean commitResource(JobConf jobConf) throws IOException {
        TupleEntryIterator tupleEntryIterator = new HadoopFlowProcess(jobConf).openTapForRead(this);
        boolean bl = true;
        while (tupleEntryIterator.hasNext()) {
            TupleEntry tupleEntry = (TupleEntry)tupleEntryIterator.next();
            this.results.add(tupleEntry.getTupleCopy());
            if (!bl) continue;
            this.fields = tupleEntry.getFields();
            bl = false;
        }
        tupleEntryIterator.close();
        return true;
    }
}

