/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.maple.hbase.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.mapred.TableInputFormatBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.util.StringUtils;

public class TableInputFormat
extends TableInputFormatBase
implements JobConfigurable {
    private final Log LOG = LogFactory.getLog(TableInputFormat.class);
    public static final String COLUMN_LIST = "hbase.mapred.tablecolumns";
    public static final String INPUT_TABLE = "hbase.mapred.inputtable";

    public void configure(JobConf jobConf) {
        String string2 = TableInputFormat.getTableName(jobConf);
        String string3 = jobConf.get(COLUMN_LIST);
        String[] stringArray = string3.split(" ");
        byte[][] byArrayArray = new byte[stringArray.length][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            byArrayArray[i] = Bytes.toBytes((String)stringArray[i]);
        }
        this.setInputColumns(byArrayArray);
        try {
            this.setHTable(new HTable(HBaseConfiguration.create((Configuration)jobConf), string2));
        }
        catch (Exception exception) {
            this.LOG.error(StringUtils.stringifyException((Throwable)exception));
        }
    }

    public void validateInput(JobConf jobConf) throws IOException {
        String string2 = TableInputFormat.getTableName(jobConf);
        if (string2 == null) {
            throw new IOException("expecting one table name");
        }
        if (this.getHTable() == null) {
            throw new IOException("could not connect to table '" + string2 + "'");
        }
        String string3 = jobConf.get(COLUMN_LIST);
        if (string3 == null || string3.length() == 0) {
            throw new IOException("expecting at least one column");
        }
    }

    public static void setTableName(JobConf jobConf, String string2) {
        String string3 = TableInputFormat.getTableName(jobConf);
        if (string3 != null) {
            throw new RuntimeException("table name already set to: '" + string3 + "'");
        }
        jobConf.set(INPUT_TABLE, string2);
    }

    public static String getTableName(JobConf jobConf) {
        return jobConf.get(INPUT_TABLE);
    }
}

