/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.maple.hbase;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.TupleEntrySchemeCollector;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTapCollector
extends TupleEntrySchemeCollector<JobConf, TupleEntrySchemeCollector>
implements OutputCollector {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTapCollector.class);
    private final JobConf conf;
    private RecordWriter writer;
    private final FlowProcess<JobConf> hadoopFlowProcess;
    private final Tap<JobConf, RecordReader, OutputCollector> tap;
    private final Reporter reporter = Reporter.NULL;

    public HBaseTapCollector(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap) throws IOException {
        super(flowProcess, tap.getScheme());
        this.hadoopFlowProcess = flowProcess;
        this.tap = tap;
        this.conf = new JobConf((Configuration)flowProcess.getConfigCopy());
        this.setOutput(this);
    }

    @Override
    public void prepare() {
        try {
            this.initialize();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        super.prepare();
    }

    private void initialize() throws IOException {
        this.tap.sinkConfInit(this.hadoopFlowProcess, this.conf);
        OutputFormat outputFormat = this.conf.getOutputFormat();
        LOG.info("Output format class is: " + outputFormat.getClass().toString());
        this.writer = outputFormat.getRecordWriter(null, this.conf, this.tap.getIdentifier(), (Progressable)Reporter.NULL);
        this.sinkCall.setOutput(this);
    }

    @Override
    public void close() {
        try {
            LOG.info("closing tap collector for: {}", (Object)this.tap);
            this.writer.close(this.reporter);
        }
        catch (IOException iOException) {
            LOG.warn("exception closing: {}", iOException);
            throw new TapException("exception closing HBaseTapCollector", iOException);
        }
        finally {
            super.close();
        }
    }

    public void collect(Object object, Object object2) throws IOException {
        if (this.hadoopFlowProcess instanceof HadoopFlowProcess) {
            ((HadoopFlowProcess)this.hadoopFlowProcess).getReporter().progress();
        }
        this.writer.write(object, object2);
    }
}

