/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.maple.hbase;

import cascading.flow.FlowProcess;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeIterator;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import com.twitter.maple.hbase.HBaseScheme;
import com.twitter.maple.hbase.HBaseTapCollector;
import com.twitter.maple.hbase.mapred.TableInputFormat;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTap
extends Tap<JobConf, RecordReader, OutputCollector> {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTap.class);
    private final String id = UUID.randomUUID().toString();
    public static final String SCHEME = "hbase";
    private transient HBaseAdmin hBaseAdmin;
    private String quorumNames;
    private String tableName;

    public HBaseTap(String string2, HBaseScheme hBaseScheme) {
        super(hBaseScheme, SinkMode.UPDATE);
        this.tableName = string2;
    }

    public HBaseTap(String string2, HBaseScheme hBaseScheme, SinkMode sinkMode) {
        super(hBaseScheme, sinkMode);
        this.tableName = string2;
    }

    public HBaseTap(String string2, String string3, HBaseScheme hBaseScheme) {
        super(hBaseScheme, SinkMode.UPDATE);
        this.quorumNames = string2;
        this.tableName = string3;
    }

    public HBaseTap(String string2, String string3, HBaseScheme hBaseScheme, SinkMode sinkMode) {
        super(hBaseScheme, sinkMode);
        this.quorumNames = string2;
        this.tableName = string3;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Path getPath() {
        return new Path("hbase:/" + this.tableName.replaceAll(":", "_"));
    }

    protected HBaseAdmin getHBaseAdmin(JobConf jobConf) throws MasterNotRunningException, ZooKeeperConnectionException {
        if (this.hBaseAdmin == null) {
            Configuration configuration = HBaseConfiguration.create((Configuration)jobConf);
            this.hBaseAdmin = new HBaseAdmin(configuration);
        }
        return this.hBaseAdmin;
    }

    @Override
    public void sinkConfInit(FlowProcess<JobConf> flowProcess, JobConf jobConf) {
        if (this.quorumNames != null) {
            jobConf.set("hbase.zookeeper.quorum", this.quorumNames);
        } else {
            Configuration configuration = HBaseConfiguration.create((Configuration)jobConf);
            jobConf.set("hbase.zookeeper.quorum", configuration.get("hbase.zookeeper.quorum"));
            jobConf.set("zookeeper.znode.parent", configuration.get("zookeeper.znode.parent"));
        }
        LOG.debug("sinking to table: {}", (Object)this.tableName);
        if (this.isReplace() && jobConf.get("mapred.task.partition") == null) {
            try {
                this.deleteResource(jobConf);
            }
            catch (IOException iOException) {
                throw new RuntimeException("could not delete resource: " + iOException);
            }
        }
        if (this.isUpdate()) {
            try {
                this.createResource(jobConf);
            }
            catch (IOException iOException) {
                throw new RuntimeException(this.tableName + " does not exist !", iOException);
            }
        }
        jobConf.set("hbase.mapred.outputtable", this.tableName);
        super.sinkConfInit(flowProcess, jobConf);
    }

    @Override
    public String getIdentifier() {
        return this.id;
    }

    @Override
    public TupleEntryIterator openForRead(FlowProcess<JobConf> flowProcess, RecordReader recordReader) throws IOException {
        return new HadoopTupleEntrySchemeIterator(flowProcess, this, recordReader);
    }

    @Override
    public TupleEntryCollector openForWrite(FlowProcess<JobConf> flowProcess, OutputCollector outputCollector) throws IOException {
        HBaseTapCollector hBaseTapCollector = new HBaseTapCollector(flowProcess, this);
        hBaseTapCollector.prepare();
        return hBaseTapCollector;
    }

    @Override
    public boolean createResource(JobConf jobConf) throws IOException {
        String[] stringArray;
        HBaseAdmin hBaseAdmin = this.getHBaseAdmin(jobConf);
        if (hBaseAdmin.tableExists(this.tableName)) {
            return true;
        }
        LOG.info("creating hbase table: {}", (Object)this.tableName);
        HTableDescriptor hTableDescriptor = new HTableDescriptor(this.tableName);
        for (String string2 : stringArray = ((HBaseScheme)this.getScheme()).getFamilyNames()) {
            hTableDescriptor.addFamily(new HColumnDescriptor(string2));
        }
        hBaseAdmin.createTable(hTableDescriptor);
        return true;
    }

    @Override
    public boolean deleteResource(JobConf jobConf) throws IOException {
        return true;
    }

    @Override
    public boolean resourceExists(JobConf jobConf) throws IOException {
        return this.getHBaseAdmin(jobConf).tableExists(this.tableName);
    }

    @Override
    public long getModifiedTime(JobConf jobConf) throws IOException {
        return System.currentTimeMillis();
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> flowProcess, JobConf jobConf) {
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{this.getPath()});
        if (this.quorumNames != null) {
            jobConf.set("hbase.zookeeper.quorum", this.quorumNames);
        }
        LOG.debug("sourcing from table: {}", (Object)this.tableName);
        TableInputFormat.setTableName(jobConf, this.tableName);
        super.sourceConfInit(flowProcess, jobConf);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        HBaseTap hBaseTap = (HBaseTap)object;
        return !(this.tableName != null ? !this.tableName.equals(hBaseTap.tableName) : hBaseTap.tableName != null);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.tableName != null ? this.tableName.hashCode() : 0);
        return n;
    }
}

