/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.maple.hbase;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.util.Util;
import com.twitter.maple.hbase.mapred.TableInputFormat;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseScheme
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Object[]> {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseScheme.class);
    private Fields keyField;
    private String[] familyNames;
    private Fields[] valueFields;
    private transient String[] columns;
    private transient byte[][] fields;

    public HBaseScheme(Fields fields2, String string2, Fields fields3) {
        this(fields2, new String[]{string2}, Fields.fields(fields3));
    }

    public HBaseScheme(Fields fields2, String[] stringArray, Fields[] fieldsArray) {
        this.keyField = fields2;
        this.familyNames = stringArray;
        this.valueFields = fieldsArray;
        this.setSourceSink(this.keyField, this.valueFields);
        this.validate();
    }

    public HBaseScheme(Fields fields2, Fields fields3) {
        this(fields2, Fields.fields(fields3));
    }

    public HBaseScheme(Fields fields2, Fields[] fieldsArray) {
        this.keyField = fields2;
        this.valueFields = fieldsArray;
        this.validate();
        this.setSourceSink(this.keyField, this.valueFields);
    }

    private void validate() {
        if (this.keyField.size() != 1) {
            throw new IllegalArgumentException("may only have one key field, found: " + this.keyField.print());
        }
    }

    private void setSourceSink(Fields fields2, Fields[] fieldsArray) {
        Fields fields3 = fields2;
        if (fieldsArray.length != 0) {
            fields3 = Fields.join(fields2, Fields.join(fieldsArray));
        }
        this.setSourceFields(fields3);
        this.setSinkFields(fields3);
    }

    public String[] getFamilyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.familyNames == null) {
            for (String string2 : this.columns(null, this.valueFields)) {
                int n = string2.indexOf(":");
                hashSet.add(this.hbaseColumn(n > 0 ? string2.substring(0, n) : string2));
            }
        } else {
            for (String string3 : this.familyNames) {
                hashSet.add(string3);
            }
        }
        return hashSet.toArray(new String[0]);
    }

    @Override
    public void sourcePrepare(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        Object[] objectArray = new Object[]{sourceCall.getInput().createKey(), sourceCall.getInput().createValue()};
        sourceCall.setContext(objectArray);
    }

    @Override
    public void sourceCleanup(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext(null);
    }

    @Override
    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Tuple tuple = new Tuple();
        Object object = sourceCall.getContext()[0];
        Object object2 = sourceCall.getContext()[1];
        boolean bl = sourceCall.getInput().next(object, object2);
        if (!bl) {
            return false;
        }
        if (object == null || object2 == null) {
            return true;
        }
        ImmutableBytesWritable immutableBytesWritable = (ImmutableBytesWritable)object;
        Result result2 = (Result)object2;
        tuple.add((Comparable)immutableBytesWritable);
        for (int i = 0; i < this.familyNames.length; ++i) {
            String string2 = this.familyNames[i];
            byte[] byArray = Bytes.toBytes((String)string2);
            Fields fields2 = this.valueFields[i];
            for (int j = 0; j < fields2.size(); ++j) {
                String string3 = (String)((Object)fields2.get(j));
                byte[] byArray2 = Bytes.toBytes((String)string3);
                byte[] byArray3 = result2.getValue(byArray, byArray2);
                if (byArray3 == null) {
                    byArray3 = new byte[]{};
                }
                tuple.add((Comparable)new ImmutableBytesWritable(byArray3));
            }
        }
        sourceCall.getIncomingEntry().setTuple(tuple);
        return true;
    }

    @Override
    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        OutputCollector outputCollector = sinkCall.getOutput();
        Tuple tuple = tupleEntry.selectTuple(this.keyField);
        ImmutableBytesWritable immutableBytesWritable = (ImmutableBytesWritable)tuple.getObject(0);
        Put put2 = new Put(immutableBytesWritable.get());
        for (int i = 0; i < this.valueFields.length; ++i) {
            Fields fields2 = this.valueFields[i];
            TupleEntry tupleEntry2 = tupleEntry.selectEntry(fields2);
            for (int j = 0; j < tupleEntry2.getFields().size(); ++j) {
                Fields fields3 = tupleEntry2.getFields();
                Tuple tuple2 = tupleEntry2.getTuple();
                ImmutableBytesWritable immutableBytesWritable2 = (ImmutableBytesWritable)tuple2.getObject(j);
                put2.add(Bytes.toBytes((String)this.familyNames[i]), Bytes.toBytes((String)((String)((Object)fields3.get(j)))), immutableBytesWritable2.get());
            }
        }
        outputCollector.collect(null, (Object)put2);
    }

    @Override
    public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        jobConf.setOutputFormat(TableOutputFormat.class);
        jobConf.setOutputKeyClass(ImmutableBytesWritable.class);
        jobConf.setOutputValueClass(Put.class);
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        jobConf.setInputFormat(TableInputFormat.class);
        String string2 = this.getColumns();
        LOG.debug("sourcing from columns: {}", (Object)string2);
        jobConf.set("hbase.mapred.tablecolumns", string2);
    }

    private String getColumns() {
        return Util.join(this.columns(this.familyNames, this.valueFields), " ");
    }

    private String[] columns(String[] stringArray, Fields[] fieldsArray) {
        if (this.columns != null) {
            return this.columns;
        }
        int n = 0;
        Fields[] fieldsArray2 = fieldsArray;
        int n2 = fieldsArray2.length;
        for (int i = 0; i < n2; ++i) {
            Fields fields2 = fieldsArray2[i];
            n += fields2.size();
        }
        this.columns = new String[n];
        int n3 = 0;
        for (n2 = 0; n2 < fieldsArray.length; ++n2) {
            Fields fields3 = fieldsArray[n2];
            for (int i = 0; i < fields3.size(); ++i) {
                this.columns[n3++] = stringArray == null ? this.hbaseColumn((String)((Object)fields3.get(i))) : this.hbaseColumn(stringArray[n2]) + (String)((Object)fields3.get(i));
            }
        }
        return this.columns;
    }

    private String hbaseColumn(String string2) {
        if (string2.indexOf(":") < 0) {
            return string2 + ":";
        }
        return string2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        HBaseScheme hBaseScheme = (HBaseScheme)object;
        if (!Arrays.equals(this.familyNames, hBaseScheme.familyNames)) {
            return false;
        }
        if (this.keyField != null ? !this.keyField.equals(hBaseScheme.keyField) : hBaseScheme.keyField != null) {
            return false;
        }
        return Arrays.equals(this.valueFields, hBaseScheme.valueFields);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.keyField != null ? this.keyField.hashCode() : 0);
        n = 31 * n + (this.familyNames != null ? Arrays.hashCode(this.familyNames) : 0);
        n = 31 * n + (this.valueFields != null ? Arrays.hashCode(this.valueFields) : 0);
        return n;
    }
}

