/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;

public class ThriftToProto<T extends TBase, P extends Message> {
    Message.Builder protoBuilder_;
    P protoObj_;
    TypeRef<P> typeRef_;

    public ThriftToProto(T thriftObj, P protoObj) {
        this.protoBuilder_ = Protobufs.getMessageBuilder(protoObj.getClass());
        this.protoObj_ = protoObj;
    }

    public static <T extends TBase<?, ?>, P extends Message> ThriftToProto<T, P> newInstance(T thriftObj, P protoObj) {
        return new ThriftToProto<T, P>(thriftObj, protoObj);
    }

    public P convert(T thriftObj) {
        Descriptors.Descriptor protoDesc = this.protoObj_.getDescriptorForType();
        Map<? extends TFieldIdEnum, FieldMetaData> fieldMap2 = FieldMetaData.getStructMetaDataMap(thriftObj.getClass());
        for (Map.Entry<? extends TFieldIdEnum, FieldMetaData> e : fieldMap2.entrySet()) {
            TFieldIdEnum tFieldIdEnum = e.getKey();
            FieldValueMetaData thriftMetadata = e.getValue().valueMetaData;
            Descriptors.FieldDescriptor protoFieldDesc = protoDesc.findFieldByName(tFieldIdEnum.getFieldName());
            if (protoFieldDesc == null) {
                throw new RuntimeException("Field " + tFieldIdEnum.getFieldName() + " not found in " + this.protoObj_.getClass().getCanonicalName());
            }
            if (!this.typesMatch(protoFieldDesc, thriftMetadata)) {
                throw new RuntimeException("Field " + tFieldIdEnum.getFieldName() + " type does not match: " + "thrift " + thriftMetadata.type + "vs " + (Object)((Object)protoFieldDesc.getType()));
            }
            Object fieldValue = thriftObj.getFieldValue((TFieldIdEnum)tFieldIdEnum);
            if (protoFieldDesc.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
                this.protoBuilder_.setField(protoFieldDesc, ByteString.copyFrom((byte[])fieldValue));
                continue;
            }
            this.protoBuilder_.setField(protoFieldDesc, fieldValue);
        }
        return (P)this.protoBuilder_.build();
    }

    private boolean typesMatch(Descriptors.FieldDescriptor protoFieldDesc, FieldValueMetaData thriftMetadata) {
        if (thriftMetadata.isStruct()) {
            return false;
        }
        byte thriftType = thriftMetadata.type;
        if (thriftMetadata.type == 15 && protoFieldDesc.isRepeated()) {
            FieldValueMetaData listMeta = ((ListMetaData)thriftMetadata).elemMetaData;
            if (listMeta.isStruct() || listMeta.isContainer()) {
                return false;
            }
            thriftType = listMeta.type;
        }
        return protoFieldDesc.getType().equals((Object)this.thriftTypeToProtoType(thriftType)) || this.thriftBinSucks(protoFieldDesc.getType(), thriftType);
    }

    private boolean thriftBinSucks(Descriptors.FieldDescriptor.Type protoType, byte thriftType) {
        return thriftType == 11 && protoType == Descriptors.FieldDescriptor.Type.BYTES || protoType == Descriptors.FieldDescriptor.Type.STRING;
    }

    private Descriptors.FieldDescriptor.Type thriftTypeToProtoType(byte thriftType) {
        switch (thriftType) {
            case 2: {
                return Descriptors.FieldDescriptor.Type.BOOL;
            }
            case 3: {
                return Descriptors.FieldDescriptor.Type.INT32;
            }
            case 4: {
                return Descriptors.FieldDescriptor.Type.DOUBLE;
            }
            case 6: {
                return Descriptors.FieldDescriptor.Type.INT32;
            }
            case 8: {
                return Descriptors.FieldDescriptor.Type.INT32;
            }
            case 10: {
                return Descriptors.FieldDescriptor.Type.INT64;
            }
            case 11: {
                return Descriptors.FieldDescriptor.Type.STRING;
            }
        }
        throw new IllegalArgumentException("Can't map Thrift type " + thriftType + " to a ProtoBuf type");
    }
}

