/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftToDynamicProto<T extends TBase<?, ?>> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftToDynamicProto.class);
    private static final List<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>> EMPTY_FIELDS = new ArrayList<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>>();
    private static final String MAP_KEY_FIELD_NAME = "key";
    private static final String MAP_VALUE_FIELD_NAME = "value";
    private boolean supportNestedObjects = false;
    private boolean ignoreUnsupportedTypes = false;
    private final Descriptors.FileDescriptor fileDescriptor;
    private Map<String, DescriptorProtos.DescriptorProto.Builder> descriptorBuilderMap = Maps.newHashMap();
    private Map<String, DynamicMessage.Builder> messageBuilderMap = Maps.newHashMap();

    public ThriftToDynamicProto(Class<T> thriftClass) throws Descriptors.DescriptorValidationException {
        this(thriftClass, new ArrayList<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>>());
    }

    public ThriftToDynamicProto(Class<T> thriftClass, boolean supportNestedObjects, boolean ignoreUnsupportedTypes) throws Descriptors.DescriptorValidationException {
        this(thriftClass, new ArrayList<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>>(), supportNestedObjects, ignoreUnsupportedTypes);
    }

    public ThriftToDynamicProto(Class<T> thriftClass, List<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>> extraFields) throws Descriptors.DescriptorValidationException {
        this(thriftClass, extraFields, false, false);
    }

    public ThriftToDynamicProto(Class<T> thriftClass, List<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>> extraFields, boolean supportNestedObjects, boolean ignoreUnsupportedTypes) throws Descriptors.DescriptorValidationException {
        this.supportNestedObjects = supportNestedObjects;
        this.ignoreUnsupportedTypes = ignoreUnsupportedTypes;
        DescriptorProtos.DescriptorProto.Builder desBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        desBuilder.setName(this.protoMessageType(thriftClass));
        this.descriptorBuilderMap.put(desBuilder.getName(), desBuilder);
        this.thriftToProtoSchema(desBuilder, TStructDescriptor.getInstance(thriftClass), extraFields);
        DescriptorProtos.FileDescriptorProto.Builder fileDescProtoBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
        for (DescriptorProtos.DescriptorProto.Builder builder : this.descriptorBuilderMap.values()) {
            fileDescProtoBuilder.addMessageType(builder);
        }
        Descriptors.FileDescriptor dynamicDescriptor = Descriptors.FileDescriptor.buildFrom(fileDescProtoBuilder.build(), new Descriptors.FileDescriptor[0]);
        for (String type : this.descriptorBuilderMap.keySet()) {
            Descriptors.Descriptor msgDescriptor = dynamicDescriptor.findMessageTypeByName(type);
            this.messageBuilderMap.put(type, DynamicMessage.newBuilder(msgDescriptor));
        }
        this.fileDescriptor = dynamicDescriptor;
    }

    public Message.Builder getBuilder(Class<? extends TBase<?, ?>> thriftClass) {
        return this.messageBuilderMap.get(this.protoMessageType(thriftClass)).clone();
    }

    private Message.Builder mapEntryProtoBuilder(TStructDescriptor descriptor, TStructDescriptor.Field field2) {
        return this.messageBuilderMap.get(this.mapProtoMessageType(descriptor, field2)).clone();
    }

    private void thriftToProtoSchema(DescriptorProtos.DescriptorProto.Builder desBuilder, TStructDescriptor fieldDesc, List<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>> extraFields) throws Descriptors.DescriptorValidationException {
        int maxThriftId = this.doSchemaMapping(desBuilder, fieldDesc);
        int extraFieldIdx = maxThriftId + 1;
        for (Pair<String, DescriptorProtos.FieldDescriptorProto.Type> extraField : extraFields) {
            this.addProtoField(desBuilder, extraField.getFirst(), ++extraFieldIdx, extraField.getSecond(), false);
        }
    }

    private int doSchemaMapping(DescriptorProtos.DescriptorProto.Builder desBuilder, TStructDescriptor fieldDesc) throws Descriptors.DescriptorValidationException {
        int maxThriftId = 0;
        for (TStructDescriptor.Field tField : fieldDesc.getFields()) {
            maxThriftId = Math.max(tField.getFieldId(), maxThriftId);
            if (this.supportNestedObjects && tField.isMap()) {
                String typeName = this.mapProtoMessageType(fieldDesc, tField);
                if (this.descriptorBuilderMap.get(typeName) != null) continue;
                DescriptorProtos.DescriptorProto.Builder mapBuilder = this.mapDescriptorProtoBuilder(tField, typeName);
                this.descriptorBuilderMap.put(typeName, mapBuilder);
                this.addProtoField(desBuilder, tField.getName(), tField.getFieldId() + 1, typeName, true);
                continue;
            }
            TStructDescriptor.Field field2 = this.resolveField(tField);
            DescriptorProtos.FieldDescriptorProto.Type protoType = this.thriftTypeToProtoType(field2);
            boolean isContainer = this.isContainer(tField);
            if (this.supportNestedObjects && protoType == DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE) {
                String typeName = this.resolveMessageTypeName(field2.gettStructDescriptor());
                this.addProtoField(desBuilder, tField.getName(), tField.getFieldId() + 1, typeName, isContainer);
                continue;
            }
            if (protoType == null || !this.supportNestedObjects && (this.supportNestedObjects || this.hasNestedObject(tField))) continue;
            this.addProtoField(desBuilder, tField.getName(), tField.getFieldId() + 1, protoType, isContainer);
        }
        return maxThriftId;
    }

    private TStructDescriptor.Field resolveField(TStructDescriptor.Field inputField) {
        if (inputField.isList()) {
            return inputField.getListElemField();
        }
        if (inputField.isSet()) {
            return inputField.getSetElemField();
        }
        return inputField;
    }

    private boolean hasNestedObject(TStructDescriptor.Field field2) {
        return field2.isStruct() || field2.isList() && field2.getListElemField().isStruct() || field2.isSet() && field2.getSetElemField().isStruct() || field2.isMap();
    }

    private DescriptorProtos.DescriptorProto.Builder mapDescriptorProtoBuilder(TStructDescriptor.Field field2, String typeName) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.DescriptorProto.Builder mapBuilder = DescriptorProtos.DescriptorProto.newBuilder().setName(typeName);
        TStructDescriptor.Field keyField = field2.getMapKeyField();
        TStructDescriptor.Field valueField = field2.getMapValueField();
        DescriptorProtos.FieldDescriptorProto.Builder keyBuilder = this.mapKeyProtoBuilder();
        DescriptorProtos.FieldDescriptorProto.Builder valueBuilder = this.mapValueProtoBuilder();
        this.setBuilderTypeFromField(keyField, keyBuilder);
        this.setBuilderTypeFromField(valueField, valueBuilder);
        mapBuilder.addField(keyBuilder.build());
        mapBuilder.addField(valueBuilder.build());
        return mapBuilder;
    }

    private DescriptorProtos.FieldDescriptorProto.Builder mapKeyProtoBuilder() {
        return this.fieldDescriptorProtoBuilder(MAP_KEY_FIELD_NAME, 1).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
    }

    private DescriptorProtos.FieldDescriptorProto.Builder mapValueProtoBuilder() {
        return this.fieldDescriptorProtoBuilder(MAP_VALUE_FIELD_NAME, 2).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
    }

    private void setBuilderTypeFromField(TStructDescriptor.Field field2, DescriptorProtos.FieldDescriptorProto.Builder builder) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.FieldDescriptorProto.Type valueProtoType = this.thriftTypeToProtoType(field2);
        if (valueProtoType == DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE) {
            builder.setTypeName(this.resolveMessageTypeName(field2.gettStructDescriptor()));
        } else if (valueProtoType != null) {
            builder.setType(valueProtoType);
        }
    }

    private String resolveMessageTypeName(TStructDescriptor descriptor) throws Descriptors.DescriptorValidationException {
        String typeName = this.protoMessageType(descriptor.getThriftClass());
        DescriptorProtos.DescriptorProto.Builder builder = this.descriptorBuilderMap.get(typeName);
        if (builder == null) {
            builder = DescriptorProtos.DescriptorProto.newBuilder();
            builder.setName(typeName);
            this.descriptorBuilderMap.put(typeName, builder);
            this.doSchemaMapping(builder, descriptor);
        }
        return typeName;
    }

    private void addProtoField(DescriptorProtos.DescriptorProto.Builder builder, String name2, int fieldIdx, DescriptorProtos.FieldDescriptorProto.Type type, boolean isRepeated) {
        DescriptorProtos.FieldDescriptorProto.Builder fdBuilder = this.fieldDescriptorProtoBuilder(name2, fieldIdx).setType(type);
        if (isRepeated) {
            fdBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED);
        }
        builder.addField(fdBuilder.build());
    }

    private void addProtoField(DescriptorProtos.DescriptorProto.Builder builder, String name2, int fieldIdx, String type, boolean isRepeated) {
        DescriptorProtos.FieldDescriptorProto.Builder fdBuilder = this.fieldDescriptorProtoBuilder(name2, fieldIdx).setTypeName(type);
        if (isRepeated) {
            fdBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED);
        }
        builder.addField(fdBuilder.build());
    }

    private DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorProtoBuilder(String name2, int fieldIdx) {
        DescriptorProtos.FieldDescriptorProto.Builder fdBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder().setName(name2).setNumber(fieldIdx);
        return fdBuilder;
    }

    public Message convert(T thriftObj) {
        return this.doConvert((TBase)Preconditions.checkNotNull(thriftObj, "Can not convert a null object"));
    }

    public <F extends TFieldIdEnum> Message doConvert(TBase<?, F> thriftObj) {
        if (thriftObj == null) {
            return null;
        }
        Class<?> clazz2 = thriftObj.getClass();
        this.checkState(clazz2);
        Message.Builder builder = this.getBuilder(clazz2);
        TStructDescriptor fieldDesc = TStructDescriptor.getInstance(clazz2);
        int fieldId = 0;
        for (TStructDescriptor.Field tField : fieldDesc.getFields()) {
            if (!thriftObj.isSet(tField.getFieldIdEnum()) || !this.supportNestedObjects && this.hasNestedObject(tField)) {
                ++fieldId;
                continue;
            }
            if (this.supportNestedObjects && tField.getType() == 12) {
                TBase fieldValue;
                Message message;
                if ((message = this.doConvert(fieldValue = (TBase)fieldDesc.getFieldValue(fieldId++, thriftObj))) == null) continue;
                Descriptors.FieldDescriptor protoFieldDesc = builder.getDescriptorForType().findFieldByName(tField.getName());
                builder.setField(protoFieldDesc, message);
                continue;
            }
            fieldId = this.convertField(thriftObj, builder, fieldDesc, fieldId, tField);
        }
        return builder.build();
    }

    private void checkState(Class<? extends TBase<?, ?>> thriftClass) {
        Preconditions.checkState(this.hasBuilder(thriftClass), "No message builder found for thrift class: " + thriftClass.getCanonicalName());
    }

    private boolean hasBuilder(Class<? extends TBase<?, ?>> thriftClass) {
        return this.messageBuilderMap.get(this.protoMessageType(thriftClass)) != null;
    }

    private Object sanitizeRawValue(Object value2, TStructDescriptor.Field tField) {
        Object returnValue = value2;
        if (tField.isEnum()) {
            returnValue = returnValue.toString();
        } else if (tField.isBuffer()) {
            returnValue = ByteString.copyFrom((byte[])returnValue);
        }
        if (returnValue instanceof Byte) {
            returnValue = new Integer(((Byte)returnValue).byteValue());
        } else if (returnValue instanceof Short) {
            returnValue = new Integer(((Short)returnValue).shortValue());
        }
        return returnValue;
    }

    private boolean isStructContainer(TStructDescriptor.Field tField) {
        return tField.isList() && tField.getListElemField().isStruct() || tField.isSet() && tField.getSetElemField().isStruct();
    }

    private int convertField(TBase<?, ?> thriftObj, Message.Builder builder, TStructDescriptor fieldDesc, int fieldId, TStructDescriptor.Field tField) {
        LinkedList<Message> fieldValue;
        int tmpFieldId = fieldId;
        Descriptors.FieldDescriptor protoFieldDesc = builder.getDescriptorForType().findFieldByName(tField.getName());
        if (protoFieldDesc == null) {
            DescriptorProtos.FieldDescriptorProto.Type protoType = this.thriftTypeToProtoType(tField);
            if (protoType == null && (this.ignoreUnsupportedTypes || !this.supportNestedObjects && this.hasNestedObject(tField))) {
                return tmpFieldId;
            }
            throw new RuntimeException("Field " + tField.getName() + " not found in dynamic protobuf.");
        }
        if ((fieldValue = fieldDesc.getFieldValue(tmpFieldId++, thriftObj)) == null) {
            return tmpFieldId;
        }
        try {
            if (this.isStructContainer(tField)) {
                LinkedList<Message> convertedStructs = Lists.newLinkedList();
                Iterable structIterator = fieldValue;
                for (TBase tBase : structIterator) {
                    convertedStructs.add(this.doConvert(tBase));
                }
                fieldValue = convertedStructs;
            } else if (tField.isMap()) {
                LinkedList<Message> convertedMapEntries = Lists.newLinkedList();
                Map rawMap = (Map)((Object)fieldValue);
                for (Map.Entry entry2 : rawMap.entrySet()) {
                    Message.Builder mapBuilder = this.mapEntryProtoBuilder(fieldDesc, tField);
                    Message msg = this.buildMapEntryMessage(mapBuilder, tField, entry2.getKey(), entry2.getValue());
                    convertedMapEntries.add(msg);
                }
                fieldValue = convertedMapEntries;
            } else {
                fieldValue = this.sanitizeRawValue(fieldValue, tField);
            }
            if (this.isContainer(tField)) {
                Iterable container2 = fieldValue;
                for (Object obj : container2) {
                    builder.addRepeatedField(protoFieldDesc, obj);
                }
            } else {
                builder.setField(protoFieldDesc, fieldValue);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error(String.format("Could not set protoField(index=%d, name=%s, type=%s) with thriftField(index=%d, name=%s, type=%d, value=%s)", new Object[]{protoFieldDesc.getIndex(), protoFieldDesc.getName(), protoFieldDesc.getType(), tmpFieldId - 1, tField.getName(), tField.getType(), fieldValue}), e);
            throw e;
        }
        return tmpFieldId;
    }

    private Message buildMapEntryMessage(Message.Builder mapBuilder, TStructDescriptor.Field field2, Object mapKey, Object mapValue) {
        Descriptors.FieldDescriptor keyFieldDescriptor = mapBuilder.getDescriptorForType().findFieldByName(MAP_KEY_FIELD_NAME);
        Descriptors.FieldDescriptor valueFieldDescriptor = mapBuilder.getDescriptorForType().findFieldByName(MAP_VALUE_FIELD_NAME);
        boolean isKeyStruct = field2.getMapKeyField().isStruct();
        boolean isValueStruct = field2.getMapValueField().isStruct();
        Object convertedKey = isKeyStruct ? this.doConvert((TBase)mapKey) : this.sanitizeRawValue(mapKey, field2.getMapKeyField());
        Object convertedValue = isValueStruct ? this.doConvert((TBase)mapValue) : this.sanitizeRawValue(mapValue, field2.getMapValueField());
        mapBuilder.setField(keyFieldDescriptor, convertedKey);
        mapBuilder.setField(valueFieldDescriptor, convertedValue);
        return mapBuilder.build();
    }

    private boolean isContainer(TStructDescriptor.Field field2) {
        return field2.isSet() || field2.isList() || field2.isMap();
    }

    private DescriptorProtos.FieldDescriptorProto.Type thriftTypeToProtoType(TStructDescriptor.Field tField) {
        byte thriftType = tField.getType();
        switch (thriftType) {
            case 2: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL;
            }
            case 3: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case 4: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE;
            }
            case 6: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case 8: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case 10: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
            }
            case 11: {
                return tField.isBuffer() ? DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES : DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
            }
            case 16: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
            }
            case 12: {
                if (this.supportNestedObjects) {
                    return DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE;
                }
                return null;
            }
            case 13: {
                return null;
            }
            case 14: {
                return null;
            }
            case 15: {
                return null;
            }
        }
        if (this.ignoreUnsupportedTypes) {
            LOG.warn("Thrift type " + thriftType + " not supported for field " + tField.getName() + ". Ignoring");
            return null;
        }
        throw new IllegalArgumentException("Can't map Thrift type " + thriftType + " to a Protobuf type for field: " + tField.getName());
    }

    private String protoMessageType(Class<? extends TBase<?, ?>> thriftClass) {
        return thriftClass.getCanonicalName().replace(".", "_");
    }

    private String mapProtoMessageType(TStructDescriptor descriptor, TStructDescriptor.Field field2) {
        return String.format("%s_%s", this.protoMessageType(descriptor.getThriftClass()), field2.getName());
    }

    public Descriptors.FieldDescriptor getFieldDescriptor(Class<? extends TBase<?, ?>> thriftClass, String fieldName) {
        this.checkState(thriftClass);
        Descriptors.Descriptor descriptor = this.getBuilder(thriftClass).getDescriptorForType();
        return descriptor.findFieldByName(fieldName);
    }

    public Descriptors.FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }
}

